// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Detailed information about an event to which you have subscribed.
 */
public class EventSubscription private constructor(builder: Builder) {
    /**
     * The Amazon DocumentDB event notification subscription ID.
     */
    public val custSubscriptionId: kotlin.String? = builder.custSubscriptionId
    /**
     * The Amazon Web Services customer account that is associated with the Amazon DocumentDB event notification subscription.
     */
    public val customerAwsId: kotlin.String? = builder.customerAwsId
    /**
     * A Boolean value indicating whether the subscription is enabled. A value of `true` indicates that the subscription is enabled.
     */
    public val enabled: kotlin.Boolean = builder.enabled
    /**
     * A list of event categories for the Amazon DocumentDB event notification subscription.
     */
    public val eventCategoriesList: List<String>? = builder.eventCategoriesList
    /**
     * The Amazon Resource Name (ARN) for the event subscription.
     */
    public val eventSubscriptionArn: kotlin.String? = builder.eventSubscriptionArn
    /**
     * The topic ARN of the Amazon DocumentDB event notification subscription.
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * A list of source IDs for the Amazon DocumentDB event notification subscription.
     */
    public val sourceIdsList: List<String>? = builder.sourceIdsList
    /**
     * The source type for the Amazon DocumentDB event notification subscription.
     */
    public val sourceType: kotlin.String? = builder.sourceType
    /**
     * The status of the Amazon DocumentDB event notification subscription.
     *
     * Constraints:
     *
     * Can be one of the following: `creating`, `modifying`, `deleting`, `active`, `no-permission`, `topic-not-exist`
     *
     * The `no-permission` status indicates that Amazon DocumentDB no longer has permission to post to the SNS topic. The `topic-not-exist` status indicates that the topic was deleted after the subscription was created.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The time at which the Amazon DocumentDB event notification subscription was created.
     */
    public val subscriptionCreationTime: kotlin.String? = builder.subscriptionCreationTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.EventSubscription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventSubscription(")
        append("custSubscriptionId=$custSubscriptionId,")
        append("customerAwsId=$customerAwsId,")
        append("enabled=$enabled,")
        append("eventCategoriesList=$eventCategoriesList,")
        append("eventSubscriptionArn=$eventSubscriptionArn,")
        append("snsTopicArn=$snsTopicArn,")
        append("sourceIdsList=$sourceIdsList,")
        append("sourceType=$sourceType,")
        append("status=$status,")
        append("subscriptionCreationTime=$subscriptionCreationTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = custSubscriptionId?.hashCode() ?: 0
        result = 31 * result + (customerAwsId?.hashCode() ?: 0)
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (eventCategoriesList?.hashCode() ?: 0)
        result = 31 * result + (eventSubscriptionArn?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (sourceIdsList?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subscriptionCreationTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventSubscription

        if (custSubscriptionId != other.custSubscriptionId) return false
        if (customerAwsId != other.customerAwsId) return false
        if (enabled != other.enabled) return false
        if (eventCategoriesList != other.eventCategoriesList) return false
        if (eventSubscriptionArn != other.eventSubscriptionArn) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (sourceIdsList != other.sourceIdsList) return false
        if (sourceType != other.sourceType) return false
        if (status != other.status) return false
        if (subscriptionCreationTime != other.subscriptionCreationTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.EventSubscription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon DocumentDB event notification subscription ID.
         */
        public var custSubscriptionId: kotlin.String? = null
        /**
         * The Amazon Web Services customer account that is associated with the Amazon DocumentDB event notification subscription.
         */
        public var customerAwsId: kotlin.String? = null
        /**
         * A Boolean value indicating whether the subscription is enabled. A value of `true` indicates that the subscription is enabled.
         */
        public var enabled: kotlin.Boolean = false
        /**
         * A list of event categories for the Amazon DocumentDB event notification subscription.
         */
        public var eventCategoriesList: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) for the event subscription.
         */
        public var eventSubscriptionArn: kotlin.String? = null
        /**
         * The topic ARN of the Amazon DocumentDB event notification subscription.
         */
        public var snsTopicArn: kotlin.String? = null
        /**
         * A list of source IDs for the Amazon DocumentDB event notification subscription.
         */
        public var sourceIdsList: List<String>? = null
        /**
         * The source type for the Amazon DocumentDB event notification subscription.
         */
        public var sourceType: kotlin.String? = null
        /**
         * The status of the Amazon DocumentDB event notification subscription.
         *
         * Constraints:
         *
         * Can be one of the following: `creating`, `modifying`, `deleting`, `active`, `no-permission`, `topic-not-exist`
         *
         * The `no-permission` status indicates that Amazon DocumentDB no longer has permission to post to the SNS topic. The `topic-not-exist` status indicates that the topic was deleted after the subscription was created.
         */
        public var status: kotlin.String? = null
        /**
         * The time at which the Amazon DocumentDB event notification subscription was created.
         */
        public var subscriptionCreationTime: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.EventSubscription) : this() {
            this.custSubscriptionId = x.custSubscriptionId
            this.customerAwsId = x.customerAwsId
            this.enabled = x.enabled
            this.eventCategoriesList = x.eventCategoriesList
            this.eventSubscriptionArn = x.eventSubscriptionArn
            this.snsTopicArn = x.snsTopicArn
            this.sourceIdsList = x.sourceIdsList
            this.sourceType = x.sourceType
            this.status = x.status
            this.subscriptionCreationTime = x.subscriptionCreationTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.EventSubscription = EventSubscription(this)
    }
}
