// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * A data type representing an Amazon DocumentDB global cluster.
 */
public class GlobalCluster private constructor(builder: Builder) {
    /**
     * The default database name within the new global cluster.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The deletion protection setting for the new global cluster.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The Amazon DocumentDB database engine used by the global cluster.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * Indicates the database engine version.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The Amazon Resource Name (ARN) for the global cluster.
     */
    public val globalClusterArn: kotlin.String? = builder.globalClusterArn
    /**
     * Contains a user-supplied global cluster identifier. This identifier is the unique key that identifies a global cluster.
     */
    public val globalClusterIdentifier: kotlin.String? = builder.globalClusterIdentifier
    /**
     * The list of cluster IDs for secondary clusters within the global cluster. Currently limited to one item.
     */
    public val globalClusterMembers: List<GlobalClusterMember>? = builder.globalClusterMembers
    /**
     * The Amazon Web Services Region-unique, immutable identifier for the global database cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS customer master key (CMK) for the cluster is accessed.
     */
    public val globalClusterResourceId: kotlin.String? = builder.globalClusterResourceId
    /**
     * Specifies the current state of this global cluster.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The storage encryption setting for the global cluster.
     */
    public val storageEncrypted: kotlin.Boolean? = builder.storageEncrypted

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.GlobalCluster = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GlobalCluster(")
        append("databaseName=$databaseName,")
        append("deletionProtection=$deletionProtection,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("globalClusterArn=$globalClusterArn,")
        append("globalClusterIdentifier=$globalClusterIdentifier,")
        append("globalClusterMembers=$globalClusterMembers,")
        append("globalClusterResourceId=$globalClusterResourceId,")
        append("status=$status,")
        append("storageEncrypted=$storageEncrypted)")
    }

    override fun hashCode(): kotlin.Int {
        var result = databaseName?.hashCode() ?: 0
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (globalClusterArn?.hashCode() ?: 0)
        result = 31 * result + (globalClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (globalClusterMembers?.hashCode() ?: 0)
        result = 31 * result + (globalClusterResourceId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GlobalCluster

        if (databaseName != other.databaseName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (globalClusterArn != other.globalClusterArn) return false
        if (globalClusterIdentifier != other.globalClusterIdentifier) return false
        if (globalClusterMembers != other.globalClusterMembers) return false
        if (globalClusterResourceId != other.globalClusterResourceId) return false
        if (status != other.status) return false
        if (storageEncrypted != other.storageEncrypted) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.GlobalCluster = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The default database name within the new global cluster.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The deletion protection setting for the new global cluster.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The Amazon DocumentDB database engine used by the global cluster.
         */
        public var engine: kotlin.String? = null
        /**
         * Indicates the database engine version.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the global cluster.
         */
        public var globalClusterArn: kotlin.String? = null
        /**
         * Contains a user-supplied global cluster identifier. This identifier is the unique key that identifies a global cluster.
         */
        public var globalClusterIdentifier: kotlin.String? = null
        /**
         * The list of cluster IDs for secondary clusters within the global cluster. Currently limited to one item.
         */
        public var globalClusterMembers: List<GlobalClusterMember>? = null
        /**
         * The Amazon Web Services Region-unique, immutable identifier for the global database cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS customer master key (CMK) for the cluster is accessed.
         */
        public var globalClusterResourceId: kotlin.String? = null
        /**
         * Specifies the current state of this global cluster.
         */
        public var status: kotlin.String? = null
        /**
         * The storage encryption setting for the global cluster.
         */
        public var storageEncrypted: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.GlobalCluster) : this() {
            this.databaseName = x.databaseName
            this.deletionProtection = x.deletionProtection
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.globalClusterArn = x.globalClusterArn
            this.globalClusterIdentifier = x.globalClusterIdentifier
            this.globalClusterMembers = x.globalClusterMembers
            this.globalClusterResourceId = x.globalClusterResourceId
            this.status = x.status
            this.storageEncrypted = x.storageEncrypted
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.GlobalCluster = GlobalCluster(this)
    }
}
