// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to ModifyDBInstance.
 */
public class ModifyDbInstanceRequest private constructor(builder: Builder) {
    /**
     * Specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the `PreferredMaintenanceWindow` setting for the instance.
     *
     *  If this parameter is set to `false`, changes to the instance are applied during the next maintenance window. Some parameter changes can cause an outage and are applied on the next reboot.
     *
     * Default: `false`
     */
    public val applyImmediately: kotlin.Boolean = builder.applyImmediately
    /**
     * This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * Indicates the certificate that needs to be associated with the instance.
     */
    public val caCertificateIdentifier: kotlin.String? = builder.caCertificateIdentifier
    /**
     * A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * The new compute and memory capacity of the instance; for example, `db.r5.large`. Not all instance classes are available in all Amazon Web Services Regions.
     *
     * If you modify the instance class, an outage occurs during the change. The change is applied during the next maintenance window, unless `ApplyImmediately` is specified as `true` for this request.
     *
     * Default: Uses existing setting.
     */
    public val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * The instance identifier. This value is stored as a lowercase string.
     *
     * Constraints:
     * + Must match the identifier of an existing `DBInstance`.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * A value that indicates whether to enable Performance Insights for the DB Instance. For more information, see [Using Amazon Performance Insights](https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html).
     */
    public val enablePerformanceInsights: kotlin.Boolean? = builder.enablePerformanceInsights
    /**
     * The new instance identifier for the instance when renaming an instance. When you change the instance identifier, an instance reboot occurs immediately if you set `Apply Immediately` to `true`. It occurs during the next maintenance window if you set `Apply Immediately` to `false`. This value is stored as a lowercase string.
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens.
     * + The first character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     *
     * Example: `mydbinstance`
     */
    public val newDbInstanceIdentifier: kotlin.String? = builder.newDbInstanceIdentifier
    /**
     * The KMS key identifier for encryption of Performance Insights data.
     *
     * The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     *
     * If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services region.
     */
    public val performanceInsightsKmsKeyId: kotlin.String? = builder.performanceInsightsKmsKeyId
    /**
     * The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage. Changing this parameter doesn't result in an outage except in the following situation, and the change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance window is changed to include the current time, changing this parameter causes a reboot of the instance. If you are moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure that pending changes are applied.
     *
     * Default: Uses existing setting.
     *
     * Format: `ddd:hh24:mi-ddd:hh24:mi`
     *
     * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
     *
     * Constraints: Must be at least 30 minutes.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.
     *
     * Default: 1
     *
     * Valid values: 0-15
     */
    public val promotionTier: kotlin.Int? = builder.promotionTier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.ModifyDbInstanceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDbInstanceRequest(")
        append("applyImmediately=$applyImmediately,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("caCertificateIdentifier=$caCertificateIdentifier,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("enablePerformanceInsights=$enablePerformanceInsights,")
        append("newDbInstanceIdentifier=$newDbInstanceIdentifier,")
        append("performanceInsightsKmsKeyId=$performanceInsightsKmsKeyId,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("promotionTier=$promotionTier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyImmediately.hashCode()
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (caCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (enablePerformanceInsights?.hashCode() ?: 0)
        result = 31 * result + (newDbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (promotionTier ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyDbInstanceRequest

        if (applyImmediately != other.applyImmediately) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (caCertificateIdentifier != other.caCertificateIdentifier) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (enablePerformanceInsights != other.enablePerformanceInsights) return false
        if (newDbInstanceIdentifier != other.newDbInstanceIdentifier) return false
        if (performanceInsightsKmsKeyId != other.performanceInsightsKmsKeyId) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (promotionTier != other.promotionTier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.ModifyDbInstanceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the `PreferredMaintenanceWindow` setting for the instance.
         *
         *  If this parameter is set to `false`, changes to the instance are applied during the next maintenance window. Some parameter changes can cause an outage and are applied on the next reboot.
         *
         * Default: `false`
         */
        public var applyImmediately: kotlin.Boolean = false
        /**
         * This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * Indicates the certificate that needs to be associated with the instance.
         */
        public var caCertificateIdentifier: kotlin.String? = null
        /**
         * A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * The new compute and memory capacity of the instance; for example, `db.r5.large`. Not all instance classes are available in all Amazon Web Services Regions.
         *
         * If you modify the instance class, an outage occurs during the change. The change is applied during the next maintenance window, unless `ApplyImmediately` is specified as `true` for this request.
         *
         * Default: Uses existing setting.
         */
        public var dbInstanceClass: kotlin.String? = null
        /**
         * The instance identifier. This value is stored as a lowercase string.
         *
         * Constraints:
         * + Must match the identifier of an existing `DBInstance`.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * A value that indicates whether to enable Performance Insights for the DB Instance. For more information, see [Using Amazon Performance Insights](https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html).
         */
        public var enablePerformanceInsights: kotlin.Boolean? = null
        /**
         * The new instance identifier for the instance when renaming an instance. When you change the instance identifier, an instance reboot occurs immediately if you set `Apply Immediately` to `true`. It occurs during the next maintenance window if you set `Apply Immediately` to `false`. This value is stored as a lowercase string.
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens.
         * + The first character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         *
         * Example: `mydbinstance`
         */
        public var newDbInstanceIdentifier: kotlin.String? = null
        /**
         * The KMS key identifier for encryption of Performance Insights data.
         *
         * The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         *
         * If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services region.
         */
        public var performanceInsightsKmsKeyId: kotlin.String? = null
        /**
         * The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage. Changing this parameter doesn't result in an outage except in the following situation, and the change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance window is changed to include the current time, changing this parameter causes a reboot of the instance. If you are moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure that pending changes are applied.
         *
         * Default: Uses existing setting.
         *
         * Format: `ddd:hh24:mi-ddd:hh24:mi`
         *
         * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         *
         * Constraints: Must be at least 30 minutes.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.
         *
         * Default: 1
         *
         * Valid values: 0-15
         */
        public var promotionTier: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.ModifyDbInstanceRequest) : this() {
            this.applyImmediately = x.applyImmediately
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.caCertificateIdentifier = x.caCertificateIdentifier
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.enablePerformanceInsights = x.enablePerformanceInsights
            this.newDbInstanceIdentifier = x.newDbInstanceIdentifier
            this.performanceInsightsKmsKeyId = x.performanceInsightsKmsKeyId
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.promotionTier = x.promotionTier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.ModifyDbInstanceRequest = ModifyDbInstanceRequest(this)
    }
}
