// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to RestoreDBClusterFromSnapshot.
 */
public class RestoreDbClusterFromSnapshotRequest private constructor(builder: Builder) {
    /**
     * Provides the list of Amazon EC2 Availability Zones that instances in the restored DB cluster can be created in.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * The name of the cluster to create from the snapshot or cluster snapshot. This parameter isn't case sensitive.
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens.
     * + The first character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     *
     * Example: `my-snapshot-id`
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The name of the subnet group to use for the new cluster.
     *
     * Constraints: If provided, must match the name of an existing `DBSubnetGroup`.
     *
     * Example: `mySubnetgroup`
     */
    public val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * Specifies whether this cluster can be deleted. If `DeletionProtection` is enabled, the cluster cannot be deleted unless it is modified and `DeletionProtection` is disabled. `DeletionProtection` protects clusters from being accidentally deleted.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.
     */
    public val enableCloudwatchLogsExports: List<String>? = builder.enableCloudwatchLogsExports
    /**
     * The database engine to use for the new cluster.
     *
     * Default: The same as source.
     *
     * Constraint: Must be compatible with the engine of the source.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The version of the database engine to use for the new cluster.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The KMS key identifier to use when restoring an encrypted cluster from a DB snapshot or cluster snapshot.
     *
     * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same Amazon Web Services account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
     *
     * If you do not specify a value for the `KmsKeyId` parameter, then the following occurs:
     * + If the snapshot or cluster snapshot in `SnapshotIdentifier` is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the snapshot or the cluster snapshot.
     * + If the snapshot or the cluster snapshot in `SnapshotIdentifier` is not encrypted, then the restored DB cluster is not encrypted.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The port number on which the new cluster accepts connections.
     *
     * Constraints: Must be a value from `1150` to `65535`.
     *
     * Default: The same port as the original cluster.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The identifier for the snapshot or cluster snapshot to restore from.
     *
     * You can use either the name or the Amazon Resource Name (ARN) to specify a cluster snapshot. However, you can use only the ARN to specify a snapshot.
     *
     * Constraints:
     * + Must match the identifier of an existing snapshot.
     */
    public val snapshotIdentifier: kotlin.String? = builder.snapshotIdentifier
    /**
     * The tags to be assigned to the restored cluster.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A list of virtual private cloud (VPC) security groups that the new cluster will belong to.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.RestoreDbClusterFromSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreDbClusterFromSnapshotRequest(")
        append("availabilityZones=$availabilityZones,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("enableCloudwatchLogsExports=$enableCloudwatchLogsExports,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("kmsKeyId=$kmsKeyId,")
        append("port=$port,")
        append("snapshotIdentifier=$snapshotIdentifier,")
        append("tags=$tags,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (enableCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreDbClusterFromSnapshotRequest

        if (availabilityZones != other.availabilityZones) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (enableCloudwatchLogsExports != other.enableCloudwatchLogsExports) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (port != other.port) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false
        if (tags != other.tags) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.RestoreDbClusterFromSnapshotRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Provides the list of Amazon EC2 Availability Zones that instances in the restored DB cluster can be created in.
         */
        public var availabilityZones: List<String>? = null
        /**
         * The name of the cluster to create from the snapshot or cluster snapshot. This parameter isn't case sensitive.
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens.
         * + The first character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         *
         * Example: `my-snapshot-id`
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The name of the subnet group to use for the new cluster.
         *
         * Constraints: If provided, must match the name of an existing `DBSubnetGroup`.
         *
         * Example: `mySubnetgroup`
         */
        public var dbSubnetGroupName: kotlin.String? = null
        /**
         * Specifies whether this cluster can be deleted. If `DeletionProtection` is enabled, the cluster cannot be deleted unless it is modified and `DeletionProtection` is disabled. `DeletionProtection` protects clusters from being accidentally deleted.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.
         */
        public var enableCloudwatchLogsExports: List<String>? = null
        /**
         * The database engine to use for the new cluster.
         *
         * Default: The same as source.
         *
         * Constraint: Must be compatible with the engine of the source.
         */
        public var engine: kotlin.String? = null
        /**
         * The version of the database engine to use for the new cluster.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The KMS key identifier to use when restoring an encrypted cluster from a DB snapshot or cluster snapshot.
         *
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same Amazon Web Services account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
         *
         * If you do not specify a value for the `KmsKeyId` parameter, then the following occurs:
         * + If the snapshot or cluster snapshot in `SnapshotIdentifier` is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the snapshot or the cluster snapshot.
         * + If the snapshot or the cluster snapshot in `SnapshotIdentifier` is not encrypted, then the restored DB cluster is not encrypted.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The port number on which the new cluster accepts connections.
         *
         * Constraints: Must be a value from `1150` to `65535`.
         *
         * Default: The same port as the original cluster.
         */
        public var port: kotlin.Int? = null
        /**
         * The identifier for the snapshot or cluster snapshot to restore from.
         *
         * You can use either the name or the Amazon Resource Name (ARN) to specify a cluster snapshot. However, you can use only the ARN to specify a snapshot.
         *
         * Constraints:
         * + Must match the identifier of an existing snapshot.
         */
        public var snapshotIdentifier: kotlin.String? = null
        /**
         * The tags to be assigned to the restored cluster.
         */
        public var tags: List<Tag>? = null
        /**
         * A list of virtual private cloud (VPC) security groups that the new cluster will belong to.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.RestoreDbClusterFromSnapshotRequest) : this() {
            this.availabilityZones = x.availabilityZones
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.deletionProtection = x.deletionProtection
            this.enableCloudwatchLogsExports = x.enableCloudwatchLogsExports
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.kmsKeyId = x.kmsKeyId
            this.port = x.port
            this.snapshotIdentifier = x.snapshotIdentifier
            this.tags = x.tags
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.RestoreDbClusterFromSnapshotRequest = RestoreDbClusterFromSnapshotRequest(this)
    }
}
