// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the input to RestoreDBClusterToPointInTime.
 */
public class RestoreDbClusterToPointInTimeRequest private constructor(builder: Builder) {
    /**
     * The name of the new cluster to be created.
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens.
     * + The first character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The subnet group name to use for the new cluster.
     *
     * Constraints: If provided, must match the name of an existing `DBSubnetGroup`.
     *
     * Example: `mySubnetgroup`
     */
    public val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * Specifies whether this cluster can be deleted. If `DeletionProtection` is enabled, the cluster cannot be deleted unless it is modified and `DeletionProtection` is disabled. `DeletionProtection` protects clusters from being accidentally deleted.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.
     */
    public val enableCloudwatchLogsExports: List<String>? = builder.enableCloudwatchLogsExports
    /**
     * The KMS key identifier to use when restoring an encrypted cluster from an encrypted cluster.
     *
     * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same Amazon Web Services account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
     *
     * You can restore to a new cluster and encrypt the new cluster with an KMS key that is different from the KMS key used to encrypt the source cluster. The new DB cluster is encrypted with the KMS key identified by the `KmsKeyId` parameter.
     *
     * If you do not specify a value for the `KmsKeyId` parameter, then the following occurs:
     * + If the cluster is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the source cluster.
     * + If the cluster is not encrypted, then the restored cluster is not encrypted.
     *
     * If `DBClusterIdentifier` refers to a cluster that is not encrypted, then the restore request is rejected.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The port number on which the new cluster accepts connections.
     *
     * Constraints: Must be a value from `1150` to `65535`.
     *
     * Default: The default port for the engine.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The date and time to restore the cluster to.
     *
     * Valid values: A time in Universal Coordinated Time (UTC) format.
     *
     * Constraints:
     * + Must be before the latest restorable time for the instance.
     * + Must be specified if the `UseLatestRestorableTime` parameter is not provided.
     * + Cannot be specified if the `UseLatestRestorableTime` parameter is `true`.
     * + Cannot be specified if the `RestoreType` parameter is `copy-on-write`.
     *
     * Example: `2015-03-07T23:45:00Z`
     */
    public val restoreToTime: aws.smithy.kotlin.runtime.time.Instant? = builder.restoreToTime
    /**
     * The type of restore to be performed. You can specify one of the following values:
     * + `full-copy` - The new DB cluster is restored as a full copy of the source DB cluster.
     * + `copy-on-write` - The new DB cluster is restored as a clone of the source DB cluster.
     *
     * If you don't specify a `RestoreType` value, then the new DB cluster is restored as a full copy of the source DB cluster.
     */
    public val restoreType: kotlin.String? = builder.restoreType
    /**
     * The identifier of the source cluster from which to restore.
     *
     * Constraints:
     * + Must match the identifier of an existing `DBCluster`.
     */
    public val sourceDbClusterIdentifier: kotlin.String? = builder.sourceDbClusterIdentifier
    /**
     * The tags to be assigned to the restored cluster.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A value that is set to `true` to restore the cluster to the latest restorable backup time, and `false` otherwise.
     *
     * Default: `false`
     *
     * Constraints: Cannot be specified if the `RestoreToTime` parameter is provided.
     */
    public val useLatestRestorableTime: kotlin.Boolean = builder.useLatestRestorableTime
    /**
     * A list of VPC security groups that the new cluster belongs to.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.RestoreDbClusterToPointInTimeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreDbClusterToPointInTimeRequest(")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("enableCloudwatchLogsExports=$enableCloudwatchLogsExports,")
        append("kmsKeyId=$kmsKeyId,")
        append("port=$port,")
        append("restoreToTime=$restoreToTime,")
        append("restoreType=$restoreType,")
        append("sourceDbClusterIdentifier=$sourceDbClusterIdentifier,")
        append("tags=$tags,")
        append("useLatestRestorableTime=$useLatestRestorableTime,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (enableCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (restoreToTime?.hashCode() ?: 0)
        result = 31 * result + (restoreType?.hashCode() ?: 0)
        result = 31 * result + (sourceDbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (useLatestRestorableTime.hashCode())
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreDbClusterToPointInTimeRequest

        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (enableCloudwatchLogsExports != other.enableCloudwatchLogsExports) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (port != other.port) return false
        if (restoreToTime != other.restoreToTime) return false
        if (restoreType != other.restoreType) return false
        if (sourceDbClusterIdentifier != other.sourceDbClusterIdentifier) return false
        if (tags != other.tags) return false
        if (useLatestRestorableTime != other.useLatestRestorableTime) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.RestoreDbClusterToPointInTimeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the new cluster to be created.
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens.
         * + The first character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The subnet group name to use for the new cluster.
         *
         * Constraints: If provided, must match the name of an existing `DBSubnetGroup`.
         *
         * Example: `mySubnetgroup`
         */
        public var dbSubnetGroupName: kotlin.String? = null
        /**
         * Specifies whether this cluster can be deleted. If `DeletionProtection` is enabled, the cluster cannot be deleted unless it is modified and `DeletionProtection` is disabled. `DeletionProtection` protects clusters from being accidentally deleted.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.
         */
        public var enableCloudwatchLogsExports: List<String>? = null
        /**
         * The KMS key identifier to use when restoring an encrypted cluster from an encrypted cluster.
         *
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same Amazon Web Services account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
         *
         * You can restore to a new cluster and encrypt the new cluster with an KMS key that is different from the KMS key used to encrypt the source cluster. The new DB cluster is encrypted with the KMS key identified by the `KmsKeyId` parameter.
         *
         * If you do not specify a value for the `KmsKeyId` parameter, then the following occurs:
         * + If the cluster is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the source cluster.
         * + If the cluster is not encrypted, then the restored cluster is not encrypted.
         *
         * If `DBClusterIdentifier` refers to a cluster that is not encrypted, then the restore request is rejected.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The port number on which the new cluster accepts connections.
         *
         * Constraints: Must be a value from `1150` to `65535`.
         *
         * Default: The default port for the engine.
         */
        public var port: kotlin.Int? = null
        /**
         * The date and time to restore the cluster to.
         *
         * Valid values: A time in Universal Coordinated Time (UTC) format.
         *
         * Constraints:
         * + Must be before the latest restorable time for the instance.
         * + Must be specified if the `UseLatestRestorableTime` parameter is not provided.
         * + Cannot be specified if the `UseLatestRestorableTime` parameter is `true`.
         * + Cannot be specified if the `RestoreType` parameter is `copy-on-write`.
         *
         * Example: `2015-03-07T23:45:00Z`
         */
        public var restoreToTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of restore to be performed. You can specify one of the following values:
         * + `full-copy` - The new DB cluster is restored as a full copy of the source DB cluster.
         * + `copy-on-write` - The new DB cluster is restored as a clone of the source DB cluster.
         *
         * If you don't specify a `RestoreType` value, then the new DB cluster is restored as a full copy of the source DB cluster.
         */
        public var restoreType: kotlin.String? = null
        /**
         * The identifier of the source cluster from which to restore.
         *
         * Constraints:
         * + Must match the identifier of an existing `DBCluster`.
         */
        public var sourceDbClusterIdentifier: kotlin.String? = null
        /**
         * The tags to be assigned to the restored cluster.
         */
        public var tags: List<Tag>? = null
        /**
         * A value that is set to `true` to restore the cluster to the latest restorable backup time, and `false` otherwise.
         *
         * Default: `false`
         *
         * Constraints: Cannot be specified if the `RestoreToTime` parameter is provided.
         */
        public var useLatestRestorableTime: kotlin.Boolean = false
        /**
         * A list of VPC security groups that the new cluster belongs to.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.RestoreDbClusterToPointInTimeRequest) : this() {
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.deletionProtection = x.deletionProtection
            this.enableCloudwatchLogsExports = x.enableCloudwatchLogsExports
            this.kmsKeyId = x.kmsKeyId
            this.port = x.port
            this.restoreToTime = x.restoreToTime
            this.restoreType = x.restoreType
            this.sourceDbClusterIdentifier = x.sourceDbClusterIdentifier
            this.tags = x.tags
            this.useLatestRestorableTime = x.useLatestRestorableTime
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.RestoreDbClusterToPointInTimeRequest = RestoreDbClusterToPointInTimeRequest(this)
    }
}
