// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.docdb.model.CopyDbClusterSnapshotResponse
import aws.sdk.kotlin.services.docdb.model.DbClusterSnapshot
import aws.sdk.kotlin.services.docdb.model.DocDbException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class CopyDBClusterSnapshotOperationDeserializer: HttpDeserialize<CopyDbClusterSnapshotResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CopyDbClusterSnapshotResponse {
        if (!response.status.isSuccess()) {
            throwCopyDbClusterSnapshotError(context, response)
        }
        val builder = CopyDbClusterSnapshotResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCopyDBClusterSnapshotOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCopyDbClusterSnapshotError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw DocDbException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterSnapshotAlreadyExistsFault" -> DbClusterSnapshotAlreadyExistsFaultDeserializer().deserialize(context, wrappedResponse)
        "DBClusterSnapshotNotFoundFault" -> DbClusterSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBClusterSnapshotStateFault" -> InvalidDbClusterSnapshotStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedResponse)
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedResponse)
        "SnapshotQuotaExceeded" -> SnapshotQuotaExceededFaultDeserializer().deserialize(context, wrappedResponse)
        else -> DocDbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCopyDBClusterSnapshotOperationBody(builder: CopyDbClusterSnapshotResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CopyDBClusterSnapshotResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("CopyDBClusterSnapshotResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap CopyDBClusterSnapshot response")
    }
    // end unwrap response wrapper

    val DBCLUSTERSNAPSHOT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DBClusterSnapshot"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://rds.amazonaws.com/doc/2014-10-31/"))
        trait(XmlSerialName("CopyDBClusterSnapshotResult"))
        field(DBCLUSTERSNAPSHOT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DBCLUSTERSNAPSHOT_DESCRIPTOR.index -> builder.dbClusterSnapshot = deserializeDbClusterSnapshotDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
