// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.transform

import aws.sdk.kotlin.services.docdb.model.RestoreDbClusterToPointInTimeRequest
import aws.sdk.kotlin.services.docdb.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlCollectionName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class RestoreDBClusterToPointInTimeOperationSerializer: HttpSerialize<RestoreDbClusterToPointInTimeRequest> {
    override suspend fun serialize(context: ExecutionContext, input: RestoreDbClusterToPointInTimeRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeRestoreDBClusterToPointInTimeOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeRestoreDBClusterToPointInTimeOperationBody(context: ExecutionContext, input: RestoreDbClusterToPointInTimeRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val DBCLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DBClusterIdentifier"))
    val DBSUBNETGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DBSubnetGroupName"))
    val DELETIONPROTECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("DeletionProtection"))
    val ENABLECLOUDWATCHLOGSEXPORTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("EnableCloudwatchLogsExports"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("KmsKeyId"))
    val PORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("Port"))
    val RESTORETOTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, FormUrlSerialName("RestoreToTime"))
    val RESTORETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("RestoreType"))
    val SOURCEDBCLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SourceDBClusterIdentifier"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Tags"), FormUrlCollectionName("Tag"))
    val USELATESTRESTORABLETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("UseLatestRestorableTime"))
    val VPCSECURITYGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("VpcSecurityGroupIds"), FormUrlCollectionName("VpcSecurityGroupId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("RestoreDBClusterToPointInTimeMessage"))
        trait(QueryLiteral("Action", "RestoreDBClusterToPointInTime"))
        trait(QueryLiteral("Version", "2014-10-31"))
        field(DBCLUSTERIDENTIFIER_DESCRIPTOR)
        field(DBSUBNETGROUPNAME_DESCRIPTOR)
        field(DELETIONPROTECTION_DESCRIPTOR)
        field(ENABLECLOUDWATCHLOGSEXPORTS_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(PORT_DESCRIPTOR)
        field(RESTORETOTIME_DESCRIPTOR)
        field(RESTORETYPE_DESCRIPTOR)
        field(SOURCEDBCLUSTERIDENTIFIER_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(USELATESTRESTORABLETIME_DESCRIPTOR)
        field(VPCSECURITYGROUPIDS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.dbClusterIdentifier?.let { field(DBCLUSTERIDENTIFIER_DESCRIPTOR, it) }
        input.dbSubnetGroupName?.let { field(DBSUBNETGROUPNAME_DESCRIPTOR, it) }
        input.deletionProtection?.let { field(DELETIONPROTECTION_DESCRIPTOR, it) }
        if (input.enableCloudwatchLogsExports != null) {
            listField(ENABLECLOUDWATCHLOGSEXPORTS_DESCRIPTOR) {
                for (el0 in input.enableCloudwatchLogsExports) {
                    serializeString(el0)
                }
            }
        }
        input.kmsKeyId?.let { field(KMSKEYID_DESCRIPTOR, it) }
        input.port?.let { field(PORT_DESCRIPTOR, it) }
        input.restoreToTime?.let { field(RESTORETOTIME_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
        input.restoreType?.let { field(RESTORETYPE_DESCRIPTOR, it) }
        input.sourceDbClusterIdentifier?.let { field(SOURCEDBCLUSTERIDENTIFIER_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        if (input.useLatestRestorableTime != false) field(USELATESTRESTORABLETIME_DESCRIPTOR, input.useLatestRestorableTime)
        if (input.vpcSecurityGroupIds != null) {
            listField(VPCSECURITYGROUPIDS_DESCRIPTOR) {
                for (el0 in input.vpcSecurityGroupIds) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
