// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A certificate authority (CA) certificate for an account.
 */
class Certificate private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the certificate.
     * Example: arn:aws:rds:us-east-1::cert:rds-ca-2019
     */
    val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * The unique key that identifies a certificate.
     * Example: rds-ca-2019
     */
    val certificateIdentifier: kotlin.String? = builder.certificateIdentifier
    /**
     * The type of the certificate.
     * Example: CA
     */
    val certificateType: kotlin.String? = builder.certificateType
    /**
     * The thumbprint of the certificate.
     */
    val thumbprint: kotlin.String? = builder.thumbprint
    /**
     * The starting date-time from which the certificate is valid.
     * Example: 2019-07-31T17:57:09Z
     */
    val validFrom: aws.smithy.kotlin.runtime.time.Instant? = builder.validFrom
    /**
     * The date-time after which the certificate is no longer valid.
     * Example: 2024-07-31T17:57:09Z
     */
    val validTill: aws.smithy.kotlin.runtime.time.Instant? = builder.validTill

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.Certificate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Certificate(")
        append("certificateArn=$certificateArn,")
        append("certificateIdentifier=$certificateIdentifier,")
        append("certificateType=$certificateType,")
        append("thumbprint=$thumbprint,")
        append("validFrom=$validFrom,")
        append("validTill=$validTill)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (certificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (certificateType?.hashCode() ?: 0)
        result = 31 * result + (thumbprint?.hashCode() ?: 0)
        result = 31 * result + (validFrom?.hashCode() ?: 0)
        result = 31 * result + (validTill?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Certificate

        if (certificateArn != other.certificateArn) return false
        if (certificateIdentifier != other.certificateIdentifier) return false
        if (certificateType != other.certificateType) return false
        if (thumbprint != other.thumbprint) return false
        if (validFrom != other.validFrom) return false
        if (validTill != other.validTill) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.Certificate = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) for the certificate.
         * Example: arn:aws:rds:us-east-1::cert:rds-ca-2019
         */
        var certificateArn: kotlin.String? = null
        /**
         * The unique key that identifies a certificate.
         * Example: rds-ca-2019
         */
        var certificateIdentifier: kotlin.String? = null
        /**
         * The type of the certificate.
         * Example: CA
         */
        var certificateType: kotlin.String? = null
        /**
         * The thumbprint of the certificate.
         */
        var thumbprint: kotlin.String? = null
        /**
         * The starting date-time from which the certificate is valid.
         * Example: 2019-07-31T17:57:09Z
         */
        var validFrom: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date-time after which the certificate is no longer valid.
         * Example: 2024-07-31T17:57:09Z
         */
        var validTill: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.Certificate) : this() {
            this.certificateArn = x.certificateArn
            this.certificateIdentifier = x.certificateIdentifier
            this.certificateType = x.certificateType
            this.thumbprint = x.thumbprint
            this.validFrom = x.validFrom
            this.validTill = x.validTill
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.Certificate = Certificate(this)
    }
}
