// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to CopyDBClusterSnapshot.
 */
class CopyDbClusterSnapshotRequest private constructor(builder: Builder) {
    /**
     * Set to true to copy all tags from the source cluster
     * snapshot to the target cluster snapshot, and otherwise
     * false. The default is false.
     */
    val copyTags: kotlin.Boolean? = builder.copyTags
    /**
     * The KMS key ID for an encrypted cluster snapshot. The KMS
     * key ID is the Amazon Resource Name (ARN), KMS key identifier, or
     * the KMS key alias for the KMS encryption key.
     *
     * If you copy an encrypted cluster snapshot from your account, you can specify a value for KmsKeyId to encrypt the copy with a new KMS encryption key. If you don't specify a value for KmsKeyId, then the copy of the cluster snapshot is encrypted with the same KMS key as the source cluster snapshot.
     *
     * If you copy an encrypted cluster snapshot that is shared from another account, then you must specify a value for KmsKeyId.
     *
     * To copy an encrypted cluster snapshot to another Region, set KmsKeyId to the KMS key ID that you want to use to encrypt the copy of the cluster snapshot in the destination Region. KMS encryption keys are specific to the Region that they are created in, and you can't use encryption keys from one Region in another Region.
     *
     * If you copy an unencrypted cluster snapshot and specify a value for the KmsKeyId parameter, an error is returned.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The URL that contains a Signature Version 4 signed request for theCopyDBClusterSnapshot API action in the Region that contains the source cluster snapshot to copy. You must use the PreSignedUrl parameter when copying a cluster snapshot from another Region.
     *
     * If you are using an Amazon Web Services SDK tool or the CLI, you can specify
     * SourceRegion (or --source-region for the
     * CLI) instead of specifying PreSignedUrl manually.
     * Specifying SourceRegion autogenerates a pre-signed URL
     * that is a valid request for the operation that can be executed in
     * the source Region.
     *
     * The presigned URL must be a valid request for the
     * CopyDBClusterSnapshot API action that can be executed
     * in the source Region that contains the cluster snapshot to be
     * copied. The presigned URL request must contain the following
     * parameter values:
     *
     *
     *
     * SourceRegion - The ID of the region that
     * contains the snapshot to be copied.
     *
     *
     * SourceDBClusterSnapshotIdentifier - The
     * identifier for the the encrypted cluster snapshot to be
     * copied. This identifier must be in the Amazon Resource Name
     * (ARN) format for the source Region. For example, if you
     * are copying an encrypted cluster snapshot from the us-east-1
     * Region, then your
     * SourceDBClusterSnapshotIdentifier looks
     * something like the following:
     * arn:aws:rds:us-east-1:12345678012:sample-cluster:sample-cluster-snapshot.
     *
     *
     * TargetDBClusterSnapshotIdentifier - The
     * identifier for the new cluster snapshot to be created. This
     * parameter isn't case sensitive.
     */
    val preSignedUrl: kotlin.String? = builder.preSignedUrl
    /**
     * The identifier of the cluster snapshot to copy. This parameter is
     * not case sensitive.
     *
     * Constraints:
     *
     *
     * Must specify a valid system snapshot in the
     * available state.
     *
     * If the source snapshot is in the same Region as the copy, specify a valid snapshot identifier.
     *
     *
     * If the source snapshot is in a different Region than the copy, specify a valid cluster snapshot ARN.
     *
     *
     * Example: my-cluster-snapshot1
     */
    val sourceDbClusterSnapshotIdentifier: kotlin.String? = builder.sourceDbClusterSnapshotIdentifier
    /**
     * The tags to be assigned to the cluster snapshot.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The identifier of the new cluster snapshot to create from the
     * source cluster snapshot. This parameter is not case sensitive.
     * Constraints:
     *
     *
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     *
     *
     * The first character must be a letter.
     *
     * Cannot end with a hyphen or contain two consecutive hyphens.
     *
     *
     *
     * Example: my-cluster-snapshot2
     */
    val targetDbClusterSnapshotIdentifier: kotlin.String? = builder.targetDbClusterSnapshotIdentifier

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.CopyDbClusterSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyDbClusterSnapshotRequest(")
        append("copyTags=$copyTags,")
        append("kmsKeyId=$kmsKeyId,")
        append("preSignedUrl=$preSignedUrl,")
        append("sourceDbClusterSnapshotIdentifier=$sourceDbClusterSnapshotIdentifier,")
        append("tags=$tags,")
        append("targetDbClusterSnapshotIdentifier=$targetDbClusterSnapshotIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = copyTags?.hashCode() ?: 0
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (preSignedUrl?.hashCode() ?: 0)
        result = 31 * result + (sourceDbClusterSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetDbClusterSnapshotIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyDbClusterSnapshotRequest

        if (copyTags != other.copyTags) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (preSignedUrl != other.preSignedUrl) return false
        if (sourceDbClusterSnapshotIdentifier != other.sourceDbClusterSnapshotIdentifier) return false
        if (tags != other.tags) return false
        if (targetDbClusterSnapshotIdentifier != other.targetDbClusterSnapshotIdentifier) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.CopyDbClusterSnapshotRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Set to true to copy all tags from the source cluster
         * snapshot to the target cluster snapshot, and otherwise
         * false. The default is false.
         */
        var copyTags: kotlin.Boolean? = null
        /**
         * The KMS key ID for an encrypted cluster snapshot. The KMS
         * key ID is the Amazon Resource Name (ARN), KMS key identifier, or
         * the KMS key alias for the KMS encryption key.
         *
         * If you copy an encrypted cluster snapshot from your account, you can specify a value for KmsKeyId to encrypt the copy with a new KMS encryption key. If you don't specify a value for KmsKeyId, then the copy of the cluster snapshot is encrypted with the same KMS key as the source cluster snapshot.
         *
         * If you copy an encrypted cluster snapshot that is shared from another account, then you must specify a value for KmsKeyId.
         *
         * To copy an encrypted cluster snapshot to another Region, set KmsKeyId to the KMS key ID that you want to use to encrypt the copy of the cluster snapshot in the destination Region. KMS encryption keys are specific to the Region that they are created in, and you can't use encryption keys from one Region in another Region.
         *
         * If you copy an unencrypted cluster snapshot and specify a value for the KmsKeyId parameter, an error is returned.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The URL that contains a Signature Version 4 signed request for theCopyDBClusterSnapshot API action in the Region that contains the source cluster snapshot to copy. You must use the PreSignedUrl parameter when copying a cluster snapshot from another Region.
         *
         * If you are using an Amazon Web Services SDK tool or the CLI, you can specify
         * SourceRegion (or --source-region for the
         * CLI) instead of specifying PreSignedUrl manually.
         * Specifying SourceRegion autogenerates a pre-signed URL
         * that is a valid request for the operation that can be executed in
         * the source Region.
         *
         * The presigned URL must be a valid request for the
         * CopyDBClusterSnapshot API action that can be executed
         * in the source Region that contains the cluster snapshot to be
         * copied. The presigned URL request must contain the following
         * parameter values:
         *
         *
         *
         * SourceRegion - The ID of the region that
         * contains the snapshot to be copied.
         *
         *
         * SourceDBClusterSnapshotIdentifier - The
         * identifier for the the encrypted cluster snapshot to be
         * copied. This identifier must be in the Amazon Resource Name
         * (ARN) format for the source Region. For example, if you
         * are copying an encrypted cluster snapshot from the us-east-1
         * Region, then your
         * SourceDBClusterSnapshotIdentifier looks
         * something like the following:
         * arn:aws:rds:us-east-1:12345678012:sample-cluster:sample-cluster-snapshot.
         *
         *
         * TargetDBClusterSnapshotIdentifier - The
         * identifier for the new cluster snapshot to be created. This
         * parameter isn't case sensitive.
         */
        var preSignedUrl: kotlin.String? = null
        /**
         * The identifier of the cluster snapshot to copy. This parameter is
         * not case sensitive.
         *
         * Constraints:
         *
         *
         * Must specify a valid system snapshot in the
         * available state.
         *
         * If the source snapshot is in the same Region as the copy, specify a valid snapshot identifier.
         *
         *
         * If the source snapshot is in a different Region than the copy, specify a valid cluster snapshot ARN.
         *
         *
         * Example: my-cluster-snapshot1
         */
        var sourceDbClusterSnapshotIdentifier: kotlin.String? = null
        /**
         * The tags to be assigned to the cluster snapshot.
         */
        var tags: List<Tag>? = null
        /**
         * The identifier of the new cluster snapshot to create from the
         * source cluster snapshot. This parameter is not case sensitive.
         * Constraints:
         *
         *
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         *
         *
         * The first character must be a letter.
         *
         * Cannot end with a hyphen or contain two consecutive hyphens.
         *
         *
         *
         * Example: my-cluster-snapshot2
         */
        var targetDbClusterSnapshotIdentifier: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.CopyDbClusterSnapshotRequest) : this() {
            this.copyTags = x.copyTags
            this.kmsKeyId = x.kmsKeyId
            this.preSignedUrl = x.preSignedUrl
            this.sourceDbClusterSnapshotIdentifier = x.sourceDbClusterSnapshotIdentifier
            this.tags = x.tags
            this.targetDbClusterSnapshotIdentifier = x.targetDbClusterSnapshotIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.CopyDbClusterSnapshotRequest = CopyDbClusterSnapshotRequest(this)
    }
}
