// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed information about a cluster.
 */
class DbCluster private constructor(builder: Builder) {
    /**
     * Provides a list of the Identity and Access Management (IAM) roles that are associated with the cluster. (IAM) roles that are associated with a cluster grant permission for the cluster to access other Amazon Web Services services on your behalf.
     */
    val associatedRoles: List<DbClusterRole>? = builder.associatedRoles
    /**
     * Provides the list of Amazon EC2 Availability Zones that instances in the cluster
     * can be created in.
     */
    val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * Specifies the number of days for which automatic snapshots are retained.
     */
    val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * Specifies the time when the cluster was created, in Universal Coordinated Time
     * (UTC).
     */
    val clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.clusterCreateTime
    /**
     * The Amazon Resource Name (ARN) for the cluster.
     */
    val dbClusterArn: kotlin.String? = builder.dbClusterArn
    /**
     * Contains a user-supplied cluster identifier. This identifier is the unique key that
     * identifies a cluster.
     */
    val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * Provides the list of instances that make up the cluster.
     */
    val dbClusterMembers: List<DbClusterMember>? = builder.dbClusterMembers
    /**
     * Specifies the name of the cluster parameter group for the cluster.
     */
    val dbClusterParameterGroup: kotlin.String? = builder.dbClusterParameterGroup
    /**
     * The Region-unique, immutable identifier for the cluster. This identifier is
     * found in CloudTrail log entries whenever the KMS key for the cluster is accessed.
     */
    val dbClusterResourceId: kotlin.String? = builder.dbClusterResourceId
    /**
     * Specifies information on the subnet group that is associated with the cluster, including the name, description, and subnets in the subnet group.
     */
    val dbSubnetGroup: kotlin.String? = builder.dbSubnetGroup
    /**
     * Specifies whether this cluster can be deleted. If DeletionProtection is
     * enabled, the cluster cannot be deleted unless it is modified and
     * DeletionProtection is disabled. DeletionProtection
     * protects clusters from being accidentally deleted.
     */
    val deletionProtection: kotlin.Boolean = builder.deletionProtection
    /**
     * The earliest time to which a database can be restored with point-in-time
     * restore.
     */
    val earliestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = builder.earliestRestorableTime
    /**
     * A list of log types that this cluster is configured to export to Amazon CloudWatch
     * Logs.
     */
    val enabledCloudwatchLogsExports: List<String>? = builder.enabledCloudwatchLogsExports
    /**
     * Specifies the connection endpoint for the primary instance of the cluster.
     */
    val endpoint: kotlin.String? = builder.endpoint
    /**
     * Provides the name of the database engine to be used for this cluster.
     */
    val engine: kotlin.String? = builder.engine
    /**
     * Indicates the database engine version.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
     */
    val hostedZoneId: kotlin.String? = builder.hostedZoneId
    /**
     * If StorageEncrypted is true, the KMS key identifier for
     * the encrypted cluster.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies the latest time to which a database can be restored with point-in-time
     * restore.
     */
    val latestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = builder.latestRestorableTime
    /**
     * Contains the master user name for the cluster.
     */
    val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * Specifies whether the cluster has instances in multiple Availability Zones.
     */
    val multiAz: kotlin.Boolean = builder.multiAz
    /**
     * Specifies the progress of the operation as a percentage.
     */
    val percentProgress: kotlin.String? = builder.percentProgress
    /**
     * Specifies the port that the database engine is listening on.
     */
    val port: kotlin.Int? = builder.port
    /**
     * Specifies the daily time range during which automated backups are created if automated
     * backups are enabled, as determined by the BackupRetentionPeriod.
     */
    val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * Specifies the weekly time range during which system maintenance can occur, in
     * Universal Coordinated Time (UTC).
     */
    val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * Contains one or more identifiers of the secondary clusters that are associated with this cluster.
     */
    val readReplicaIdentifiers: List<String>? = builder.readReplicaIdentifiers
    /**
     * The reader endpoint for the cluster. The reader endpoint for a cluster load balances connections across the Amazon DocumentDB replicas that are available in a cluster. As clients request new connections to the reader endpoint, Amazon DocumentDB distributes the connection requests among the Amazon DocumentDB replicas in the cluster. This functionality can help balance your read workload across multiple Amazon DocumentDB replicas in your cluster.
     * If a failover occurs, and the Amazon DocumentDB replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Amazon DocumentDB replicas in the cluster, you can then reconnect to the reader endpoint.
     */
    val readerEndpoint: kotlin.String? = builder.readerEndpoint
    /**
     * Contains the identifier of the source cluster if this cluster is a secondary cluster.
     */
    val replicationSourceIdentifier: kotlin.String? = builder.replicationSourceIdentifier
    /**
     * Specifies the current state of this cluster.
     */
    val status: kotlin.String? = builder.status
    /**
     * Specifies whether the cluster is encrypted.
     */
    val storageEncrypted: kotlin.Boolean = builder.storageEncrypted
    /**
     * Provides a list of virtual private cloud (VPC) security groups that the cluster
     * belongs to.
     */
    val vpcSecurityGroups: List<VpcSecurityGroupMembership>? = builder.vpcSecurityGroups

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.DbCluster = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbCluster(")
        append("associatedRoles=$associatedRoles,")
        append("availabilityZones=$availabilityZones,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("clusterCreateTime=$clusterCreateTime,")
        append("dbClusterArn=$dbClusterArn,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterMembers=$dbClusterMembers,")
        append("dbClusterParameterGroup=$dbClusterParameterGroup,")
        append("dbClusterResourceId=$dbClusterResourceId,")
        append("dbSubnetGroup=$dbSubnetGroup,")
        append("deletionProtection=$deletionProtection,")
        append("earliestRestorableTime=$earliestRestorableTime,")
        append("enabledCloudwatchLogsExports=$enabledCloudwatchLogsExports,")
        append("endpoint=$endpoint,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("hostedZoneId=$hostedZoneId,")
        append("kmsKeyId=$kmsKeyId,")
        append("latestRestorableTime=$latestRestorableTime,")
        append("masterUsername=$masterUsername,")
        append("multiAz=$multiAz,")
        append("percentProgress=$percentProgress,")
        append("port=$port,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("readReplicaIdentifiers=$readReplicaIdentifiers,")
        append("readerEndpoint=$readerEndpoint,")
        append("replicationSourceIdentifier=$replicationSourceIdentifier,")
        append("status=$status,")
        append("storageEncrypted=$storageEncrypted,")
        append("vpcSecurityGroups=$vpcSecurityGroups)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedRoles?.hashCode() ?: 0
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (clusterCreateTime?.hashCode() ?: 0)
        result = 31 * result + (dbClusterArn?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterMembers?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroup?.hashCode() ?: 0)
        result = 31 * result + (dbClusterResourceId?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroup?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection.hashCode())
        result = 31 * result + (earliestRestorableTime?.hashCode() ?: 0)
        result = 31 * result + (enabledCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (hostedZoneId?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (latestRestorableTime?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (multiAz.hashCode())
        result = 31 * result + (percentProgress?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (readReplicaIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (readerEndpoint?.hashCode() ?: 0)
        result = 31 * result + (replicationSourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted.hashCode())
        result = 31 * result + (vpcSecurityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbCluster

        if (associatedRoles != other.associatedRoles) return false
        if (availabilityZones != other.availabilityZones) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (clusterCreateTime != other.clusterCreateTime) return false
        if (dbClusterArn != other.dbClusterArn) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterMembers != other.dbClusterMembers) return false
        if (dbClusterParameterGroup != other.dbClusterParameterGroup) return false
        if (dbClusterResourceId != other.dbClusterResourceId) return false
        if (dbSubnetGroup != other.dbSubnetGroup) return false
        if (deletionProtection != other.deletionProtection) return false
        if (earliestRestorableTime != other.earliestRestorableTime) return false
        if (enabledCloudwatchLogsExports != other.enabledCloudwatchLogsExports) return false
        if (endpoint != other.endpoint) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (hostedZoneId != other.hostedZoneId) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (latestRestorableTime != other.latestRestorableTime) return false
        if (masterUsername != other.masterUsername) return false
        if (multiAz != other.multiAz) return false
        if (percentProgress != other.percentProgress) return false
        if (port != other.port) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (readReplicaIdentifiers != other.readReplicaIdentifiers) return false
        if (readerEndpoint != other.readerEndpoint) return false
        if (replicationSourceIdentifier != other.replicationSourceIdentifier) return false
        if (status != other.status) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (vpcSecurityGroups != other.vpcSecurityGroups) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.DbCluster = Builder(this).apply(block).build()

    class Builder {
        /**
         * Provides a list of the Identity and Access Management (IAM) roles that are associated with the cluster. (IAM) roles that are associated with a cluster grant permission for the cluster to access other Amazon Web Services services on your behalf.
         */
        var associatedRoles: List<DbClusterRole>? = null
        /**
         * Provides the list of Amazon EC2 Availability Zones that instances in the cluster
         * can be created in.
         */
        var availabilityZones: List<String>? = null
        /**
         * Specifies the number of days for which automatic snapshots are retained.
         */
        var backupRetentionPeriod: kotlin.Int? = null
        /**
         * Specifies the time when the cluster was created, in Universal Coordinated Time
         * (UTC).
         */
        var clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) for the cluster.
         */
        var dbClusterArn: kotlin.String? = null
        /**
         * Contains a user-supplied cluster identifier. This identifier is the unique key that
         * identifies a cluster.
         */
        var dbClusterIdentifier: kotlin.String? = null
        /**
         * Provides the list of instances that make up the cluster.
         */
        var dbClusterMembers: List<DbClusterMember>? = null
        /**
         * Specifies the name of the cluster parameter group for the cluster.
         */
        var dbClusterParameterGroup: kotlin.String? = null
        /**
         * The Region-unique, immutable identifier for the cluster. This identifier is
         * found in CloudTrail log entries whenever the KMS key for the cluster is accessed.
         */
        var dbClusterResourceId: kotlin.String? = null
        /**
         * Specifies information on the subnet group that is associated with the cluster, including the name, description, and subnets in the subnet group.
         */
        var dbSubnetGroup: kotlin.String? = null
        /**
         * Specifies whether this cluster can be deleted. If DeletionProtection is
         * enabled, the cluster cannot be deleted unless it is modified and
         * DeletionProtection is disabled. DeletionProtection
         * protects clusters from being accidentally deleted.
         */
        var deletionProtection: kotlin.Boolean = false
        /**
         * The earliest time to which a database can be restored with point-in-time
         * restore.
         */
        var earliestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of log types that this cluster is configured to export to Amazon CloudWatch
         * Logs.
         */
        var enabledCloudwatchLogsExports: List<String>? = null
        /**
         * Specifies the connection endpoint for the primary instance of the cluster.
         */
        var endpoint: kotlin.String? = null
        /**
         * Provides the name of the database engine to be used for this cluster.
         */
        var engine: kotlin.String? = null
        /**
         * Indicates the database engine version.
         */
        var engineVersion: kotlin.String? = null
        /**
         * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
         */
        var hostedZoneId: kotlin.String? = null
        /**
         * If StorageEncrypted is true, the KMS key identifier for
         * the encrypted cluster.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * Specifies the latest time to which a database can be restored with point-in-time
         * restore.
         */
        var latestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Contains the master user name for the cluster.
         */
        var masterUsername: kotlin.String? = null
        /**
         * Specifies whether the cluster has instances in multiple Availability Zones.
         */
        var multiAz: kotlin.Boolean = false
        /**
         * Specifies the progress of the operation as a percentage.
         */
        var percentProgress: kotlin.String? = null
        /**
         * Specifies the port that the database engine is listening on.
         */
        var port: kotlin.Int? = null
        /**
         * Specifies the daily time range during which automated backups are created if automated
         * backups are enabled, as determined by the BackupRetentionPeriod.
         */
        var preferredBackupWindow: kotlin.String? = null
        /**
         * Specifies the weekly time range during which system maintenance can occur, in
         * Universal Coordinated Time (UTC).
         */
        var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * Contains one or more identifiers of the secondary clusters that are associated with this cluster.
         */
        var readReplicaIdentifiers: List<String>? = null
        /**
         * The reader endpoint for the cluster. The reader endpoint for a cluster load balances connections across the Amazon DocumentDB replicas that are available in a cluster. As clients request new connections to the reader endpoint, Amazon DocumentDB distributes the connection requests among the Amazon DocumentDB replicas in the cluster. This functionality can help balance your read workload across multiple Amazon DocumentDB replicas in your cluster.
         * If a failover occurs, and the Amazon DocumentDB replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Amazon DocumentDB replicas in the cluster, you can then reconnect to the reader endpoint.
         */
        var readerEndpoint: kotlin.String? = null
        /**
         * Contains the identifier of the source cluster if this cluster is a secondary cluster.
         */
        var replicationSourceIdentifier: kotlin.String? = null
        /**
         * Specifies the current state of this cluster.
         */
        var status: kotlin.String? = null
        /**
         * Specifies whether the cluster is encrypted.
         */
        var storageEncrypted: kotlin.Boolean = false
        /**
         * Provides a list of virtual private cloud (VPC) security groups that the cluster
         * belongs to.
         */
        var vpcSecurityGroups: List<VpcSecurityGroupMembership>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.DbCluster) : this() {
            this.associatedRoles = x.associatedRoles
            this.availabilityZones = x.availabilityZones
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.clusterCreateTime = x.clusterCreateTime
            this.dbClusterArn = x.dbClusterArn
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterMembers = x.dbClusterMembers
            this.dbClusterParameterGroup = x.dbClusterParameterGroup
            this.dbClusterResourceId = x.dbClusterResourceId
            this.dbSubnetGroup = x.dbSubnetGroup
            this.deletionProtection = x.deletionProtection
            this.earliestRestorableTime = x.earliestRestorableTime
            this.enabledCloudwatchLogsExports = x.enabledCloudwatchLogsExports
            this.endpoint = x.endpoint
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.hostedZoneId = x.hostedZoneId
            this.kmsKeyId = x.kmsKeyId
            this.latestRestorableTime = x.latestRestorableTime
            this.masterUsername = x.masterUsername
            this.multiAz = x.multiAz
            this.percentProgress = x.percentProgress
            this.port = x.port
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.readReplicaIdentifiers = x.readReplicaIdentifiers
            this.readerEndpoint = x.readerEndpoint
            this.replicationSourceIdentifier = x.replicationSourceIdentifier
            this.status = x.status
            this.storageEncrypted = x.storageEncrypted
            this.vpcSecurityGroups = x.vpcSecurityGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.DbCluster = DbCluster(this)
    }
}
