// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Contains the name and values of a manual cluster snapshot attribute.
 * Manual cluster snapshot attributes are used to authorize other accounts to restore a manual cluster snapshot.
 */
class DbClusterSnapshotAttribute private constructor(builder: Builder) {
    /**
     * The name of the manual cluster snapshot attribute.
     * The attribute named restore refers to the list of accounts that have permission to copy or restore the manual cluster snapshot.
     */
    val attributeName: kotlin.String? = builder.attributeName
    /**
     * The values for the manual cluster snapshot attribute.
     * If the AttributeName field is set to restore, then this element returns a list of IDs of the accounts that are authorized to copy or restore the manual cluster snapshot. If a value of all is in the list, then the manual cluster snapshot is public and available for any account to copy or restore.
     */
    val attributeValues: List<String>? = builder.attributeValues

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.DbClusterSnapshotAttribute = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbClusterSnapshotAttribute(")
        append("attributeName=$attributeName,")
        append("attributeValues=$attributeValues)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeName?.hashCode() ?: 0
        result = 31 * result + (attributeValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbClusterSnapshotAttribute

        if (attributeName != other.attributeName) return false
        if (attributeValues != other.attributeValues) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.DbClusterSnapshotAttribute = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the manual cluster snapshot attribute.
         * The attribute named restore refers to the list of accounts that have permission to copy or restore the manual cluster snapshot.
         */
        var attributeName: kotlin.String? = null
        /**
         * The values for the manual cluster snapshot attribute.
         * If the AttributeName field is set to restore, then this element returns a list of IDs of the accounts that are authorized to copy or restore the manual cluster snapshot. If a value of all is in the list, then the manual cluster snapshot is public and available for any account to copy or restore.
         */
        var attributeValues: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.DbClusterSnapshotAttribute) : this() {
            this.attributeName = x.attributeName
            this.attributeValues = x.attributeValues
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.DbClusterSnapshotAttribute = DbClusterSnapshotAttribute(this)
    }
}
