// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Detailed information about an engine version.
 */
class DbEngineVersion private constructor(builder: Builder) {
    /**
     * The description of the database engine.
     */
    val dbEngineDescription: kotlin.String? = builder.dbEngineDescription
    /**
     * The description of the database engine version.
     */
    val dbEngineVersionDescription: kotlin.String? = builder.dbEngineVersionDescription
    /**
     * The name of the parameter group family for the database engine.
     */
    val dbParameterGroupFamily: kotlin.String? = builder.dbParameterGroupFamily
    /**
     * The name of the database engine.
     */
    val engine: kotlin.String? = builder.engine
    /**
     * The version number of the database engine.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The types of logs that the database engine has available for export to Amazon
     * CloudWatch Logs.
     */
    val exportableLogTypes: List<String>? = builder.exportableLogTypes
    /**
     * A value that indicates whether the engine version supports exporting the log types
     * specified by ExportableLogTypes to CloudWatch Logs.
     */
    val supportsLogExportsToCloudwatchLogs: kotlin.Boolean = builder.supportsLogExportsToCloudwatchLogs
    /**
     * A list of engine versions that this database engine version can be upgraded to.
     */
    val validUpgradeTarget: List<UpgradeTarget>? = builder.validUpgradeTarget

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.DbEngineVersion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbEngineVersion(")
        append("dbEngineDescription=$dbEngineDescription,")
        append("dbEngineVersionDescription=$dbEngineVersionDescription,")
        append("dbParameterGroupFamily=$dbParameterGroupFamily,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("exportableLogTypes=$exportableLogTypes,")
        append("supportsLogExportsToCloudwatchLogs=$supportsLogExportsToCloudwatchLogs,")
        append("validUpgradeTarget=$validUpgradeTarget)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbEngineDescription?.hashCode() ?: 0
        result = 31 * result + (dbEngineVersionDescription?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroupFamily?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (exportableLogTypes?.hashCode() ?: 0)
        result = 31 * result + (supportsLogExportsToCloudwatchLogs.hashCode())
        result = 31 * result + (validUpgradeTarget?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbEngineVersion

        if (dbEngineDescription != other.dbEngineDescription) return false
        if (dbEngineVersionDescription != other.dbEngineVersionDescription) return false
        if (dbParameterGroupFamily != other.dbParameterGroupFamily) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (exportableLogTypes != other.exportableLogTypes) return false
        if (supportsLogExportsToCloudwatchLogs != other.supportsLogExportsToCloudwatchLogs) return false
        if (validUpgradeTarget != other.validUpgradeTarget) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.DbEngineVersion = Builder(this).apply(block).build()

    class Builder {
        /**
         * The description of the database engine.
         */
        var dbEngineDescription: kotlin.String? = null
        /**
         * The description of the database engine version.
         */
        var dbEngineVersionDescription: kotlin.String? = null
        /**
         * The name of the parameter group family for the database engine.
         */
        var dbParameterGroupFamily: kotlin.String? = null
        /**
         * The name of the database engine.
         */
        var engine: kotlin.String? = null
        /**
         * The version number of the database engine.
         */
        var engineVersion: kotlin.String? = null
        /**
         * The types of logs that the database engine has available for export to Amazon
         * CloudWatch Logs.
         */
        var exportableLogTypes: List<String>? = null
        /**
         * A value that indicates whether the engine version supports exporting the log types
         * specified by ExportableLogTypes to CloudWatch Logs.
         */
        var supportsLogExportsToCloudwatchLogs: kotlin.Boolean = false
        /**
         * A list of engine versions that this database engine version can be upgraded to.
         */
        var validUpgradeTarget: List<UpgradeTarget>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.DbEngineVersion) : this() {
            this.dbEngineDescription = x.dbEngineDescription
            this.dbEngineVersionDescription = x.dbEngineVersionDescription
            this.dbParameterGroupFamily = x.dbParameterGroupFamily
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.exportableLogTypes = x.exportableLogTypes
            this.supportsLogExportsToCloudwatchLogs = x.supportsLogExportsToCloudwatchLogs
            this.validUpgradeTarget = x.validUpgradeTarget
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.DbEngineVersion = DbEngineVersion(this)
    }
}
