// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to ModifyDBCluster.
 */
class ModifyDbClusterRequest private constructor(builder: Builder) {
    /**
     * A value that specifies whether the changes in this request and any pending changes are
     * asynchronously applied as soon as possible, regardless of the
     * PreferredMaintenanceWindow setting for the cluster. If this
     * parameter is set to false, changes to the cluster are applied during the
     * next maintenance window.
     * The ApplyImmediately parameter affects only the
     * NewDBClusterIdentifier and MasterUserPassword values. If
     * you set this parameter value to false, the changes to the
     * NewDBClusterIdentifier and MasterUserPassword values are
     * applied during the next maintenance window. All other changes are applied immediately,
     * regardless of the value of the ApplyImmediately parameter.
     * Default: false
     */
    val applyImmediately: kotlin.Boolean = builder.applyImmediately
    /**
     * The number of days for which automated backups are retained. You must specify a
     * minimum value of 1.
     * Default: 1
     * Constraints:
     *
     *
     * Must be a value from 1 to 35.
     */
    val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The configuration setting for the log types to be enabled for export to Amazon
     * CloudWatch Logs for a specific instance or cluster. The
     * EnableLogTypes and DisableLogTypes arrays determine which
     * logs are exported (or not exported) to CloudWatch Logs.
     */
    val cloudwatchLogsExportConfiguration: aws.sdk.kotlin.services.docdb.model.CloudwatchLogsExportConfiguration? = builder.cloudwatchLogsExportConfiguration
    /**
     * The cluster identifier for the cluster that is being modified. This parameter is
     * not case sensitive.
     * Constraints:
     *
     *
     * Must match the identifier of an existing DBCluster.
     */
    val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The name of the cluster parameter group to use for the cluster.
     */
    val dbClusterParameterGroupName: kotlin.String? = builder.dbClusterParameterGroupName
    /**
     * Specifies whether this cluster can be deleted. If DeletionProtection is
     * enabled, the cluster cannot be deleted unless it is modified and
     * DeletionProtection is disabled. DeletionProtection
     * protects clusters from being accidentally deleted.
     */
    val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The version number of the database engine to which you want to upgrade. Modifying engine version is not supported on Amazon DocumentDB.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The password for the master database user. This password can contain any printable
     * ASCII character except forward slash (/), double quote ("), or the "at" symbol
     * (@).
     * Constraints: Must contain from 8 to 100 characters.
     */
    val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * The new cluster identifier for the cluster when renaming a cluster. This
     * value is stored as a lowercase string.
     * Constraints:
     *
     *
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     *
     * The first character must be a letter.
     *
     * Cannot end with a hyphen or contain two consecutive hyphens.
     *
     *
     * Example: my-cluster2
     */
    val newDbClusterIdentifier: kotlin.String? = builder.newDbClusterIdentifier
    /**
     * The port number on which the cluster accepts connections.
     * Constraints: Must be a value from 1150 to 65535.
     * Default: The same port as the original cluster.
     */
    val port: kotlin.Int? = builder.port
    /**
     * The daily time range during which automated backups are created if automated backups
     * are enabled, using the BackupRetentionPeriod parameter.
     * The default is a 30-minute window selected at random from an 8-hour block of time for
     * each Region.
     * Constraints:
     *
     *
     * Must be in the format hh24:mi-hh24:mi.
     *
     * Must be in Universal Coordinated Time (UTC).
     *
     * Must not conflict with the preferred maintenance window.
     *
     * Must be at least 30 minutes.
     */
    val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur, in Universal
     * Coordinated Time (UTC).
     * Format: ddd:hh24:mi-ddd:hh24:mi
     *
     * The default is a 30-minute window selected at random from an 8-hour block of time for
     * each Region, occurring on a random day of the week.
     * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
     * Constraints: Minimum 30-minute window.
     */
    val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * A list of virtual private cloud (VPC) security groups that the cluster will belong
     * to.
     */
    val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.ModifyDbClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDbClusterRequest(")
        append("applyImmediately=$applyImmediately,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("cloudwatchLogsExportConfiguration=$cloudwatchLogsExportConfiguration,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("engineVersion=$engineVersion,")
        append("masterUserPassword=$masterUserPassword,")
        append("newDbClusterIdentifier=$newDbClusterIdentifier,")
        append("port=$port,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyImmediately.hashCode()
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (cloudwatchLogsExportConfiguration?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (newDbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyDbClusterRequest

        if (applyImmediately != other.applyImmediately) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (cloudwatchLogsExportConfiguration != other.cloudwatchLogsExportConfiguration) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (engineVersion != other.engineVersion) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (newDbClusterIdentifier != other.newDbClusterIdentifier) return false
        if (port != other.port) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.ModifyDbClusterRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A value that specifies whether the changes in this request and any pending changes are
         * asynchronously applied as soon as possible, regardless of the
         * PreferredMaintenanceWindow setting for the cluster. If this
         * parameter is set to false, changes to the cluster are applied during the
         * next maintenance window.
         * The ApplyImmediately parameter affects only the
         * NewDBClusterIdentifier and MasterUserPassword values. If
         * you set this parameter value to false, the changes to the
         * NewDBClusterIdentifier and MasterUserPassword values are
         * applied during the next maintenance window. All other changes are applied immediately,
         * regardless of the value of the ApplyImmediately parameter.
         * Default: false
         */
        var applyImmediately: kotlin.Boolean = false
        /**
         * The number of days for which automated backups are retained. You must specify a
         * minimum value of 1.
         * Default: 1
         * Constraints:
         *
         *
         * Must be a value from 1 to 35.
         */
        var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The configuration setting for the log types to be enabled for export to Amazon
         * CloudWatch Logs for a specific instance or cluster. The
         * EnableLogTypes and DisableLogTypes arrays determine which
         * logs are exported (or not exported) to CloudWatch Logs.
         */
        var cloudwatchLogsExportConfiguration: aws.sdk.kotlin.services.docdb.model.CloudwatchLogsExportConfiguration? = null
        /**
         * The cluster identifier for the cluster that is being modified. This parameter is
         * not case sensitive.
         * Constraints:
         *
         *
         * Must match the identifier of an existing DBCluster.
         */
        var dbClusterIdentifier: kotlin.String? = null
        /**
         * The name of the cluster parameter group to use for the cluster.
         */
        var dbClusterParameterGroupName: kotlin.String? = null
        /**
         * Specifies whether this cluster can be deleted. If DeletionProtection is
         * enabled, the cluster cannot be deleted unless it is modified and
         * DeletionProtection is disabled. DeletionProtection
         * protects clusters from being accidentally deleted.
         */
        var deletionProtection: kotlin.Boolean? = null
        /**
         * The version number of the database engine to which you want to upgrade. Modifying engine version is not supported on Amazon DocumentDB.
         */
        var engineVersion: kotlin.String? = null
        /**
         * The password for the master database user. This password can contain any printable
         * ASCII character except forward slash (/), double quote ("), or the "at" symbol
         * (@).
         * Constraints: Must contain from 8 to 100 characters.
         */
        var masterUserPassword: kotlin.String? = null
        /**
         * The new cluster identifier for the cluster when renaming a cluster. This
         * value is stored as a lowercase string.
         * Constraints:
         *
         *
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         *
         * The first character must be a letter.
         *
         * Cannot end with a hyphen or contain two consecutive hyphens.
         *
         *
         * Example: my-cluster2
         */
        var newDbClusterIdentifier: kotlin.String? = null
        /**
         * The port number on which the cluster accepts connections.
         * Constraints: Must be a value from 1150 to 65535.
         * Default: The same port as the original cluster.
         */
        var port: kotlin.Int? = null
        /**
         * The daily time range during which automated backups are created if automated backups
         * are enabled, using the BackupRetentionPeriod parameter.
         * The default is a 30-minute window selected at random from an 8-hour block of time for
         * each Region.
         * Constraints:
         *
         *
         * Must be in the format hh24:mi-hh24:mi.
         *
         * Must be in Universal Coordinated Time (UTC).
         *
         * Must not conflict with the preferred maintenance window.
         *
         * Must be at least 30 minutes.
         */
        var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range during which system maintenance can occur, in Universal
         * Coordinated Time (UTC).
         * Format: ddd:hh24:mi-ddd:hh24:mi
         *
         * The default is a 30-minute window selected at random from an 8-hour block of time for
         * each Region, occurring on a random day of the week.
         * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         * Constraints: Minimum 30-minute window.
         */
        var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * A list of virtual private cloud (VPC) security groups that the cluster will belong
         * to.
         */
        var vpcSecurityGroupIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.ModifyDbClusterRequest) : this() {
            this.applyImmediately = x.applyImmediately
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.cloudwatchLogsExportConfiguration = x.cloudwatchLogsExportConfiguration
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.deletionProtection = x.deletionProtection
            this.engineVersion = x.engineVersion
            this.masterUserPassword = x.masterUserPassword
            this.newDbClusterIdentifier = x.newDbClusterIdentifier
            this.port = x.port
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.ModifyDbClusterRequest = ModifyDbClusterRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.docdb.model.CloudwatchLogsExportConfiguration] inside the given [block]
         */
        fun cloudwatchLogsExportConfiguration(block: aws.sdk.kotlin.services.docdb.model.CloudwatchLogsExportConfiguration.Builder.() -> kotlin.Unit) {
            this.cloudwatchLogsExportConfiguration = aws.sdk.kotlin.services.docdb.model.CloudwatchLogsExportConfiguration.invoke(block)
        }
    }
}
