// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * One or more modified settings for an instance. These modified settings have been
 * requested, but haven't been applied yet.
 */
class PendingModifiedValues private constructor(builder: Builder) {
    /**
     * Contains the new AllocatedStorage size for then instance that will be
     * applied or is currently being applied.
     */
    val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * Specifies the pending number of days for which automated backups are retained.
     */
    val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * Specifies the identifier of the certificate authority (CA) certificate for the DB
     * instance.
     */
    val caCertificateIdentifier: kotlin.String? = builder.caCertificateIdentifier
    /**
     * Contains the new DBInstanceClass for the instance that will be
     * applied or is currently being applied.
     */
    val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * Contains the new DBInstanceIdentifier for the instance that will be
     * applied or is currently being applied.
     */
    val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The new subnet group for the instance.
     */
    val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * Indicates the database engine version.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Specifies the new Provisioned IOPS value for the instance that will be applied or
     * is currently being applied.
     */
    val iops: kotlin.Int? = builder.iops
    /**
     * The license model for the instance.
     * Valid values: license-included, bring-your-own-license,
     * general-public-license
     */
    val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * Contains the pending or currently in-progress change of the master credentials for the
     * instance.
     */
    val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * Indicates that the Single-AZ instance is to change to a Multi-AZ deployment.
     */
    val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * A list of the log types whose configuration is still pending. These log types are in
     * the process of being activated or deactivated.
     */
    val pendingCloudwatchLogsExports: aws.sdk.kotlin.services.docdb.model.PendingCloudwatchLogsExports? = builder.pendingCloudwatchLogsExports
    /**
     * Specifies the pending port for the instance.
     */
    val port: kotlin.Int? = builder.port
    /**
     * Specifies the storage type to be associated with the instance.
     */
    val storageType: kotlin.String? = builder.storageType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.PendingModifiedValues = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PendingModifiedValues(")
        append("allocatedStorage=$allocatedStorage,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("caCertificateIdentifier=$caCertificateIdentifier,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("engineVersion=$engineVersion,")
        append("iops=$iops,")
        append("licenseModel=$licenseModel,")
        append("masterUserPassword=$masterUserPassword,")
        append("multiAz=$multiAz,")
        append("pendingCloudwatchLogsExports=$pendingCloudwatchLogsExports,")
        append("port=$port,")
        append("storageType=$storageType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (caCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (pendingCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PendingModifiedValues

        if (allocatedStorage != other.allocatedStorage) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (caCertificateIdentifier != other.caCertificateIdentifier) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (engineVersion != other.engineVersion) return false
        if (iops != other.iops) return false
        if (licenseModel != other.licenseModel) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (multiAz != other.multiAz) return false
        if (pendingCloudwatchLogsExports != other.pendingCloudwatchLogsExports) return false
        if (port != other.port) return false
        if (storageType != other.storageType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.PendingModifiedValues = Builder(this).apply(block).build()

    class Builder {
        /**
         * Contains the new AllocatedStorage size for then instance that will be
         * applied or is currently being applied.
         */
        var allocatedStorage: kotlin.Int? = null
        /**
         * Specifies the pending number of days for which automated backups are retained.
         */
        var backupRetentionPeriod: kotlin.Int? = null
        /**
         * Specifies the identifier of the certificate authority (CA) certificate for the DB
         * instance.
         */
        var caCertificateIdentifier: kotlin.String? = null
        /**
         * Contains the new DBInstanceClass for the instance that will be
         * applied or is currently being applied.
         */
        var dbInstanceClass: kotlin.String? = null
        /**
         * Contains the new DBInstanceIdentifier for the instance that will be
         * applied or is currently being applied.
         */
        var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The new subnet group for the instance.
         */
        var dbSubnetGroupName: kotlin.String? = null
        /**
         * Indicates the database engine version.
         */
        var engineVersion: kotlin.String? = null
        /**
         * Specifies the new Provisioned IOPS value for the instance that will be applied or
         * is currently being applied.
         */
        var iops: kotlin.Int? = null
        /**
         * The license model for the instance.
         * Valid values: license-included, bring-your-own-license,
         * general-public-license
         */
        var licenseModel: kotlin.String? = null
        /**
         * Contains the pending or currently in-progress change of the master credentials for the
         * instance.
         */
        var masterUserPassword: kotlin.String? = null
        /**
         * Indicates that the Single-AZ instance is to change to a Multi-AZ deployment.
         */
        var multiAz: kotlin.Boolean? = null
        /**
         * A list of the log types whose configuration is still pending. These log types are in
         * the process of being activated or deactivated.
         */
        var pendingCloudwatchLogsExports: aws.sdk.kotlin.services.docdb.model.PendingCloudwatchLogsExports? = null
        /**
         * Specifies the pending port for the instance.
         */
        var port: kotlin.Int? = null
        /**
         * Specifies the storage type to be associated with the instance.
         */
        var storageType: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.PendingModifiedValues) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.caCertificateIdentifier = x.caCertificateIdentifier
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.engineVersion = x.engineVersion
            this.iops = x.iops
            this.licenseModel = x.licenseModel
            this.masterUserPassword = x.masterUserPassword
            this.multiAz = x.multiAz
            this.pendingCloudwatchLogsExports = x.pendingCloudwatchLogsExports
            this.port = x.port
            this.storageType = x.storageType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.PendingModifiedValues = PendingModifiedValues(this)

        /**
         * construct an [aws.sdk.kotlin.services.docdb.model.PendingCloudwatchLogsExports] inside the given [block]
         */
        fun pendingCloudwatchLogsExports(block: aws.sdk.kotlin.services.docdb.model.PendingCloudwatchLogsExports.Builder.() -> kotlin.Unit) {
            this.pendingCloudwatchLogsExports = aws.sdk.kotlin.services.docdb.model.PendingCloudwatchLogsExports.invoke(block)
        }
    }
}
