// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * The version of the database engine that an instance can be upgraded to.
 */
class UpgradeTarget private constructor(builder: Builder) {
    /**
     * A value that indicates whether the target version is applied to any source DB instances that have AutoMinorVersionUpgrade set to true.
     */
    val autoUpgrade: kotlin.Boolean = builder.autoUpgrade
    /**
     * The version of the database engine that an instance can be upgraded to.
     */
    val description: kotlin.String? = builder.description
    /**
     * The name of the upgrade target database engine.
     */
    val engine: kotlin.String? = builder.engine
    /**
     * The version number of the upgrade target database engine.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * A value that indicates whether a database engine is upgraded to a major
     * version.
     */
    val isMajorVersionUpgrade: kotlin.Boolean = builder.isMajorVersionUpgrade

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.UpgradeTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpgradeTarget(")
        append("autoUpgrade=$autoUpgrade,")
        append("description=$description,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("isMajorVersionUpgrade=$isMajorVersionUpgrade)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoUpgrade.hashCode()
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (isMajorVersionUpgrade.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpgradeTarget

        if (autoUpgrade != other.autoUpgrade) return false
        if (description != other.description) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (isMajorVersionUpgrade != other.isMajorVersionUpgrade) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.UpgradeTarget = Builder(this).apply(block).build()

    class Builder {
        /**
         * A value that indicates whether the target version is applied to any source DB instances that have AutoMinorVersionUpgrade set to true.
         */
        var autoUpgrade: kotlin.Boolean = false
        /**
         * The version of the database engine that an instance can be upgraded to.
         */
        var description: kotlin.String? = null
        /**
         * The name of the upgrade target database engine.
         */
        var engine: kotlin.String? = null
        /**
         * The version number of the upgrade target database engine.
         */
        var engineVersion: kotlin.String? = null
        /**
         * A value that indicates whether a database engine is upgraded to a major
         * version.
         */
        var isMajorVersionUpgrade: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.UpgradeTarget) : this() {
            this.autoUpgrade = x.autoUpgrade
            this.description = x.description
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.isMajorVersionUpgrade = x.isMajorVersionUpgrade
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.UpgradeTarget = UpgradeTarget(this)
    }
}
