// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.paginators

import aws.sdk.kotlin.services.docdb.DocDbClient
import aws.sdk.kotlin.services.docdb.model.Certificate
import aws.sdk.kotlin.services.docdb.model.DbCluster
import aws.sdk.kotlin.services.docdb.model.DbClusterParameterGroup
import aws.sdk.kotlin.services.docdb.model.DbClusterSnapshot
import aws.sdk.kotlin.services.docdb.model.DbEngineVersion
import aws.sdk.kotlin.services.docdb.model.DbInstance
import aws.sdk.kotlin.services.docdb.model.DbSubnetGroup
import aws.sdk.kotlin.services.docdb.model.DescribeCertificatesRequest
import aws.sdk.kotlin.services.docdb.model.DescribeCertificatesResponse
import aws.sdk.kotlin.services.docdb.model.DescribeDbClusterParameterGroupsRequest
import aws.sdk.kotlin.services.docdb.model.DescribeDbClusterParameterGroupsResponse
import aws.sdk.kotlin.services.docdb.model.DescribeDbClusterParametersRequest
import aws.sdk.kotlin.services.docdb.model.DescribeDbClusterParametersResponse
import aws.sdk.kotlin.services.docdb.model.DescribeDbClusterSnapshotsRequest
import aws.sdk.kotlin.services.docdb.model.DescribeDbClusterSnapshotsResponse
import aws.sdk.kotlin.services.docdb.model.DescribeDbClustersRequest
import aws.sdk.kotlin.services.docdb.model.DescribeDbClustersResponse
import aws.sdk.kotlin.services.docdb.model.DescribeDbEngineVersionsRequest
import aws.sdk.kotlin.services.docdb.model.DescribeDbEngineVersionsResponse
import aws.sdk.kotlin.services.docdb.model.DescribeDbInstancesRequest
import aws.sdk.kotlin.services.docdb.model.DescribeDbInstancesResponse
import aws.sdk.kotlin.services.docdb.model.DescribeDbSubnetGroupsRequest
import aws.sdk.kotlin.services.docdb.model.DescribeDbSubnetGroupsResponse
import aws.sdk.kotlin.services.docdb.model.DescribeEventSubscriptionsRequest
import aws.sdk.kotlin.services.docdb.model.DescribeEventSubscriptionsResponse
import aws.sdk.kotlin.services.docdb.model.DescribeEventsRequest
import aws.sdk.kotlin.services.docdb.model.DescribeEventsResponse
import aws.sdk.kotlin.services.docdb.model.DescribeGlobalClustersRequest
import aws.sdk.kotlin.services.docdb.model.DescribeGlobalClustersResponse
import aws.sdk.kotlin.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest
import aws.sdk.kotlin.services.docdb.model.DescribeOrderableDbInstanceOptionsResponse
import aws.sdk.kotlin.services.docdb.model.DescribePendingMaintenanceActionsRequest
import aws.sdk.kotlin.services.docdb.model.DescribePendingMaintenanceActionsResponse
import aws.sdk.kotlin.services.docdb.model.Event
import aws.sdk.kotlin.services.docdb.model.EventSubscription
import aws.sdk.kotlin.services.docdb.model.GlobalCluster
import aws.sdk.kotlin.services.docdb.model.OrderableDbInstanceOption
import aws.sdk.kotlin.services.docdb.model.Parameter
import aws.sdk.kotlin.services.docdb.model.ResourcePendingMaintenanceActions
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeCertificatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeCertificatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCertificatesResponse]
 */
fun DocDbClient.describeCertificatesPaginated(initialRequest: DescribeCertificatesRequest): Flow<DescribeCertificatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeCertificatesPaginated.describeCertificates(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeCertificatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCertificatesResponse]
 */
fun DocDbClient.describeCertificatesPaginated(block: DescribeCertificatesRequest.Builder.() -> Unit): Flow<DescribeCertificatesResponse> =
    describeCertificatesPaginated(DescribeCertificatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeCertificatesPaginated]
 * to access the nested member [Certificate]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Certificate]
 */
@JvmName("describeCertificatesResponseCertificate")
fun Flow<DescribeCertificatesResponse>.certificates(): Flow<Certificate> =
    transform() { response ->
        response.certificates?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDbClusterParameterGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDbClusterParameterGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbClusterParameterGroupsResponse]
 */
fun DocDbClient.describeDbClusterParameterGroupsPaginated(initialRequest: DescribeDbClusterParameterGroupsRequest): Flow<DescribeDbClusterParameterGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDbClusterParameterGroupsPaginated.describeDbClusterParameterGroups(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDbClusterParameterGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbClusterParameterGroupsResponse]
 */
fun DocDbClient.describeDbClusterParameterGroupsPaginated(block: DescribeDbClusterParameterGroupsRequest.Builder.() -> Unit): Flow<DescribeDbClusterParameterGroupsResponse> =
    describeDbClusterParameterGroupsPaginated(DescribeDbClusterParameterGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDbClusterParameterGroupsPaginated]
 * to access the nested member [DbClusterParameterGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DbClusterParameterGroup]
 */
@JvmName("describeDbClusterParameterGroupsResponseDbClusterParameterGroup")
fun Flow<DescribeDbClusterParameterGroupsResponse>.dbClusterParameterGroups(): Flow<DbClusterParameterGroup> =
    transform() { response ->
        response.dbClusterParameterGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDbClusterParametersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDbClusterParametersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbClusterParametersResponse]
 */
fun DocDbClient.describeDbClusterParametersPaginated(initialRequest: DescribeDbClusterParametersRequest): Flow<DescribeDbClusterParametersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDbClusterParametersPaginated.describeDbClusterParameters(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDbClusterParametersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbClusterParametersResponse]
 */
fun DocDbClient.describeDbClusterParametersPaginated(block: DescribeDbClusterParametersRequest.Builder.() -> Unit): Flow<DescribeDbClusterParametersResponse> =
    describeDbClusterParametersPaginated(DescribeDbClusterParametersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDbClusterParametersPaginated]
 * to access the nested member [Parameter]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Parameter]
 */
@JvmName("describeDbClusterParametersResponseParameter")
fun Flow<DescribeDbClusterParametersResponse>.parameters(): Flow<Parameter> =
    transform() { response ->
        response.parameters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDbClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDbClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbClustersResponse]
 */
fun DocDbClient.describeDbClustersPaginated(initialRequest: DescribeDbClustersRequest): Flow<DescribeDbClustersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDbClustersPaginated.describeDbClusters(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDbClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbClustersResponse]
 */
fun DocDbClient.describeDbClustersPaginated(block: DescribeDbClustersRequest.Builder.() -> Unit): Flow<DescribeDbClustersResponse> =
    describeDbClustersPaginated(DescribeDbClustersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDbClustersPaginated]
 * to access the nested member [DbCluster]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DbCluster]
 */
@JvmName("describeDbClustersResponseDbCluster")
fun Flow<DescribeDbClustersResponse>.dbClusters(): Flow<DbCluster> =
    transform() { response ->
        response.dbClusters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDbClusterSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDbClusterSnapshotsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbClusterSnapshotsResponse]
 */
fun DocDbClient.describeDbClusterSnapshotsPaginated(initialRequest: DescribeDbClusterSnapshotsRequest): Flow<DescribeDbClusterSnapshotsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDbClusterSnapshotsPaginated.describeDbClusterSnapshots(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDbClusterSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbClusterSnapshotsResponse]
 */
fun DocDbClient.describeDbClusterSnapshotsPaginated(block: DescribeDbClusterSnapshotsRequest.Builder.() -> Unit): Flow<DescribeDbClusterSnapshotsResponse> =
    describeDbClusterSnapshotsPaginated(DescribeDbClusterSnapshotsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDbClusterSnapshotsPaginated]
 * to access the nested member [DbClusterSnapshot]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DbClusterSnapshot]
 */
@JvmName("describeDbClusterSnapshotsResponseDbClusterSnapshot")
fun Flow<DescribeDbClusterSnapshotsResponse>.dbClusterSnapshots(): Flow<DbClusterSnapshot> =
    transform() { response ->
        response.dbClusterSnapshots?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDbEngineVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDbEngineVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbEngineVersionsResponse]
 */
fun DocDbClient.describeDbEngineVersionsPaginated(initialRequest: DescribeDbEngineVersionsRequest): Flow<DescribeDbEngineVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDbEngineVersionsPaginated.describeDbEngineVersions(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDbEngineVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbEngineVersionsResponse]
 */
fun DocDbClient.describeDbEngineVersionsPaginated(block: DescribeDbEngineVersionsRequest.Builder.() -> Unit): Flow<DescribeDbEngineVersionsResponse> =
    describeDbEngineVersionsPaginated(DescribeDbEngineVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDbEngineVersionsPaginated]
 * to access the nested member [DbEngineVersion]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DbEngineVersion]
 */
@JvmName("describeDbEngineVersionsResponseDbEngineVersion")
fun Flow<DescribeDbEngineVersionsResponse>.dbEngineVersions(): Flow<DbEngineVersion> =
    transform() { response ->
        response.dbEngineVersions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDbInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDbInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbInstancesResponse]
 */
fun DocDbClient.describeDbInstancesPaginated(initialRequest: DescribeDbInstancesRequest): Flow<DescribeDbInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDbInstancesPaginated.describeDbInstances(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDbInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbInstancesResponse]
 */
fun DocDbClient.describeDbInstancesPaginated(block: DescribeDbInstancesRequest.Builder.() -> Unit): Flow<DescribeDbInstancesResponse> =
    describeDbInstancesPaginated(DescribeDbInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDbInstancesPaginated]
 * to access the nested member [DbInstance]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DbInstance]
 */
@JvmName("describeDbInstancesResponseDbInstance")
fun Flow<DescribeDbInstancesResponse>.dbInstances(): Flow<DbInstance> =
    transform() { response ->
        response.dbInstances?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDbSubnetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDbSubnetGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbSubnetGroupsResponse]
 */
fun DocDbClient.describeDbSubnetGroupsPaginated(initialRequest: DescribeDbSubnetGroupsRequest): Flow<DescribeDbSubnetGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDbSubnetGroupsPaginated.describeDbSubnetGroups(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDbSubnetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbSubnetGroupsResponse]
 */
fun DocDbClient.describeDbSubnetGroupsPaginated(block: DescribeDbSubnetGroupsRequest.Builder.() -> Unit): Flow<DescribeDbSubnetGroupsResponse> =
    describeDbSubnetGroupsPaginated(DescribeDbSubnetGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDbSubnetGroupsPaginated]
 * to access the nested member [DbSubnetGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DbSubnetGroup]
 */
@JvmName("describeDbSubnetGroupsResponseDbSubnetGroup")
fun Flow<DescribeDbSubnetGroupsResponse>.dbSubnetGroups(): Flow<DbSubnetGroup> =
    transform() { response ->
        response.dbSubnetGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventsResponse]
 */
fun DocDbClient.describeEventsPaginated(initialRequest: DescribeEventsRequest): Flow<DescribeEventsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeEventsPaginated.describeEvents(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventsResponse]
 */
fun DocDbClient.describeEventsPaginated(block: DescribeEventsRequest.Builder.() -> Unit): Flow<DescribeEventsResponse> =
    describeEventsPaginated(DescribeEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEventsPaginated]
 * to access the nested member [Event]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Event]
 */
@JvmName("describeEventsResponseEvent")
fun Flow<DescribeEventsResponse>.events(): Flow<Event> =
    transform() { response ->
        response.events?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEventSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEventSubscriptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventSubscriptionsResponse]
 */
fun DocDbClient.describeEventSubscriptionsPaginated(initialRequest: DescribeEventSubscriptionsRequest): Flow<DescribeEventSubscriptionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeEventSubscriptionsPaginated.describeEventSubscriptions(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEventSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventSubscriptionsResponse]
 */
fun DocDbClient.describeEventSubscriptionsPaginated(block: DescribeEventSubscriptionsRequest.Builder.() -> Unit): Flow<DescribeEventSubscriptionsResponse> =
    describeEventSubscriptionsPaginated(DescribeEventSubscriptionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEventSubscriptionsPaginated]
 * to access the nested member [EventSubscription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EventSubscription]
 */
@JvmName("describeEventSubscriptionsResponseEventSubscription")
fun Flow<DescribeEventSubscriptionsResponse>.eventSubscriptionsList(): Flow<EventSubscription> =
    transform() { response ->
        response.eventSubscriptionsList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeGlobalClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeGlobalClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGlobalClustersResponse]
 */
fun DocDbClient.describeGlobalClustersPaginated(initialRequest: DescribeGlobalClustersRequest): Flow<DescribeGlobalClustersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeGlobalClustersPaginated.describeGlobalClusters(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeGlobalClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGlobalClustersResponse]
 */
fun DocDbClient.describeGlobalClustersPaginated(block: DescribeGlobalClustersRequest.Builder.() -> Unit): Flow<DescribeGlobalClustersResponse> =
    describeGlobalClustersPaginated(DescribeGlobalClustersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeGlobalClustersPaginated]
 * to access the nested member [GlobalCluster]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GlobalCluster]
 */
@JvmName("describeGlobalClustersResponseGlobalCluster")
fun Flow<DescribeGlobalClustersResponse>.globalClusters(): Flow<GlobalCluster> =
    transform() { response ->
        response.globalClusters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeOrderableDbInstanceOptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeOrderableDbInstanceOptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeOrderableDbInstanceOptionsResponse]
 */
fun DocDbClient.describeOrderableDbInstanceOptionsPaginated(initialRequest: DescribeOrderableDbInstanceOptionsRequest): Flow<DescribeOrderableDbInstanceOptionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeOrderableDbInstanceOptionsPaginated.describeOrderableDbInstanceOptions(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeOrderableDbInstanceOptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeOrderableDbInstanceOptionsResponse]
 */
fun DocDbClient.describeOrderableDbInstanceOptionsPaginated(block: DescribeOrderableDbInstanceOptionsRequest.Builder.() -> Unit): Flow<DescribeOrderableDbInstanceOptionsResponse> =
    describeOrderableDbInstanceOptionsPaginated(DescribeOrderableDbInstanceOptionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeOrderableDbInstanceOptionsPaginated]
 * to access the nested member [OrderableDbInstanceOption]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [OrderableDbInstanceOption]
 */
@JvmName("describeOrderableDbInstanceOptionsResponseOrderableDbInstanceOption")
fun Flow<DescribeOrderableDbInstanceOptionsResponse>.orderableDbInstanceOptions(): Flow<OrderableDbInstanceOption> =
    transform() { response ->
        response.orderableDbInstanceOptions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribePendingMaintenanceActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribePendingMaintenanceActionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePendingMaintenanceActionsResponse]
 */
fun DocDbClient.describePendingMaintenanceActionsPaginated(initialRequest: DescribePendingMaintenanceActionsRequest): Flow<DescribePendingMaintenanceActionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describePendingMaintenanceActionsPaginated.describePendingMaintenanceActions(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [DescribePendingMaintenanceActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePendingMaintenanceActionsResponse]
 */
fun DocDbClient.describePendingMaintenanceActionsPaginated(block: DescribePendingMaintenanceActionsRequest.Builder.() -> Unit): Flow<DescribePendingMaintenanceActionsResponse> =
    describePendingMaintenanceActionsPaginated(DescribePendingMaintenanceActionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describePendingMaintenanceActionsPaginated]
 * to access the nested member [ResourcePendingMaintenanceActions]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResourcePendingMaintenanceActions]
 */
@JvmName("describePendingMaintenanceActionsResponseResourcePendingMaintenanceActions")
fun Flow<DescribePendingMaintenanceActionsResponse>.pendingMaintenanceActions(): Flow<ResourcePendingMaintenanceActions> =
    transform() { response ->
        response.pendingMaintenanceActions?.forEach {
            emit(it)
        }
    }
