// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.transform

import aws.sdk.kotlin.services.docdb.model.CopyDbClusterSnapshotRequest
import aws.sdk.kotlin.services.docdb.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlCollectionName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CopyDBClusterSnapshotOperationSerializer: HttpSerialize<CopyDbClusterSnapshotRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CopyDbClusterSnapshotRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCopyDBClusterSnapshotOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        return builder
    }
}

private fun serializeCopyDBClusterSnapshotOperationBody(context: ExecutionContext, input: CopyDbClusterSnapshotRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val COPYTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("CopyTags"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("KmsKeyId"))
    val PRESIGNEDURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PreSignedUrl"))
    val SOURCEDBCLUSTERSNAPSHOTIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SourceDBClusterSnapshotIdentifier"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Tags"), FormUrlCollectionName("Tag"))
    val TARGETDBCLUSTERSNAPSHOTIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TargetDBClusterSnapshotIdentifier"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("CopyDBClusterSnapshotMessage"))
        trait(QueryLiteral("Action", "CopyDBClusterSnapshot"))
        trait(QueryLiteral("Version", "2014-10-31"))
        field(COPYTAGS_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(PRESIGNEDURL_DESCRIPTOR)
        field(SOURCEDBCLUSTERSNAPSHOTIDENTIFIER_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TARGETDBCLUSTERSNAPSHOTIDENTIFIER_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.copyTags?.let { field(COPYTAGS_DESCRIPTOR, it) }
        input.kmsKeyId?.let { field(KMSKEYID_DESCRIPTOR, it) }
        input.preSignedUrl?.let { field(PRESIGNEDURL_DESCRIPTOR, it) }
        input.sourceDbClusterSnapshotIdentifier?.let { field(SOURCEDBCLUSTERSNAPSHOTIDENTIFIER_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.targetDbClusterSnapshotIdentifier?.let { field(TARGETDBCLUSTERSNAPSHOTIDENTIFIER_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
