// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.docdb.model.Certificate
import aws.sdk.kotlin.services.docdb.model.DescribeCertificatesResponse
import aws.sdk.kotlin.services.docdb.model.DocDbException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class DescribeCertificatesOperationDeserializer: HttpDeserialize<DescribeCertificatesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeCertificatesResponse {
        if (!response.status.isSuccess()) {
            throwDescribeCertificatesError(context, response)
        }
        val builder = DescribeCertificatesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeCertificatesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeCertificatesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw DocDbException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CertificateNotFound" -> CertificateNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> DocDbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeCertificatesOperationBody(builder: DescribeCertificatesResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeCertificatesResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeCertificatesResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeCertificates response")
    }
    // end unwrap response wrapper

    val CERTIFICATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Certificates"), XmlCollectionName("Certificate"))
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Marker"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://rds.amazonaws.com/doc/2014-10-31/"))
        trait(XmlSerialName("DescribeCertificatesResult"))
        field(CERTIFICATES_DESCRIPTOR)
        field(MARKER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CERTIFICATES_DESCRIPTOR.index -> builder.certificates =
                    deserializer.deserializeList(CERTIFICATES_DESCRIPTOR) {
                        val col0 = mutableListOf<Certificate>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCertificateDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
