// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.waiters

import aws.sdk.kotlin.services.docdb.DocDbClient
import aws.sdk.kotlin.services.docdb.model.DescribeDbInstancesRequest
import aws.sdk.kotlin.services.docdb.model.DescribeDbInstancesResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds
import kotlin.time.Duration.Companion.seconds


suspend fun DocDbClient.waitUntilDBInstanceAvailable(request: DescribeDbInstancesRequest): Outcome<DescribeDbInstancesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxTime = 300.seconds, maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeDbInstancesRequest, DescribeDbInstancesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val dbInstances = it?.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible() ?: listOf()
            val projection = dbInstancesOrEmpty.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            (projection?.size ?: 0) > 1 && projection?.all { it?.toString() == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it?.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible() ?: listOf()
            val projection = dbInstancesOrEmpty.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            projection?.any { it?.toString() == "deleted" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it?.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible() ?: listOf()
            val projection = dbInstancesOrEmpty.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            projection?.any { it?.toString() == "deleting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it?.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible() ?: listOf()
            val projection = dbInstancesOrEmpty.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            projection?.any { it?.toString() == "failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it?.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible() ?: listOf()
            val projection = dbInstancesOrEmpty.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            projection?.any { it?.toString() == "incompatible-restore" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it?.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible() ?: listOf()
            val projection = dbInstancesOrEmpty.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            projection?.any { it?.toString() == "incompatible-parameters" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDbInstances(request) }
}

suspend fun DocDbClient.waitUntilDBInstanceAvailable(block: DescribeDbInstancesRequest.Builder.() -> Unit): Outcome<DescribeDbInstancesResponse> =
    waitUntilDBInstanceAvailable(DescribeDbInstancesRequest.Builder().apply(block).build())
