// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.docdb.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.docdb.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon DocumentDB API documentation
 */
interface DocDbClient : SdkClient {

    override val serviceName: String
        get() = "DocDB"
    /**
     * DocDbClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): DocDbClient {
            val config = Config.Builder().apply(block).build()
            return DefaultDocDbClient(config)
        }

        operator fun invoke(config: Config): DocDbClient = DefaultDocDbClient(config)

        /**
         * Construct a [DocDbClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): DocDbClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultDocDbClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds a source identifier to an existing event notification subscription.
     */
    suspend fun addSourceIdentifierToSubscription(input: AddSourceIdentifierToSubscriptionRequest): AddSourceIdentifierToSubscriptionResponse

    /**
     * Adds a source identifier to an existing event notification subscription.
     */
    suspend fun addSourceIdentifierToSubscription(block: AddSourceIdentifierToSubscriptionRequest.Builder.() -> Unit) = addSourceIdentifierToSubscription(AddSourceIdentifierToSubscriptionRequest.Builder().apply(block).build())

    /**
     * Adds metadata tags to an Amazon DocumentDB resource. You can use these tags with cost allocation reporting to track costs that are associated with Amazon DocumentDB resources or in a `Condition` statement in an Identity and Access Management (IAM) policy for Amazon DocumentDB.
     */
    suspend fun addTagsToResource(input: AddTagsToResourceRequest): AddTagsToResourceResponse

    /**
     * Adds metadata tags to an Amazon DocumentDB resource. You can use these tags with cost allocation reporting to track costs that are associated with Amazon DocumentDB resources or in a `Condition` statement in an Identity and Access Management (IAM) policy for Amazon DocumentDB.
     */
    suspend fun addTagsToResource(block: AddTagsToResourceRequest.Builder.() -> Unit) = addTagsToResource(AddTagsToResourceRequest.Builder().apply(block).build())

    /**
     * Applies a pending maintenance action to a resource (for example, to an Amazon DocumentDB instance).
     */
    suspend fun applyPendingMaintenanceAction(input: ApplyPendingMaintenanceActionRequest): ApplyPendingMaintenanceActionResponse

    /**
     * Applies a pending maintenance action to a resource (for example, to an Amazon DocumentDB instance).
     */
    suspend fun applyPendingMaintenanceAction(block: ApplyPendingMaintenanceActionRequest.Builder.() -> Unit) = applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest.Builder().apply(block).build())

    /**
     * Copies the specified cluster parameter group.
     */
    suspend fun copyDbClusterParameterGroup(input: CopyDbClusterParameterGroupRequest): CopyDbClusterParameterGroupResponse

    /**
     * Copies the specified cluster parameter group.
     */
    suspend fun copyDbClusterParameterGroup(block: CopyDbClusterParameterGroupRequest.Builder.() -> Unit) = copyDbClusterParameterGroup(CopyDbClusterParameterGroupRequest.Builder().apply(block).build())

    /**
     * Copies a snapshot of a cluster.
     *
     * To copy a cluster snapshot from a shared manual cluster snapshot, `SourceDBClusterSnapshotIdentifier` must be the Amazon Resource Name (ARN) of the shared cluster snapshot. You can only copy a shared DB cluster snapshot, whether encrypted or not, in the same Amazon Web Services Region.
     *
     * To cancel the copy operation after it is in progress, delete the target cluster snapshot identified by `TargetDBClusterSnapshotIdentifier` while that cluster snapshot is in the *copying* status.
     */
    suspend fun copyDbClusterSnapshot(input: CopyDbClusterSnapshotRequest): CopyDbClusterSnapshotResponse

    /**
     * Copies a snapshot of a cluster.
     *
     * To copy a cluster snapshot from a shared manual cluster snapshot, `SourceDBClusterSnapshotIdentifier` must be the Amazon Resource Name (ARN) of the shared cluster snapshot. You can only copy a shared DB cluster snapshot, whether encrypted or not, in the same Amazon Web Services Region.
     *
     * To cancel the copy operation after it is in progress, delete the target cluster snapshot identified by `TargetDBClusterSnapshotIdentifier` while that cluster snapshot is in the *copying* status.
     */
    suspend fun copyDbClusterSnapshot(block: CopyDbClusterSnapshotRequest.Builder.() -> Unit) = copyDbClusterSnapshot(CopyDbClusterSnapshotRequest.Builder().apply(block).build())

    /**
     * Creates a new Amazon DocumentDB cluster.
     */
    suspend fun createDbCluster(input: CreateDbClusterRequest): CreateDbClusterResponse

    /**
     * Creates a new Amazon DocumentDB cluster.
     */
    suspend fun createDbCluster(block: CreateDbClusterRequest.Builder.() -> Unit) = createDbCluster(CreateDbClusterRequest.Builder().apply(block).build())

    /**
     * Creates a new cluster parameter group.
     *
     * Parameters in a cluster parameter group apply to all of the instances in a cluster.
     *
     * A cluster parameter group is initially created with the default parameters for the database engine used by instances in the cluster. In Amazon DocumentDB, you cannot make modifications directly to the `default.docdb3.6` cluster parameter group. If your Amazon DocumentDB cluster is using the default cluster parameter group and you want to modify a value in it, you must first [ create a new parameter group](https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-create.html) or [ copy an existing parameter group](https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-copy.html), modify it, and then apply the modified parameter group to your cluster. For the new cluster parameter group and associated settings to take effect, you must then reboot the instances in the cluster without failover. For more information, see [ Modifying Amazon DocumentDB Cluster Parameter Groups](https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-modify.html).
     */
    suspend fun createDbClusterParameterGroup(input: CreateDbClusterParameterGroupRequest): CreateDbClusterParameterGroupResponse

    /**
     * Creates a new cluster parameter group.
     *
     * Parameters in a cluster parameter group apply to all of the instances in a cluster.
     *
     * A cluster parameter group is initially created with the default parameters for the database engine used by instances in the cluster. In Amazon DocumentDB, you cannot make modifications directly to the `default.docdb3.6` cluster parameter group. If your Amazon DocumentDB cluster is using the default cluster parameter group and you want to modify a value in it, you must first [ create a new parameter group](https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-create.html) or [ copy an existing parameter group](https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-copy.html), modify it, and then apply the modified parameter group to your cluster. For the new cluster parameter group and associated settings to take effect, you must then reboot the instances in the cluster without failover. For more information, see [ Modifying Amazon DocumentDB Cluster Parameter Groups](https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-modify.html).
     */
    suspend fun createDbClusterParameterGroup(block: CreateDbClusterParameterGroupRequest.Builder.() -> Unit) = createDbClusterParameterGroup(CreateDbClusterParameterGroupRequest.Builder().apply(block).build())

    /**
     * Creates a snapshot of a cluster.
     */
    suspend fun createDbClusterSnapshot(input: CreateDbClusterSnapshotRequest): CreateDbClusterSnapshotResponse

    /**
     * Creates a snapshot of a cluster.
     */
    suspend fun createDbClusterSnapshot(block: CreateDbClusterSnapshotRequest.Builder.() -> Unit) = createDbClusterSnapshot(CreateDbClusterSnapshotRequest.Builder().apply(block).build())

    /**
     * Creates a new instance.
     */
    suspend fun createDbInstance(input: CreateDbInstanceRequest): CreateDbInstanceResponse

    /**
     * Creates a new instance.
     */
    suspend fun createDbInstance(block: CreateDbInstanceRequest.Builder.() -> Unit) = createDbInstance(CreateDbInstanceRequest.Builder().apply(block).build())

    /**
     * Creates a new subnet group. subnet groups must contain at least one subnet in at least two Availability Zones in the Amazon Web Services Region.
     */
    suspend fun createDbSubnetGroup(input: CreateDbSubnetGroupRequest): CreateDbSubnetGroupResponse

    /**
     * Creates a new subnet group. subnet groups must contain at least one subnet in at least two Availability Zones in the Amazon Web Services Region.
     */
    suspend fun createDbSubnetGroup(block: CreateDbSubnetGroupRequest.Builder.() -> Unit) = createDbSubnetGroup(CreateDbSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Creates an Amazon DocumentDB event notification subscription. This action requires a topic Amazon Resource Name (ARN) created by using the Amazon DocumentDB console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the Amazon SNS console.
     *
     * You can specify the type of source (`SourceType`) that you want to be notified of. You can also provide a list of Amazon DocumentDB sources (`SourceIds`) that trigger the events, and you can provide a list of event categories (`EventCategories`) for events that you want to be notified of. For example, you can specify `SourceType = db-instance`, `SourceIds = mydbinstance1, mydbinstance2` and `EventCategories = Availability, Backup`.
     *
     * If you specify both the `SourceType` and `SourceIds` (such as `SourceType = db-instance` and `SourceIdentifier = myDBInstance1`), you are notified of all the `db-instance` events for the specified source. If you specify a `SourceType` but do not specify a `SourceIdentifier`, you receive notice of the events for that source type for all your Amazon DocumentDB sources. If you do not specify either the `SourceType` or the `SourceIdentifier`, you are notified of events generated from all Amazon DocumentDB sources belonging to your customer account.
     */
    suspend fun createEventSubscription(input: CreateEventSubscriptionRequest): CreateEventSubscriptionResponse

    /**
     * Creates an Amazon DocumentDB event notification subscription. This action requires a topic Amazon Resource Name (ARN) created by using the Amazon DocumentDB console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the Amazon SNS console.
     *
     * You can specify the type of source (`SourceType`) that you want to be notified of. You can also provide a list of Amazon DocumentDB sources (`SourceIds`) that trigger the events, and you can provide a list of event categories (`EventCategories`) for events that you want to be notified of. For example, you can specify `SourceType = db-instance`, `SourceIds = mydbinstance1, mydbinstance2` and `EventCategories = Availability, Backup`.
     *
     * If you specify both the `SourceType` and `SourceIds` (such as `SourceType = db-instance` and `SourceIdentifier = myDBInstance1`), you are notified of all the `db-instance` events for the specified source. If you specify a `SourceType` but do not specify a `SourceIdentifier`, you receive notice of the events for that source type for all your Amazon DocumentDB sources. If you do not specify either the `SourceType` or the `SourceIdentifier`, you are notified of events generated from all Amazon DocumentDB sources belonging to your customer account.
     */
    suspend fun createEventSubscription(block: CreateEventSubscriptionRequest.Builder.() -> Unit) = createEventSubscription(CreateEventSubscriptionRequest.Builder().apply(block).build())

    /**
     * Creates an Amazon DocumentDB global cluster that can span multiple multiple Amazon Web Services Regions. The global cluster contains one primary cluster with read-write capability, and up-to give read-only secondary clusters. Global clusters uses storage-based fast replication across regions with latencies less than one second, using dedicated infrastructure with no impact to your workload’s performance.
     *
     * You can create a global cluster that is initially empty, and then add a primary and a secondary to it. Or you can specify an existing cluster during the create operation, and this cluster becomes the primary of the global cluster.
     *
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun createGlobalCluster(input: CreateGlobalClusterRequest): CreateGlobalClusterResponse

    /**
     * Creates an Amazon DocumentDB global cluster that can span multiple multiple Amazon Web Services Regions. The global cluster contains one primary cluster with read-write capability, and up-to give read-only secondary clusters. Global clusters uses storage-based fast replication across regions with latencies less than one second, using dedicated infrastructure with no impact to your workload’s performance.
     *
     * You can create a global cluster that is initially empty, and then add a primary and a secondary to it. Or you can specify an existing cluster during the create operation, and this cluster becomes the primary of the global cluster.
     *
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun createGlobalCluster(block: CreateGlobalClusterRequest.Builder.() -> Unit) = createGlobalCluster(CreateGlobalClusterRequest.Builder().apply(block).build())

    /**
     * Deletes a previously provisioned cluster. When you delete a cluster, all automated backups for that cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified cluster are not deleted.
     */
    suspend fun deleteDbCluster(input: DeleteDbClusterRequest): DeleteDbClusterResponse

    /**
     * Deletes a previously provisioned cluster. When you delete a cluster, all automated backups for that cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified cluster are not deleted.
     */
    suspend fun deleteDbCluster(block: DeleteDbClusterRequest.Builder.() -> Unit) = deleteDbCluster(DeleteDbClusterRequest.Builder().apply(block).build())

    /**
     * Deletes a specified cluster parameter group. The cluster parameter group to be deleted can't be associated with any clusters.
     */
    suspend fun deleteDbClusterParameterGroup(input: DeleteDbClusterParameterGroupRequest): DeleteDbClusterParameterGroupResponse

    /**
     * Deletes a specified cluster parameter group. The cluster parameter group to be deleted can't be associated with any clusters.
     */
    suspend fun deleteDbClusterParameterGroup(block: DeleteDbClusterParameterGroupRequest.Builder.() -> Unit) = deleteDbClusterParameterGroup(DeleteDbClusterParameterGroupRequest.Builder().apply(block).build())

    /**
     * Deletes a cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     *
     * The cluster snapshot must be in the `available` state to be deleted.
     */
    suspend fun deleteDbClusterSnapshot(input: DeleteDbClusterSnapshotRequest): DeleteDbClusterSnapshotResponse

    /**
     * Deletes a cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     *
     * The cluster snapshot must be in the `available` state to be deleted.
     */
    suspend fun deleteDbClusterSnapshot(block: DeleteDbClusterSnapshotRequest.Builder.() -> Unit) = deleteDbClusterSnapshot(DeleteDbClusterSnapshotRequest.Builder().apply(block).build())

    /**
     * Deletes a previously provisioned instance.
     */
    suspend fun deleteDbInstance(input: DeleteDbInstanceRequest): DeleteDbInstanceResponse

    /**
     * Deletes a previously provisioned instance.
     */
    suspend fun deleteDbInstance(block: DeleteDbInstanceRequest.Builder.() -> Unit) = deleteDbInstance(DeleteDbInstanceRequest.Builder().apply(block).build())

    /**
     * Deletes a subnet group.
     *
     * The specified database subnet group must not be associated with any DB instances.
     */
    suspend fun deleteDbSubnetGroup(input: DeleteDbSubnetGroupRequest): DeleteDbSubnetGroupResponse

    /**
     * Deletes a subnet group.
     *
     * The specified database subnet group must not be associated with any DB instances.
     */
    suspend fun deleteDbSubnetGroup(block: DeleteDbSubnetGroupRequest.Builder.() -> Unit) = deleteDbSubnetGroup(DeleteDbSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Deletes an Amazon DocumentDB event notification subscription.
     */
    suspend fun deleteEventSubscription(input: DeleteEventSubscriptionRequest): DeleteEventSubscriptionResponse

    /**
     * Deletes an Amazon DocumentDB event notification subscription.
     */
    suspend fun deleteEventSubscription(block: DeleteEventSubscriptionRequest.Builder.() -> Unit) = deleteEventSubscription(DeleteEventSubscriptionRequest.Builder().apply(block).build())

    /**
     * Deletes a global cluster. The primary and secondary clusters must already be detached or deleted before attempting to delete a global cluster.
     *
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun deleteGlobalCluster(input: DeleteGlobalClusterRequest): DeleteGlobalClusterResponse

    /**
     * Deletes a global cluster. The primary and secondary clusters must already be detached or deleted before attempting to delete a global cluster.
     *
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun deleteGlobalCluster(block: DeleteGlobalClusterRequest.Builder.() -> Unit) = deleteGlobalCluster(DeleteGlobalClusterRequest.Builder().apply(block).build())

    /**
     * Returns a list of certificate authority (CA) certificates provided by Amazon DocumentDB for this Amazon Web Services account.
     */
    suspend fun describeCertificates(input: DescribeCertificatesRequest = DescribeCertificatesRequest {}): DescribeCertificatesResponse

    /**
     * Returns a list of certificate authority (CA) certificates provided by Amazon DocumentDB for this Amazon Web Services account.
     */
    suspend fun describeCertificates(block: DescribeCertificatesRequest.Builder.() -> Unit) = describeCertificates(DescribeCertificatesRequest.Builder().apply(block).build())

    /**
     * Returns a list of `DBClusterParameterGroup` descriptions. If a `DBClusterParameterGroupName` parameter is specified, the list contains only the description of the specified cluster parameter group.
     */
    suspend fun describeDbClusterParameterGroups(input: DescribeDbClusterParameterGroupsRequest = DescribeDbClusterParameterGroupsRequest {}): DescribeDbClusterParameterGroupsResponse

    /**
     * Returns a list of `DBClusterParameterGroup` descriptions. If a `DBClusterParameterGroupName` parameter is specified, the list contains only the description of the specified cluster parameter group.
     */
    suspend fun describeDbClusterParameterGroups(block: DescribeDbClusterParameterGroupsRequest.Builder.() -> Unit) = describeDbClusterParameterGroups(DescribeDbClusterParameterGroupsRequest.Builder().apply(block).build())

    /**
     * Returns the detailed parameter list for a particular cluster parameter group.
     */
    suspend fun describeDbClusterParameters(input: DescribeDbClusterParametersRequest): DescribeDbClusterParametersResponse

    /**
     * Returns the detailed parameter list for a particular cluster parameter group.
     */
    suspend fun describeDbClusterParameters(block: DescribeDbClusterParametersRequest.Builder.() -> Unit) = describeDbClusterParameters(DescribeDbClusterParametersRequest.Builder().apply(block).build())

    /**
     * Returns a list of cluster snapshot attribute names and values for a manual DB cluster snapshot.
     *
     * When you share snapshots with other Amazon Web Services accounts, `DescribeDBClusterSnapshotAttributes` returns the `restore` attribute and a list of IDs for the Amazon Web Services accounts that are authorized to copy or restore the manual cluster snapshot. If `all` is included in the list of values for the `restore` attribute, then the manual cluster snapshot is public and can be copied or restored by all Amazon Web Services accounts.
     */
    suspend fun describeDbClusterSnapshotAttributes(input: DescribeDbClusterSnapshotAttributesRequest): DescribeDbClusterSnapshotAttributesResponse

    /**
     * Returns a list of cluster snapshot attribute names and values for a manual DB cluster snapshot.
     *
     * When you share snapshots with other Amazon Web Services accounts, `DescribeDBClusterSnapshotAttributes` returns the `restore` attribute and a list of IDs for the Amazon Web Services accounts that are authorized to copy or restore the manual cluster snapshot. If `all` is included in the list of values for the `restore` attribute, then the manual cluster snapshot is public and can be copied or restored by all Amazon Web Services accounts.
     */
    suspend fun describeDbClusterSnapshotAttributes(block: DescribeDbClusterSnapshotAttributesRequest.Builder.() -> Unit) = describeDbClusterSnapshotAttributes(DescribeDbClusterSnapshotAttributesRequest.Builder().apply(block).build())

    /**
     * Returns information about cluster snapshots. This API operation supports pagination.
     */
    suspend fun describeDbClusterSnapshots(input: DescribeDbClusterSnapshotsRequest = DescribeDbClusterSnapshotsRequest {}): DescribeDbClusterSnapshotsResponse

    /**
     * Returns information about cluster snapshots. This API operation supports pagination.
     */
    suspend fun describeDbClusterSnapshots(block: DescribeDbClusterSnapshotsRequest.Builder.() -> Unit) = describeDbClusterSnapshots(DescribeDbClusterSnapshotsRequest.Builder().apply(block).build())

    /**
     * Returns information about provisioned Amazon DocumentDB clusters. This API operation supports pagination. For certain management features such as cluster and instance lifecycle management, Amazon DocumentDB leverages operational technology that is shared with Amazon RDS and Amazon Neptune. Use the `filterName=engine,Values=docdb` filter parameter to return only Amazon DocumentDB clusters.
     */
    suspend fun describeDbClusters(input: DescribeDbClustersRequest = DescribeDbClustersRequest {}): DescribeDbClustersResponse

    /**
     * Returns information about provisioned Amazon DocumentDB clusters. This API operation supports pagination. For certain management features such as cluster and instance lifecycle management, Amazon DocumentDB leverages operational technology that is shared with Amazon RDS and Amazon Neptune. Use the `filterName=engine,Values=docdb` filter parameter to return only Amazon DocumentDB clusters.
     */
    suspend fun describeDbClusters(block: DescribeDbClustersRequest.Builder.() -> Unit) = describeDbClusters(DescribeDbClustersRequest.Builder().apply(block).build())

    /**
     * Returns a list of the available engines.
     */
    suspend fun describeDbEngineVersions(input: DescribeDbEngineVersionsRequest = DescribeDbEngineVersionsRequest {}): DescribeDbEngineVersionsResponse

    /**
     * Returns a list of the available engines.
     */
    suspend fun describeDbEngineVersions(block: DescribeDbEngineVersionsRequest.Builder.() -> Unit) = describeDbEngineVersions(DescribeDbEngineVersionsRequest.Builder().apply(block).build())

    /**
     * Returns information about provisioned Amazon DocumentDB instances. This API supports pagination.
     */
    suspend fun describeDbInstances(input: DescribeDbInstancesRequest = DescribeDbInstancesRequest {}): DescribeDbInstancesResponse

    /**
     * Returns information about provisioned Amazon DocumentDB instances. This API supports pagination.
     */
    suspend fun describeDbInstances(block: DescribeDbInstancesRequest.Builder.() -> Unit) = describeDbInstances(DescribeDbInstancesRequest.Builder().apply(block).build())

    /**
     * Returns a list of `DBSubnetGroup` descriptions. If a `DBSubnetGroupName` is specified, the list will contain only the descriptions of the specified `DBSubnetGroup`.
     */
    suspend fun describeDbSubnetGroups(input: DescribeDbSubnetGroupsRequest = DescribeDbSubnetGroupsRequest {}): DescribeDbSubnetGroupsResponse

    /**
     * Returns a list of `DBSubnetGroup` descriptions. If a `DBSubnetGroupName` is specified, the list will contain only the descriptions of the specified `DBSubnetGroup`.
     */
    suspend fun describeDbSubnetGroups(block: DescribeDbSubnetGroupsRequest.Builder.() -> Unit) = describeDbSubnetGroups(DescribeDbSubnetGroupsRequest.Builder().apply(block).build())

    /**
     * Returns the default engine and system parameter information for the cluster database engine.
     */
    suspend fun describeEngineDefaultClusterParameters(input: DescribeEngineDefaultClusterParametersRequest): DescribeEngineDefaultClusterParametersResponse

    /**
     * Returns the default engine and system parameter information for the cluster database engine.
     */
    suspend fun describeEngineDefaultClusterParameters(block: DescribeEngineDefaultClusterParametersRequest.Builder.() -> Unit) = describeEngineDefaultClusterParameters(DescribeEngineDefaultClusterParametersRequest.Builder().apply(block).build())

    /**
     * Displays a list of categories for all event source types, or, if specified, for a specified source type.
     */
    suspend fun describeEventCategories(input: DescribeEventCategoriesRequest = DescribeEventCategoriesRequest {}): DescribeEventCategoriesResponse

    /**
     * Displays a list of categories for all event source types, or, if specified, for a specified source type.
     */
    suspend fun describeEventCategories(block: DescribeEventCategoriesRequest.Builder.() -> Unit) = describeEventCategories(DescribeEventCategoriesRequest.Builder().apply(block).build())

    /**
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes `SubscriptionName`, `SNSTopicARN`, `CustomerID`, `SourceType`, `SourceID`, `CreationTime`, and `Status`.
     *
     * If you specify a `SubscriptionName`, lists the description for that subscription.
     */
    suspend fun describeEventSubscriptions(input: DescribeEventSubscriptionsRequest = DescribeEventSubscriptionsRequest {}): DescribeEventSubscriptionsResponse

    /**
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes `SubscriptionName`, `SNSTopicARN`, `CustomerID`, `SourceType`, `SourceID`, `CreationTime`, and `Status`.
     *
     * If you specify a `SubscriptionName`, lists the description for that subscription.
     */
    suspend fun describeEventSubscriptions(block: DescribeEventSubscriptionsRequest.Builder.() -> Unit) = describeEventSubscriptions(DescribeEventSubscriptionsRequest.Builder().apply(block).build())

    /**
     * Returns events related to instances, security groups, snapshots, and DB parameter groups for the past 14 days. You can obtain events specific to a particular DB instance, security group, snapshot, or parameter group by providing the name as a parameter. By default, the events of the past hour are returned.
     */
    suspend fun describeEvents(input: DescribeEventsRequest = DescribeEventsRequest {}): DescribeEventsResponse

    /**
     * Returns events related to instances, security groups, snapshots, and DB parameter groups for the past 14 days. You can obtain events specific to a particular DB instance, security group, snapshot, or parameter group by providing the name as a parameter. By default, the events of the past hour are returned.
     */
    suspend fun describeEvents(block: DescribeEventsRequest.Builder.() -> Unit) = describeEvents(DescribeEventsRequest.Builder().apply(block).build())

    /**
     * Returns information about Amazon DocumentDB global clusters. This API supports pagination.
     *
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun describeGlobalClusters(input: DescribeGlobalClustersRequest = DescribeGlobalClustersRequest {}): DescribeGlobalClustersResponse

    /**
     * Returns information about Amazon DocumentDB global clusters. This API supports pagination.
     *
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun describeGlobalClusters(block: DescribeGlobalClustersRequest.Builder.() -> Unit) = describeGlobalClusters(DescribeGlobalClustersRequest.Builder().apply(block).build())

    /**
     * Returns a list of orderable instance options for the specified engine.
     */
    suspend fun describeOrderableDbInstanceOptions(input: DescribeOrderableDbInstanceOptionsRequest): DescribeOrderableDbInstanceOptionsResponse

    /**
     * Returns a list of orderable instance options for the specified engine.
     */
    suspend fun describeOrderableDbInstanceOptions(block: DescribeOrderableDbInstanceOptionsRequest.Builder.() -> Unit) = describeOrderableDbInstanceOptions(DescribeOrderableDbInstanceOptionsRequest.Builder().apply(block).build())

    /**
     * Returns a list of resources (for example, instances) that have at least one pending maintenance action.
     */
    suspend fun describePendingMaintenanceActions(input: DescribePendingMaintenanceActionsRequest = DescribePendingMaintenanceActionsRequest {}): DescribePendingMaintenanceActionsResponse

    /**
     * Returns a list of resources (for example, instances) that have at least one pending maintenance action.
     */
    suspend fun describePendingMaintenanceActions(block: DescribePendingMaintenanceActionsRequest.Builder.() -> Unit) = describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.Builder().apply(block).build())

    /**
     * Forces a failover for a cluster.
     *
     * A failover for a cluster promotes one of the Amazon DocumentDB replicas (read-only instances) in the cluster to be the primary instance (the cluster writer).
     *
     * If the primary instance fails, Amazon DocumentDB automatically fails over to an Amazon DocumentDB replica, if one exists. You can force a failover when you want to simulate a failure of a primary instance for testing.
     */
    suspend fun failoverDbCluster(input: FailoverDbClusterRequest = FailoverDbClusterRequest {}): FailoverDbClusterResponse

    /**
     * Forces a failover for a cluster.
     *
     * A failover for a cluster promotes one of the Amazon DocumentDB replicas (read-only instances) in the cluster to be the primary instance (the cluster writer).
     *
     * If the primary instance fails, Amazon DocumentDB automatically fails over to an Amazon DocumentDB replica, if one exists. You can force a failover when you want to simulate a failure of a primary instance for testing.
     */
    suspend fun failoverDbCluster(block: FailoverDbClusterRequest.Builder.() -> Unit) = failoverDbCluster(FailoverDbClusterRequest.Builder().apply(block).build())

    /**
     * Lists all tags on an Amazon DocumentDB resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists all tags on an Amazon DocumentDB resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Modifies a setting for an Amazon DocumentDB cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.
     */
    suspend fun modifyDbCluster(input: ModifyDbClusterRequest): ModifyDbClusterResponse

    /**
     * Modifies a setting for an Amazon DocumentDB cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.
     */
    suspend fun modifyDbCluster(block: ModifyDbClusterRequest.Builder.() -> Unit) = modifyDbCluster(ModifyDbClusterRequest.Builder().apply(block).build())

    /**
     * Modifies the parameters of a cluster parameter group. To modify more than one parameter, submit a list of the following: `ParameterName`, `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be modified in a single request.
     *
     * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot or maintenance window before the change can take effect.
     *
     * After you create a cluster parameter group, you should wait at least 5 minutes before creating your first cluster that uses that cluster parameter group as the default parameter group. This allows Amazon DocumentDB to fully complete the create action before the parameter group is used as the default for a new cluster. This step is especially important for parameters that are critical when creating the default database for a cluster, such as the character set for the default database defined by the `character_set_database` parameter.
     */
    suspend fun modifyDbClusterParameterGroup(input: ModifyDbClusterParameterGroupRequest): ModifyDbClusterParameterGroupResponse

    /**
     * Modifies the parameters of a cluster parameter group. To modify more than one parameter, submit a list of the following: `ParameterName`, `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be modified in a single request.
     *
     * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot or maintenance window before the change can take effect.
     *
     * After you create a cluster parameter group, you should wait at least 5 minutes before creating your first cluster that uses that cluster parameter group as the default parameter group. This allows Amazon DocumentDB to fully complete the create action before the parameter group is used as the default for a new cluster. This step is especially important for parameters that are critical when creating the default database for a cluster, such as the character set for the default database defined by the `character_set_database` parameter.
     */
    suspend fun modifyDbClusterParameterGroup(block: ModifyDbClusterParameterGroupRequest.Builder.() -> Unit) = modifyDbClusterParameterGroup(ModifyDbClusterParameterGroupRequest.Builder().apply(block).build())

    /**
     * Adds an attribute and values to, or removes an attribute and values from, a manual cluster snapshot.
     *
     * To share a manual cluster snapshot with other Amazon Web Services accounts, specify `restore` as the `AttributeName`, and use the `ValuesToAdd` parameter to add a list of IDs of the Amazon Web Services accounts that are authorized to restore the manual cluster snapshot. Use the value `all` to make the manual cluster snapshot public, which means that it can be copied or restored by all Amazon Web Services accounts. Do not add the `all` value for any manual cluster snapshots that contain private information that you don't want available to all Amazon Web Services accounts. If a manual cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized Amazon Web Services account IDs for the `ValuesToAdd` parameter. You can't use `all` as a value for that parameter in this case.
     */
    suspend fun modifyDbClusterSnapshotAttribute(input: ModifyDbClusterSnapshotAttributeRequest): ModifyDbClusterSnapshotAttributeResponse

    /**
     * Adds an attribute and values to, or removes an attribute and values from, a manual cluster snapshot.
     *
     * To share a manual cluster snapshot with other Amazon Web Services accounts, specify `restore` as the `AttributeName`, and use the `ValuesToAdd` parameter to add a list of IDs of the Amazon Web Services accounts that are authorized to restore the manual cluster snapshot. Use the value `all` to make the manual cluster snapshot public, which means that it can be copied or restored by all Amazon Web Services accounts. Do not add the `all` value for any manual cluster snapshots that contain private information that you don't want available to all Amazon Web Services accounts. If a manual cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized Amazon Web Services account IDs for the `ValuesToAdd` parameter. You can't use `all` as a value for that parameter in this case.
     */
    suspend fun modifyDbClusterSnapshotAttribute(block: ModifyDbClusterSnapshotAttributeRequest.Builder.() -> Unit) = modifyDbClusterSnapshotAttribute(ModifyDbClusterSnapshotAttributeRequest.Builder().apply(block).build())

    /**
     * Modifies settings for an instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.
     */
    suspend fun modifyDbInstance(input: ModifyDbInstanceRequest): ModifyDbInstanceResponse

    /**
     * Modifies settings for an instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.
     */
    suspend fun modifyDbInstance(block: ModifyDbInstanceRequest.Builder.() -> Unit) = modifyDbInstance(ModifyDbInstanceRequest.Builder().apply(block).build())

    /**
     * Modifies an existing subnet group. subnet groups must contain at least one subnet in at least two Availability Zones in the Amazon Web Services Region.
     */
    suspend fun modifyDbSubnetGroup(input: ModifyDbSubnetGroupRequest): ModifyDbSubnetGroupResponse

    /**
     * Modifies an existing subnet group. subnet groups must contain at least one subnet in at least two Availability Zones in the Amazon Web Services Region.
     */
    suspend fun modifyDbSubnetGroup(block: ModifyDbSubnetGroupRequest.Builder.() -> Unit) = modifyDbSubnetGroup(ModifyDbSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Modifies an existing Amazon DocumentDB event notification subscription.
     */
    suspend fun modifyEventSubscription(input: ModifyEventSubscriptionRequest): ModifyEventSubscriptionResponse

    /**
     * Modifies an existing Amazon DocumentDB event notification subscription.
     */
    suspend fun modifyEventSubscription(block: ModifyEventSubscriptionRequest.Builder.() -> Unit) = modifyEventSubscription(ModifyEventSubscriptionRequest.Builder().apply(block).build())

    /**
     * Modify a setting for an Amazon DocumentDB global cluster. You can change one or more configuration parameters (for example: deletion protection), or the global cluster identifier by specifying these parameters and the new values in the request.
     *
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun modifyGlobalCluster(input: ModifyGlobalClusterRequest): ModifyGlobalClusterResponse

    /**
     * Modify a setting for an Amazon DocumentDB global cluster. You can change one or more configuration parameters (for example: deletion protection), or the global cluster identifier by specifying these parameters and the new values in the request.
     *
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun modifyGlobalCluster(block: ModifyGlobalClusterRequest.Builder.() -> Unit) = modifyGlobalCluster(ModifyGlobalClusterRequest.Builder().apply(block).build())

    /**
     * You might need to reboot your instance, usually for maintenance reasons. For example, if you make certain changes, or if you change the cluster parameter group that is associated with the instance, you must reboot the instance for the changes to take effect.
     *
     * Rebooting an instance restarts the database engine service. Rebooting an instance results in a momentary outage, during which the instance status is set to *rebooting*.
     */
    suspend fun rebootDbInstance(input: RebootDbInstanceRequest): RebootDbInstanceResponse

    /**
     * You might need to reboot your instance, usually for maintenance reasons. For example, if you make certain changes, or if you change the cluster parameter group that is associated with the instance, you must reboot the instance for the changes to take effect.
     *
     * Rebooting an instance restarts the database engine service. Rebooting an instance results in a momentary outage, during which the instance status is set to *rebooting*.
     */
    suspend fun rebootDbInstance(block: RebootDbInstanceRequest.Builder.() -> Unit) = rebootDbInstance(RebootDbInstanceRequest.Builder().apply(block).build())

    /**
     * Detaches an Amazon DocumentDB secondary cluster from a global cluster. The cluster becomes a standalone cluster with read-write capability instead of being read-only and receiving data from a primary in a different region.
     *
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun removeFromGlobalCluster(input: RemoveFromGlobalClusterRequest): RemoveFromGlobalClusterResponse

    /**
     * Detaches an Amazon DocumentDB secondary cluster from a global cluster. The cluster becomes a standalone cluster with read-write capability instead of being read-only and receiving data from a primary in a different region.
     *
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun removeFromGlobalCluster(block: RemoveFromGlobalClusterRequest.Builder.() -> Unit) = removeFromGlobalCluster(RemoveFromGlobalClusterRequest.Builder().apply(block).build())

    /**
     * Removes a source identifier from an existing Amazon DocumentDB event notification subscription.
     */
    suspend fun removeSourceIdentifierFromSubscription(input: RemoveSourceIdentifierFromSubscriptionRequest): RemoveSourceIdentifierFromSubscriptionResponse

    /**
     * Removes a source identifier from an existing Amazon DocumentDB event notification subscription.
     */
    suspend fun removeSourceIdentifierFromSubscription(block: RemoveSourceIdentifierFromSubscriptionRequest.Builder.() -> Unit) = removeSourceIdentifierFromSubscription(RemoveSourceIdentifierFromSubscriptionRequest.Builder().apply(block).build())

    /**
     * Removes metadata tags from an Amazon DocumentDB resource.
     */
    suspend fun removeTagsFromResource(input: RemoveTagsFromResourceRequest): RemoveTagsFromResourceResponse

    /**
     * Removes metadata tags from an Amazon DocumentDB resource.
     */
    suspend fun removeTagsFromResource(block: RemoveTagsFromResourceRequest.Builder.() -> Unit) = removeTagsFromResource(RemoveTagsFromResourceRequest.Builder().apply(block).build())

    /**
     * Modifies the parameters of a cluster parameter group to the default value. To reset specific parameters, submit a list of the following: `ParameterName` and `ApplyMethod`. To reset the entire cluster parameter group, specify the `DBClusterParameterGroupName` and `ResetAllParameters` parameters.
     *
     *  When you reset the entire group, dynamic parameters are updated immediately and static parameters are set to `pending-reboot` to take effect on the next DB instance reboot.
     */
    suspend fun resetDbClusterParameterGroup(input: ResetDbClusterParameterGroupRequest): ResetDbClusterParameterGroupResponse

    /**
     * Modifies the parameters of a cluster parameter group to the default value. To reset specific parameters, submit a list of the following: `ParameterName` and `ApplyMethod`. To reset the entire cluster parameter group, specify the `DBClusterParameterGroupName` and `ResetAllParameters` parameters.
     *
     *  When you reset the entire group, dynamic parameters are updated immediately and static parameters are set to `pending-reboot` to take effect on the next DB instance reboot.
     */
    suspend fun resetDbClusterParameterGroup(block: ResetDbClusterParameterGroupRequest.Builder.() -> Unit) = resetDbClusterParameterGroup(ResetDbClusterParameterGroupRequest.Builder().apply(block).build())

    /**
     * Creates a new cluster from a snapshot or cluster snapshot.
     *
     * If a snapshot is specified, the target cluster is created from the source DB snapshot with a default configuration and default security group.
     *
     * If a cluster snapshot is specified, the target cluster is created from the source cluster restore point with the same configuration as the original source DB cluster, except that the new cluster is created with the default security group.
     */
    suspend fun restoreDbClusterFromSnapshot(input: RestoreDbClusterFromSnapshotRequest): RestoreDbClusterFromSnapshotResponse

    /**
     * Creates a new cluster from a snapshot or cluster snapshot.
     *
     * If a snapshot is specified, the target cluster is created from the source DB snapshot with a default configuration and default security group.
     *
     * If a cluster snapshot is specified, the target cluster is created from the source cluster restore point with the same configuration as the original source DB cluster, except that the new cluster is created with the default security group.
     */
    suspend fun restoreDbClusterFromSnapshot(block: RestoreDbClusterFromSnapshotRequest.Builder.() -> Unit) = restoreDbClusterFromSnapshot(RestoreDbClusterFromSnapshotRequest.Builder().apply(block).build())

    /**
     * Restores a cluster to an arbitrary point in time. Users can restore to any point in time before `LatestRestorableTime` for up to `BackupRetentionPeriod` days. The target cluster is created from the source cluster with the same configuration as the original cluster, except that the new cluster is created with the default security group.
     */
    suspend fun restoreDbClusterToPointInTime(input: RestoreDbClusterToPointInTimeRequest): RestoreDbClusterToPointInTimeResponse

    /**
     * Restores a cluster to an arbitrary point in time. Users can restore to any point in time before `LatestRestorableTime` for up to `BackupRetentionPeriod` days. The target cluster is created from the source cluster with the same configuration as the original cluster, except that the new cluster is created with the default security group.
     */
    suspend fun restoreDbClusterToPointInTime(block: RestoreDbClusterToPointInTimeRequest.Builder.() -> Unit) = restoreDbClusterToPointInTime(RestoreDbClusterToPointInTimeRequest.Builder().apply(block).build())

    /**
     * Restarts the stopped cluster that is specified by `DBClusterIdentifier`. For more information, see [Stopping and Starting an Amazon DocumentDB Cluster](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html).
     */
    suspend fun startDbCluster(input: StartDbClusterRequest): StartDbClusterResponse

    /**
     * Restarts the stopped cluster that is specified by `DBClusterIdentifier`. For more information, see [Stopping and Starting an Amazon DocumentDB Cluster](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html).
     */
    suspend fun startDbCluster(block: StartDbClusterRequest.Builder.() -> Unit) = startDbCluster(StartDbClusterRequest.Builder().apply(block).build())

    /**
     * Stops the running cluster that is specified by `DBClusterIdentifier`. The cluster must be in the *available* state. For more information, see [Stopping and Starting an Amazon DocumentDB Cluster](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html).
     */
    suspend fun stopDbCluster(input: StopDbClusterRequest): StopDbClusterResponse

    /**
     * Stops the running cluster that is specified by `DBClusterIdentifier`. The cluster must be in the *available* state. For more information, see [Stopping and Starting an Amazon DocumentDB Cluster](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html).
     */
    suspend fun stopDbCluster(block: StopDbClusterRequest.Builder.() -> Unit) = stopDbCluster(StopDbClusterRequest.Builder().apply(block).build())
}
