// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to CreateDBInstance.
 */
class CreateDbInstanceRequest private constructor(builder: Builder) {
    /**
     * This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.
     *
     * Default: `false`
     */
    val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * The Amazon EC2 Availability Zone that the instance is created in.
     *
     * Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.
     *
     * Example: `us-east-1d`
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The identifier of the cluster that the instance will belong to.
     */
    val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The compute and memory capacity of the instance; for example, `db.r5.large`.
     */
    val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * The instance identifier. This parameter is stored as a lowercase string.
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens.
     * + The first character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     *
     * Example: `mydbinstance`
     */
    val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * A value that indicates whether to enable Performance Insights for the DB Instance. For more information, see [Using Amazon Performance Insights](https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html).
     */
    val enablePerformanceInsights: kotlin.Boolean? = builder.enablePerformanceInsights
    /**
     * The name of the database engine to be used for this instance.
     *
     * Valid value: `docdb`
     */
    val engine: kotlin.String? = builder.engine
    /**
     * The KMS key identifier for encryption of Performance Insights data.
     *
     * The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     *
     * If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services region.
     */
    val performanceInsightsKmsKeyId: kotlin.String? = builder.performanceInsightsKmsKeyId
    /**
     * The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC).
     *
     *  Format: `ddd:hh24:mi-ddd:hh24:mi`
     *
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week.
     *
     * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
     *
     * Constraints: Minimum 30-minute window.
     */
    val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.
     *
     * Default: 1
     *
     * Valid values: 0-15
     */
    val promotionTier: kotlin.Int? = builder.promotionTier
    /**
     * The tags to be assigned to the instance. You can assign up to 10 tags to an instance.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.CreateDbInstanceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDbInstanceRequest(")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("availabilityZone=$availabilityZone,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("enablePerformanceInsights=$enablePerformanceInsights,")
        append("engine=$engine,")
        append("performanceInsightsKmsKeyId=$performanceInsightsKmsKeyId,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("promotionTier=$promotionTier,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoMinorVersionUpgrade?.hashCode() ?: 0
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (enablePerformanceInsights?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (promotionTier ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDbInstanceRequest

        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (availabilityZone != other.availabilityZone) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (enablePerformanceInsights != other.enablePerformanceInsights) return false
        if (engine != other.engine) return false
        if (performanceInsightsKmsKeyId != other.performanceInsightsKmsKeyId) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (promotionTier != other.promotionTier) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.CreateDbInstanceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.
         *
         * Default: `false`
         */
        var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * The Amazon EC2 Availability Zone that the instance is created in.
         *
         * Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.
         *
         * Example: `us-east-1d`
         */
        var availabilityZone: kotlin.String? = null
        /**
         * The identifier of the cluster that the instance will belong to.
         */
        var dbClusterIdentifier: kotlin.String? = null
        /**
         * The compute and memory capacity of the instance; for example, `db.r5.large`.
         */
        var dbInstanceClass: kotlin.String? = null
        /**
         * The instance identifier. This parameter is stored as a lowercase string.
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens.
         * + The first character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         *
         * Example: `mydbinstance`
         */
        var dbInstanceIdentifier: kotlin.String? = null
        /**
         * A value that indicates whether to enable Performance Insights for the DB Instance. For more information, see [Using Amazon Performance Insights](https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html).
         */
        var enablePerformanceInsights: kotlin.Boolean? = null
        /**
         * The name of the database engine to be used for this instance.
         *
         * Valid value: `docdb`
         */
        var engine: kotlin.String? = null
        /**
         * The KMS key identifier for encryption of Performance Insights data.
         *
         * The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         *
         * If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services region.
         */
        var performanceInsightsKmsKeyId: kotlin.String? = null
        /**
         * The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC).
         *
         *  Format: `ddd:hh24:mi-ddd:hh24:mi`
         *
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week.
         *
         * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         *
         * Constraints: Minimum 30-minute window.
         */
        var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.
         *
         * Default: 1
         *
         * Valid values: 0-15
         */
        var promotionTier: kotlin.Int? = null
        /**
         * The tags to be assigned to the instance. You can assign up to 10 tags to an instance.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.CreateDbInstanceRequest) : this() {
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.availabilityZone = x.availabilityZone
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.enablePerformanceInsights = x.enablePerformanceInsights
            this.engine = x.engine
            this.performanceInsightsKmsKeyId = x.performanceInsightsKmsKeyId
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.promotionTier = x.promotionTier
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.CreateDbInstanceRequest = CreateDbInstanceRequest(this)
    }
}
