// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Contains information about an instance that is part of a cluster.
 */
class DbClusterMember private constructor(builder: Builder) {
    /**
     * Specifies the status of the cluster parameter group for this member of the DB cluster.
     */
    val dbClusterParameterGroupStatus: kotlin.String? = builder.dbClusterParameterGroupStatus
    /**
     * Specifies the instance identifier for this member of the cluster.
     */
    val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * A value that is `true` if the cluster member is the primary instance for the cluster and `false` otherwise.
     */
    val isClusterWriter: kotlin.Boolean = builder.isClusterWriter
    /**
     * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.
     */
    val promotionTier: kotlin.Int? = builder.promotionTier

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.DbClusterMember = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbClusterMember(")
        append("dbClusterParameterGroupStatus=$dbClusterParameterGroupStatus,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("isClusterWriter=$isClusterWriter,")
        append("promotionTier=$promotionTier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterParameterGroupStatus?.hashCode() ?: 0
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (isClusterWriter.hashCode())
        result = 31 * result + (promotionTier ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbClusterMember

        if (dbClusterParameterGroupStatus != other.dbClusterParameterGroupStatus) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (isClusterWriter != other.isClusterWriter) return false
        if (promotionTier != other.promotionTier) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.DbClusterMember = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the status of the cluster parameter group for this member of the DB cluster.
         */
        var dbClusterParameterGroupStatus: kotlin.String? = null
        /**
         * Specifies the instance identifier for this member of the cluster.
         */
        var dbInstanceIdentifier: kotlin.String? = null
        /**
         * A value that is `true` if the cluster member is the primary instance for the cluster and `false` otherwise.
         */
        var isClusterWriter: kotlin.Boolean = false
        /**
         * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.
         */
        var promotionTier: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.DbClusterMember) : this() {
            this.dbClusterParameterGroupStatus = x.dbClusterParameterGroupStatus
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.isClusterWriter = x.isClusterWriter
            this.promotionTier = x.promotionTier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.DbClusterMember = DbClusterMember(this)
    }
}
