// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to DescribeDBClusterParameters.
 */
class DescribeDbClusterParametersRequest private constructor(builder: Builder) {
    /**
     * The name of a specific cluster parameter group to return parameter details for.
     *
     * Constraints:
     * + If provided, must match the name of an existing `DBClusterParameterGroup`.
     */
    val dbClusterParameterGroupName: kotlin.String? = builder.dbClusterParameterGroupName
    /**
     * This parameter is not currently supported.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token (marker) is included in the response so that the remaining results can be retrieved.
     *
     * Default: 100
     *
     * Constraints: Minimum 20, maximum 100.
     */
    val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * A value that indicates to return only parameters for a specific source. Parameter sources can be `engine`, `service`, or `customer`.
     */
    val source: kotlin.String? = builder.source

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.DescribeDbClusterParametersRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDbClusterParametersRequest(")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("source=$source)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterParameterGroupName?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDbClusterParametersRequest

        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (source != other.source) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.DescribeDbClusterParametersRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of a specific cluster parameter group to return parameter details for.
         *
         * Constraints:
         * + If provided, must match the name of an existing `DBClusterParameterGroup`.
         */
        var dbClusterParameterGroupName: kotlin.String? = null
        /**
         * This parameter is not currently supported.
         */
        var filters: List<Filter>? = null
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
         */
        var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token (marker) is included in the response so that the remaining results can be retrieved.
         *
         * Default: 100
         *
         * Constraints: Minimum 20, maximum 100.
         */
        var maxRecords: kotlin.Int? = null
        /**
         * A value that indicates to return only parameters for a specific source. Parameter sources can be `engine`, `service`, or `customer`.
         */
        var source: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.DescribeDbClusterParametersRequest) : this() {
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.source = x.source
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.DescribeDbClusterParametersRequest = DescribeDbClusterParametersRequest(this)
    }
}
