// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.docdb.model.DeleteDbClusterParameterGroupResponse
import aws.sdk.kotlin.services.docdb.model.DocDbException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class DeleteDBClusterParameterGroupOperationDeserializer: HttpDeserialize<DeleteDbClusterParameterGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteDbClusterParameterGroupResponse {
        if (!response.status.isSuccess()) {
            throwDeleteDbClusterParameterGroupError(context, response)
        }
        val builder = DeleteDbClusterParameterGroupResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDeleteDbClusterParameterGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw DocDbException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBParameterGroupNotFound" -> DbParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBParameterGroupState" -> InvalidDbParameterGroupStateFaultDeserializer().deserialize(context, wrappedResponse)
        else -> DocDbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
