// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.docdb.model.DbCluster
import aws.sdk.kotlin.services.docdb.model.DocDbException
import aws.sdk.kotlin.services.docdb.model.RestoreDbClusterFromSnapshotResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class RestoreDBClusterFromSnapshotOperationDeserializer: HttpDeserialize<RestoreDbClusterFromSnapshotResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RestoreDbClusterFromSnapshotResponse {
        if (!response.status.isSuccess()) {
            throwRestoreDbClusterFromSnapshotError(context, response)
        }
        val builder = RestoreDbClusterFromSnapshotResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRestoreDBClusterFromSnapshotOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRestoreDbClusterFromSnapshotError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw DocDbException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterAlreadyExistsFault" -> DbClusterAlreadyExistsFaultDeserializer().deserialize(context, wrappedResponse)
        "DBClusterQuotaExceededFault" -> DbClusterQuotaExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "DBClusterSnapshotNotFoundFault" -> DbClusterSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBSnapshotNotFound" -> DbSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBSubnetGroupNotFoundFault" -> DbSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InsufficientDBClusterCapacityFault" -> InsufficientDbClusterCapacityFaultDeserializer().deserialize(context, wrappedResponse)
        "InsufficientStorageClusterCapacity" -> InsufficientStorageClusterCapacityFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBClusterSnapshotStateFault" -> InvalidDbClusterSnapshotStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBSnapshotState" -> InvalidDbSnapshotStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidRestoreFault" -> InvalidRestoreFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedResponse)
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedResponse)
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedResponse)
        "StorageQuotaExceeded" -> StorageQuotaExceededFaultDeserializer().deserialize(context, wrappedResponse)
        else -> DocDbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRestoreDBClusterFromSnapshotOperationBody(builder: RestoreDbClusterFromSnapshotResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("RestoreDBClusterFromSnapshotResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("RestoreDBClusterFromSnapshotResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap RestoreDBClusterFromSnapshot response")
    }
    // end unwrap response wrapper

    val DBCLUSTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DBCluster"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://rds.amazonaws.com/doc/2014-10-31/"))
        trait(XmlSerialName("RestoreDBClusterFromSnapshotResult"))
        field(DBCLUSTER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DBCLUSTER_DESCRIPTOR.index -> builder.dbCluster = deserializeDbClusterDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
