// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to CreateEventSubscription.
 */
class CreateEventSubscriptionRequest private constructor(builder: Builder) {
    /**
     * A Boolean value; set to `true` to activate the subscription, set to `false` to create the subscription but not active it.
     */
    val enabled: kotlin.Boolean? = builder.enabled
    /**
     * A list of event categories for a `SourceType` that you want to subscribe to.
     */
    val eventCategories: List<String>? = builder.eventCategories
    /**
     * The Amazon Resource Name (ARN) of the SNS topic created for event notification. Amazon SNS creates the ARN when you create a topic and subscribe to it.
     */
    val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     *
     * Constraints:
     * + If `SourceIds` are provided, `SourceType` must also be provided.
     * + If the source type is an instance, a `DBInstanceIdentifier` must be provided.
     * + If the source type is a security group, a `DBSecurityGroupName` must be provided.
     * + If the source type is a parameter group, a `DBParameterGroupName` must be provided.
     * + If the source type is a snapshot, a `DBSnapshotIdentifier` must be provided.
     */
    val sourceIds: List<String>? = builder.sourceIds
    /**
     * The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, you would set this parameter to `db-instance`. If this value is not specified, all events are returned.
     *
     * Valid values: `db-instance`, `db-cluster`, `db-parameter-group`, `db-security-group`, `db-cluster-snapshot`
     */
    val sourceType: kotlin.String? = builder.sourceType
    /**
     * The name of the subscription.
     *
     * Constraints: The name must be fewer than 255 characters.
     */
    val subscriptionName: kotlin.String? = builder.subscriptionName
    /**
     * The tags to be assigned to the event subscription.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.CreateEventSubscriptionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEventSubscriptionRequest(")
        append("enabled=$enabled,")
        append("eventCategories=$eventCategories,")
        append("snsTopicArn=$snsTopicArn,")
        append("sourceIds=$sourceIds,")
        append("sourceType=$sourceType,")
        append("subscriptionName=$subscriptionName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (eventCategories?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (sourceIds?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (subscriptionName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEventSubscriptionRequest

        if (enabled != other.enabled) return false
        if (eventCategories != other.eventCategories) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (sourceIds != other.sourceIds) return false
        if (sourceType != other.sourceType) return false
        if (subscriptionName != other.subscriptionName) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.CreateEventSubscriptionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A Boolean value; set to `true` to activate the subscription, set to `false` to create the subscription but not active it.
         */
        var enabled: kotlin.Boolean? = null
        /**
         * A list of event categories for a `SourceType` that you want to subscribe to.
         */
        var eventCategories: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the SNS topic created for event notification. Amazon SNS creates the ARN when you create a topic and subscribe to it.
         */
        var snsTopicArn: kotlin.String? = null
        /**
         * The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
         *
         * Constraints:
         * + If `SourceIds` are provided, `SourceType` must also be provided.
         * + If the source type is an instance, a `DBInstanceIdentifier` must be provided.
         * + If the source type is a security group, a `DBSecurityGroupName` must be provided.
         * + If the source type is a parameter group, a `DBParameterGroupName` must be provided.
         * + If the source type is a snapshot, a `DBSnapshotIdentifier` must be provided.
         */
        var sourceIds: List<String>? = null
        /**
         * The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, you would set this parameter to `db-instance`. If this value is not specified, all events are returned.
         *
         * Valid values: `db-instance`, `db-cluster`, `db-parameter-group`, `db-security-group`, `db-cluster-snapshot`
         */
        var sourceType: kotlin.String? = null
        /**
         * The name of the subscription.
         *
         * Constraints: The name must be fewer than 255 characters.
         */
        var subscriptionName: kotlin.String? = null
        /**
         * The tags to be assigned to the event subscription.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.CreateEventSubscriptionRequest) : this() {
            this.enabled = x.enabled
            this.eventCategories = x.eventCategories
            this.snsTopicArn = x.snsTopicArn
            this.sourceIds = x.sourceIds
            this.sourceType = x.sourceType
            this.subscriptionName = x.subscriptionName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.CreateEventSubscriptionRequest = CreateEventSubscriptionRequest(this)
    }
}
