// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Describes an Identity and Access Management (IAM) role that is associated with a cluster.
 */
class DbClusterRole private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the IAMrole that is associated with the DB cluster.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * Describes the state of association between the IAMrole and the cluster. The `Status` property returns one of the following values:
     * + `ACTIVE` - The IAMrole ARN is associated with the cluster and can be used to access other Amazon Web Services services on your behalf.
     * + `PENDING` - The IAMrole ARN is being associated with the cluster.
     * + `INVALID` - The IAMrole ARN is associated with the cluster, but the cluster cannot assume the IAMrole to access other Amazon Web Services services on your behalf.
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.DbClusterRole = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbClusterRole(")
        append("roleArn=$roleArn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleArn?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbClusterRole

        if (roleArn != other.roleArn) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.DbClusterRole = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the IAMrole that is associated with the DB cluster.
         */
        var roleArn: kotlin.String? = null
        /**
         * Describes the state of association between the IAMrole and the cluster. The `Status` property returns one of the following values:
         * + `ACTIVE` - The IAMrole ARN is associated with the cluster and can be used to access other Amazon Web Services services on your behalf.
         * + `PENDING` - The IAMrole ARN is being associated with the cluster.
         * + `INVALID` - The IAMrole ARN is associated with the cluster, but the cluster cannot assume the IAMrole to access other Amazon Web Services services on your behalf.
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.DbClusterRole) : this() {
            this.roleArn = x.roleArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.DbClusterRole = DbClusterRole(this)
    }
}
