// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed information about an instance.
 */
class DbInstance private constructor(builder: Builder) {
    /**
     * Does not apply. This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.
     */
    val autoMinorVersionUpgrade: kotlin.Boolean = builder.autoMinorVersionUpgrade
    /**
     * Specifies the name of the Availability Zone that the instance is located in.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * Specifies the number of days for which automatic snapshots are retained.
     */
    val backupRetentionPeriod: kotlin.Int = builder.backupRetentionPeriod
    /**
     * The identifier of the CA certificate for this DB instance.
     */
    val caCertificateIdentifier: kotlin.String? = builder.caCertificateIdentifier
    /**
     * Contains the name of the cluster that the instance is a member of if the instance is a member of a cluster.
     */
    val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The Amazon Resource Name (ARN) for the instance.
     */
    val dbInstanceArn: kotlin.String? = builder.dbInstanceArn
    /**
     * Contains the name of the compute and memory capacity class of the instance.
     */
    val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * Contains a user-provided database identifier. This identifier is the unique key that identifies an instance.
     */
    val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * Specifies the current state of this database.
     */
    val dbInstanceStatus: kotlin.String? = builder.dbInstanceStatus
    /**
     * Specifies information on the subnet group that is associated with the instance, including the name, description, and subnets in the subnet group.
     */
    val dbSubnetGroup: aws.sdk.kotlin.services.docdb.model.DbSubnetGroup? = builder.dbSubnetGroup
    /**
     * The Amazon Web Services Region-unique, immutable identifier for the instance. This identifier is found in CloudTrail log entries whenever the KMS key for the instance is accessed.
     */
    val dbiResourceId: kotlin.String? = builder.dbiResourceId
    /**
     * A list of log types that this instance is configured to export to CloudWatch Logs.
     */
    val enabledCloudwatchLogsExports: List<String>? = builder.enabledCloudwatchLogsExports
    /**
     * Specifies the connection endpoint.
     */
    val endpoint: aws.sdk.kotlin.services.docdb.model.Endpoint? = builder.endpoint
    /**
     * Provides the name of the database engine to be used for this instance.
     */
    val engine: kotlin.String? = builder.engine
    /**
     * Indicates the database engine version.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Provides the date and time that the instance was created.
     */
    val instanceCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.instanceCreateTime
    /**
     * If `StorageEncrypted` is `true`, the KMS key identifier for the encrypted instance.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies the latest time to which a database can be restored with point-in-time restore.
     */
    val latestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = builder.latestRestorableTime
    /**
     * Specifies that changes to the instance are pending. This element is included only when changes are pending. Specific changes are identified by subelements.
     */
    val pendingModifiedValues: aws.sdk.kotlin.services.docdb.model.PendingModifiedValues? = builder.pendingModifiedValues
    /**
     * Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the `BackupRetentionPeriod`.
     */
    val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     */
    val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.
     */
    val promotionTier: kotlin.Int? = builder.promotionTier
    /**
     * Not supported. Amazon DocumentDB does not currently support public endpoints. The value of `PubliclyAccessible` is always `false`.
     */
    val publiclyAccessible: kotlin.Boolean = builder.publiclyAccessible
    /**
     * The status of a read replica. If the instance is not a read replica, this is blank.
     */
    val statusInfos: List<DbInstanceStatusInfo>? = builder.statusInfos
    /**
     * Specifies whether or not the instance is encrypted.
     */
    val storageEncrypted: kotlin.Boolean = builder.storageEncrypted
    /**
     * Provides a list of VPC security group elements that the instance belongs to.
     */
    val vpcSecurityGroups: List<VpcSecurityGroupMembership>? = builder.vpcSecurityGroups

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.DbInstance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbInstance(")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("availabilityZone=$availabilityZone,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("caCertificateIdentifier=$caCertificateIdentifier,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbInstanceArn=$dbInstanceArn,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbInstanceStatus=$dbInstanceStatus,")
        append("dbSubnetGroup=$dbSubnetGroup,")
        append("dbiResourceId=$dbiResourceId,")
        append("enabledCloudwatchLogsExports=$enabledCloudwatchLogsExports,")
        append("endpoint=$endpoint,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("instanceCreateTime=$instanceCreateTime,")
        append("kmsKeyId=$kmsKeyId,")
        append("latestRestorableTime=$latestRestorableTime,")
        append("pendingModifiedValues=$pendingModifiedValues,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("promotionTier=$promotionTier,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("statusInfos=$statusInfos,")
        append("storageEncrypted=$storageEncrypted,")
        append("vpcSecurityGroups=$vpcSecurityGroups)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoMinorVersionUpgrade.hashCode()
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod)
        result = 31 * result + (caCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceStatus?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroup?.hashCode() ?: 0)
        result = 31 * result + (dbiResourceId?.hashCode() ?: 0)
        result = 31 * result + (enabledCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (instanceCreateTime?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (latestRestorableTime?.hashCode() ?: 0)
        result = 31 * result + (pendingModifiedValues?.hashCode() ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (promotionTier ?: 0)
        result = 31 * result + (publiclyAccessible.hashCode())
        result = 31 * result + (statusInfos?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted.hashCode())
        result = 31 * result + (vpcSecurityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbInstance

        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (availabilityZone != other.availabilityZone) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (caCertificateIdentifier != other.caCertificateIdentifier) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbInstanceArn != other.dbInstanceArn) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbInstanceStatus != other.dbInstanceStatus) return false
        if (dbSubnetGroup != other.dbSubnetGroup) return false
        if (dbiResourceId != other.dbiResourceId) return false
        if (enabledCloudwatchLogsExports != other.enabledCloudwatchLogsExports) return false
        if (endpoint != other.endpoint) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (instanceCreateTime != other.instanceCreateTime) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (latestRestorableTime != other.latestRestorableTime) return false
        if (pendingModifiedValues != other.pendingModifiedValues) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (promotionTier != other.promotionTier) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (statusInfos != other.statusInfos) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (vpcSecurityGroups != other.vpcSecurityGroups) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.DbInstance = Builder(this).apply(block).build()

    class Builder {
        /**
         * Does not apply. This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.
         */
        var autoMinorVersionUpgrade: kotlin.Boolean = false
        /**
         * Specifies the name of the Availability Zone that the instance is located in.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * Specifies the number of days for which automatic snapshots are retained.
         */
        var backupRetentionPeriod: kotlin.Int = 0
        /**
         * The identifier of the CA certificate for this DB instance.
         */
        var caCertificateIdentifier: kotlin.String? = null
        /**
         * Contains the name of the cluster that the instance is a member of if the instance is a member of a cluster.
         */
        var dbClusterIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the instance.
         */
        var dbInstanceArn: kotlin.String? = null
        /**
         * Contains the name of the compute and memory capacity class of the instance.
         */
        var dbInstanceClass: kotlin.String? = null
        /**
         * Contains a user-provided database identifier. This identifier is the unique key that identifies an instance.
         */
        var dbInstanceIdentifier: kotlin.String? = null
        /**
         * Specifies the current state of this database.
         */
        var dbInstanceStatus: kotlin.String? = null
        /**
         * Specifies information on the subnet group that is associated with the instance, including the name, description, and subnets in the subnet group.
         */
        var dbSubnetGroup: aws.sdk.kotlin.services.docdb.model.DbSubnetGroup? = null
        /**
         * The Amazon Web Services Region-unique, immutable identifier for the instance. This identifier is found in CloudTrail log entries whenever the KMS key for the instance is accessed.
         */
        var dbiResourceId: kotlin.String? = null
        /**
         * A list of log types that this instance is configured to export to CloudWatch Logs.
         */
        var enabledCloudwatchLogsExports: List<String>? = null
        /**
         * Specifies the connection endpoint.
         */
        var endpoint: aws.sdk.kotlin.services.docdb.model.Endpoint? = null
        /**
         * Provides the name of the database engine to be used for this instance.
         */
        var engine: kotlin.String? = null
        /**
         * Indicates the database engine version.
         */
        var engineVersion: kotlin.String? = null
        /**
         * Provides the date and time that the instance was created.
         */
        var instanceCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If `StorageEncrypted` is `true`, the KMS key identifier for the encrypted instance.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * Specifies the latest time to which a database can be restored with point-in-time restore.
         */
        var latestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies that changes to the instance are pending. This element is included only when changes are pending. Specific changes are identified by subelements.
         */
        var pendingModifiedValues: aws.sdk.kotlin.services.docdb.model.PendingModifiedValues? = null
        /**
         * Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the `BackupRetentionPeriod`.
         */
        var preferredBackupWindow: kotlin.String? = null
        /**
         * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         */
        var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.
         */
        var promotionTier: kotlin.Int? = null
        /**
         * Not supported. Amazon DocumentDB does not currently support public endpoints. The value of `PubliclyAccessible` is always `false`.
         */
        var publiclyAccessible: kotlin.Boolean = false
        /**
         * The status of a read replica. If the instance is not a read replica, this is blank.
         */
        var statusInfos: List<DbInstanceStatusInfo>? = null
        /**
         * Specifies whether or not the instance is encrypted.
         */
        var storageEncrypted: kotlin.Boolean = false
        /**
         * Provides a list of VPC security group elements that the instance belongs to.
         */
        var vpcSecurityGroups: List<VpcSecurityGroupMembership>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.DbInstance) : this() {
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.availabilityZone = x.availabilityZone
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.caCertificateIdentifier = x.caCertificateIdentifier
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbInstanceArn = x.dbInstanceArn
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbInstanceStatus = x.dbInstanceStatus
            this.dbSubnetGroup = x.dbSubnetGroup
            this.dbiResourceId = x.dbiResourceId
            this.enabledCloudwatchLogsExports = x.enabledCloudwatchLogsExports
            this.endpoint = x.endpoint
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.instanceCreateTime = x.instanceCreateTime
            this.kmsKeyId = x.kmsKeyId
            this.latestRestorableTime = x.latestRestorableTime
            this.pendingModifiedValues = x.pendingModifiedValues
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.promotionTier = x.promotionTier
            this.publiclyAccessible = x.publiclyAccessible
            this.statusInfos = x.statusInfos
            this.storageEncrypted = x.storageEncrypted
            this.vpcSecurityGroups = x.vpcSecurityGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.DbInstance = DbInstance(this)

        /**
         * construct an [aws.sdk.kotlin.services.docdb.model.DbSubnetGroup] inside the given [block]
         */
        fun dbSubnetGroup(block: aws.sdk.kotlin.services.docdb.model.DbSubnetGroup.Builder.() -> kotlin.Unit) {
            this.dbSubnetGroup = aws.sdk.kotlin.services.docdb.model.DbSubnetGroup.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.docdb.model.Endpoint] inside the given [block]
         */
        fun endpoint(block: aws.sdk.kotlin.services.docdb.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.endpoint = aws.sdk.kotlin.services.docdb.model.Endpoint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.docdb.model.PendingModifiedValues] inside the given [block]
         */
        fun pendingModifiedValues(block: aws.sdk.kotlin.services.docdb.model.PendingModifiedValues.Builder.() -> kotlin.Unit) {
            this.pendingModifiedValues = aws.sdk.kotlin.services.docdb.model.PendingModifiedValues.invoke(block)
        }
    }
}
