// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to DescribeDBClusterSnapshots.
 */
class DescribeDbClusterSnapshotsRequest private constructor(builder: Builder) {
    /**
     * The ID of the cluster to retrieve the list of cluster snapshots for. This parameter can't be used with the `DBClusterSnapshotIdentifier` parameter. This parameter is not case sensitive.
     *
     * Constraints:
     * + If provided, must match the identifier of an existing `DBCluster`.
     */
    val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * A specific cluster snapshot identifier to describe. This parameter can't be used with the `DBClusterIdentifier` parameter. This value is stored as a lowercase string.
     *
     * Constraints:
     * + If provided, must match the identifier of an existing `DBClusterSnapshot`.
     * + If this identifier is for an automated snapshot, the `SnapshotType` parameter must also be specified.
     */
    val dbClusterSnapshotIdentifier: kotlin.String? = builder.dbClusterSnapshotIdentifier
    /**
     * This parameter is not currently supported.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * Set to `true` to include manual cluster snapshots that are public and can be copied or restored by any Amazon Web Services account, and otherwise `false`. The default is `false`.
     */
    val includePublic: kotlin.Boolean = builder.includePublic
    /**
     * Set to `true` to include shared manual cluster snapshots from other Amazon Web Services accounts that this Amazon Web Services account has been given permission to copy or restore, and otherwise `false`. The default is `false`.
     */
    val includeShared: kotlin.Boolean = builder.includeShared
    /**
     * An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token (marker) is included in the response so that the remaining results can be retrieved.
     *
     * Default: 100
     *
     * Constraints: Minimum 20, maximum 100.
     */
    val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The type of cluster snapshots to be returned. You can specify one of the following values:
     * + `automated` - Return all cluster snapshots that Amazon DocumentDB has automatically created for your Amazon Web Services account.
     * + `manual` - Return all cluster snapshots that you have manually created for your Amazon Web Services account.
     * + `shared` - Return all manual cluster snapshots that have been shared to your Amazon Web Services account.
     * + `public` - Return all cluster snapshots that have been marked as public.
     *
     * If you don't specify a `SnapshotType` value, then both automated and manual cluster snapshots are returned. You can include shared cluster snapshots with these results by setting the `IncludeShared` parameter to `true`. You can include public cluster snapshots with these results by setting the`IncludePublic` parameter to `true`.
     *
     * The `IncludeShared` and `IncludePublic` parameters don't apply for `SnapshotType` values of `manual` or `automated`. The `IncludePublic` parameter doesn't apply when `SnapshotType` is set to `shared`. The `IncludeShared` parameter doesn't apply when `SnapshotType` is set to `public`.
     */
    val snapshotType: kotlin.String? = builder.snapshotType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdb.model.DescribeDbClusterSnapshotsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDbClusterSnapshotsRequest(")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterSnapshotIdentifier=$dbClusterSnapshotIdentifier,")
        append("filters=$filters,")
        append("includePublic=$includePublic,")
        append("includeShared=$includeShared,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("snapshotType=$snapshotType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (dbClusterSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (includePublic.hashCode())
        result = 31 * result + (includeShared.hashCode())
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (snapshotType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDbClusterSnapshotsRequest

        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterSnapshotIdentifier != other.dbClusterSnapshotIdentifier) return false
        if (filters != other.filters) return false
        if (includePublic != other.includePublic) return false
        if (includeShared != other.includeShared) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (snapshotType != other.snapshotType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdb.model.DescribeDbClusterSnapshotsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the cluster to retrieve the list of cluster snapshots for. This parameter can't be used with the `DBClusterSnapshotIdentifier` parameter. This parameter is not case sensitive.
         *
         * Constraints:
         * + If provided, must match the identifier of an existing `DBCluster`.
         */
        var dbClusterIdentifier: kotlin.String? = null
        /**
         * A specific cluster snapshot identifier to describe. This parameter can't be used with the `DBClusterIdentifier` parameter. This value is stored as a lowercase string.
         *
         * Constraints:
         * + If provided, must match the identifier of an existing `DBClusterSnapshot`.
         * + If this identifier is for an automated snapshot, the `SnapshotType` parameter must also be specified.
         */
        var dbClusterSnapshotIdentifier: kotlin.String? = null
        /**
         * This parameter is not currently supported.
         */
        var filters: List<Filter>? = null
        /**
         * Set to `true` to include manual cluster snapshots that are public and can be copied or restored by any Amazon Web Services account, and otherwise `false`. The default is `false`.
         */
        var includePublic: kotlin.Boolean = false
        /**
         * Set to `true` to include shared manual cluster snapshots from other Amazon Web Services accounts that this Amazon Web Services account has been given permission to copy or restore, and otherwise `false`. The default is `false`.
         */
        var includeShared: kotlin.Boolean = false
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
         */
        var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token (marker) is included in the response so that the remaining results can be retrieved.
         *
         * Default: 100
         *
         * Constraints: Minimum 20, maximum 100.
         */
        var maxRecords: kotlin.Int? = null
        /**
         * The type of cluster snapshots to be returned. You can specify one of the following values:
         * + `automated` - Return all cluster snapshots that Amazon DocumentDB has automatically created for your Amazon Web Services account.
         * + `manual` - Return all cluster snapshots that you have manually created for your Amazon Web Services account.
         * + `shared` - Return all manual cluster snapshots that have been shared to your Amazon Web Services account.
         * + `public` - Return all cluster snapshots that have been marked as public.
         *
         * If you don't specify a `SnapshotType` value, then both automated and manual cluster snapshots are returned. You can include shared cluster snapshots with these results by setting the `IncludeShared` parameter to `true`. You can include public cluster snapshots with these results by setting the`IncludePublic` parameter to `true`.
         *
         * The `IncludeShared` and `IncludePublic` parameters don't apply for `SnapshotType` values of `manual` or `automated`. The `IncludePublic` parameter doesn't apply when `SnapshotType` is set to `shared`. The `IncludeShared` parameter doesn't apply when `SnapshotType` is set to `public`.
         */
        var snapshotType: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdb.model.DescribeDbClusterSnapshotsRequest) : this() {
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterSnapshotIdentifier = x.dbClusterSnapshotIdentifier
            this.filters = x.filters
            this.includePublic = x.includePublic
            this.includeShared = x.includeShared
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.snapshotType = x.snapshotType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdb.model.DescribeDbClusterSnapshotsRequest = DescribeDbClusterSnapshotsRequest(this)
    }
}
