// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.docdb.model.DbInstance
import aws.sdk.kotlin.services.docdb.model.DocDbException
import aws.sdk.kotlin.services.docdb.model.ModifyDbInstanceResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class ModifyDBInstanceOperationDeserializer: HttpDeserialize<ModifyDbInstanceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ModifyDbInstanceResponse {
        if (!response.status.isSuccess()) {
            throwModifyDbInstanceError(context, response)
        }
        val builder = ModifyDbInstanceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyDBInstanceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwModifyDbInstanceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw DocDbException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AuthorizationNotFound" -> AuthorizationNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "CertificateNotFound" -> CertificateNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBInstanceAlreadyExists" -> DbInstanceAlreadyExistsFaultDeserializer().deserialize(context, wrappedResponse)
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBParameterGroupNotFound" -> DbParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBSecurityGroupNotFound" -> DbSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBUpgradeDependencyFailure" -> DbUpgradeDependencyFailureFaultDeserializer().deserialize(context, wrappedResponse)
        "InsufficientDBInstanceCapacity" -> InsufficientDbInstanceCapacityFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBSecurityGroupState" -> InvalidDbSecurityGroupStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedResponse)
        "StorageQuotaExceeded" -> StorageQuotaExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "StorageTypeNotSupported" -> StorageTypeNotSupportedFaultDeserializer().deserialize(context, wrappedResponse)
        else -> DocDbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyDBInstanceOperationBody(builder: ModifyDbInstanceResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ModifyDBInstanceResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ModifyDBInstanceResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ModifyDBInstance response")
    }
    // end unwrap response wrapper

    val DBINSTANCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DBInstance"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://rds.amazonaws.com/doc/2014-10-31/"))
        trait(XmlSerialName("ModifyDBInstanceResult"))
        field(DBINSTANCE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DBINSTANCE_DESCRIPTOR.index -> builder.dbInstance = deserializeDbInstanceDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
