// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodbstreams.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents all of the data describing a particular stream.
 */
class StreamDescription private constructor(builder: Builder) {
    /**
     * The date and time when the request to create this stream was issued.
     */
    val creationRequestDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationRequestDateTime
    /**
     * The key attribute(s) of the stream's DynamoDB table.
     */
    val keySchema: List<KeySchemaElement>? = builder.keySchema
    /**
     * The shard ID of the item where the operation stopped, inclusive of the previous result set. Use this value to start a new operation, excluding this value in the new request.
     *
     * If `LastEvaluatedShardId` is empty, then the "last page" of results has been processed and there is currently no more data to be retrieved.
     *
     * If `LastEvaluatedShardId` is not empty, it does not necessarily mean that there is more data in the result set. The only way to know when you have reached the end of the result set is when `LastEvaluatedShardId` is empty.
     */
    val lastEvaluatedShardId: kotlin.String? = builder.lastEvaluatedShardId
    /**
     * The shards that comprise the stream.
     */
    val shards: List<Shard>? = builder.shards
    /**
     * The Amazon Resource Name (ARN) for the stream.
     */
    val streamArn: kotlin.String? = builder.streamArn
    /**
     * A timestamp, in ISO 8601 format, for this stream.
     *
     * Note that `LatestStreamLabel` is not a unique identifier for the stream, because it is possible that a stream from another table might have the same timestamp. However, the combination of the following three elements is guaranteed to be unique:
     * + the AWS customer ID.
     * + the table name
     * + the `StreamLabel`
     */
    val streamLabel: kotlin.String? = builder.streamLabel
    /**
     * Indicates the current status of the stream:
     * + `ENABLING` - Streams is currently being enabled on the DynamoDB table.
     * + `ENABLED` - the stream is enabled.
     * + `DISABLING` - Streams is currently being disabled on the DynamoDB table.
     * + `DISABLED` - the stream is disabled.
     */
    val streamStatus: aws.sdk.kotlin.services.dynamodbstreams.model.StreamStatus? = builder.streamStatus
    /**
     * Indicates the format of the records within this stream:
     * + `KEYS_ONLY` - only the key attributes of items that were modified in the DynamoDB table.
     * + `NEW_IMAGE` - entire items from the table, as they appeared after they were modified.
     * + `OLD_IMAGE` - entire items from the table, as they appeared before they were modified.
     * + `NEW_AND_OLD_IMAGES` - both the new and the old images of the items from the table.
     */
    val streamViewType: aws.sdk.kotlin.services.dynamodbstreams.model.StreamViewType? = builder.streamViewType
    /**
     * The DynamoDB table with which the stream is associated.
     */
    val tableName: kotlin.String? = builder.tableName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodbstreams.model.StreamDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StreamDescription(")
        append("creationRequestDateTime=$creationRequestDateTime,")
        append("keySchema=$keySchema,")
        append("lastEvaluatedShardId=$lastEvaluatedShardId,")
        append("shards=$shards,")
        append("streamArn=$streamArn,")
        append("streamLabel=$streamLabel,")
        append("streamStatus=$streamStatus,")
        append("streamViewType=$streamViewType,")
        append("tableName=$tableName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationRequestDateTime?.hashCode() ?: 0
        result = 31 * result + (keySchema?.hashCode() ?: 0)
        result = 31 * result + (lastEvaluatedShardId?.hashCode() ?: 0)
        result = 31 * result + (shards?.hashCode() ?: 0)
        result = 31 * result + (streamArn?.hashCode() ?: 0)
        result = 31 * result + (streamLabel?.hashCode() ?: 0)
        result = 31 * result + (streamStatus?.hashCode() ?: 0)
        result = 31 * result + (streamViewType?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StreamDescription

        if (creationRequestDateTime != other.creationRequestDateTime) return false
        if (keySchema != other.keySchema) return false
        if (lastEvaluatedShardId != other.lastEvaluatedShardId) return false
        if (shards != other.shards) return false
        if (streamArn != other.streamArn) return false
        if (streamLabel != other.streamLabel) return false
        if (streamStatus != other.streamStatus) return false
        if (streamViewType != other.streamViewType) return false
        if (tableName != other.tableName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodbstreams.model.StreamDescription = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time when the request to create this stream was issued.
         */
        var creationRequestDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The key attribute(s) of the stream's DynamoDB table.
         */
        var keySchema: List<KeySchemaElement>? = null
        /**
         * The shard ID of the item where the operation stopped, inclusive of the previous result set. Use this value to start a new operation, excluding this value in the new request.
         *
         * If `LastEvaluatedShardId` is empty, then the "last page" of results has been processed and there is currently no more data to be retrieved.
         *
         * If `LastEvaluatedShardId` is not empty, it does not necessarily mean that there is more data in the result set. The only way to know when you have reached the end of the result set is when `LastEvaluatedShardId` is empty.
         */
        var lastEvaluatedShardId: kotlin.String? = null
        /**
         * The shards that comprise the stream.
         */
        var shards: List<Shard>? = null
        /**
         * The Amazon Resource Name (ARN) for the stream.
         */
        var streamArn: kotlin.String? = null
        /**
         * A timestamp, in ISO 8601 format, for this stream.
         *
         * Note that `LatestStreamLabel` is not a unique identifier for the stream, because it is possible that a stream from another table might have the same timestamp. However, the combination of the following three elements is guaranteed to be unique:
         * + the AWS customer ID.
         * + the table name
         * + the `StreamLabel`
         */
        var streamLabel: kotlin.String? = null
        /**
         * Indicates the current status of the stream:
         * + `ENABLING` - Streams is currently being enabled on the DynamoDB table.
         * + `ENABLED` - the stream is enabled.
         * + `DISABLING` - Streams is currently being disabled on the DynamoDB table.
         * + `DISABLED` - the stream is disabled.
         */
        var streamStatus: aws.sdk.kotlin.services.dynamodbstreams.model.StreamStatus? = null
        /**
         * Indicates the format of the records within this stream:
         * + `KEYS_ONLY` - only the key attributes of items that were modified in the DynamoDB table.
         * + `NEW_IMAGE` - entire items from the table, as they appeared after they were modified.
         * + `OLD_IMAGE` - entire items from the table, as they appeared before they were modified.
         * + `NEW_AND_OLD_IMAGES` - both the new and the old images of the items from the table.
         */
        var streamViewType: aws.sdk.kotlin.services.dynamodbstreams.model.StreamViewType? = null
        /**
         * The DynamoDB table with which the stream is associated.
         */
        var tableName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodbstreams.model.StreamDescription) : this() {
            this.creationRequestDateTime = x.creationRequestDateTime
            this.keySchema = x.keySchema
            this.lastEvaluatedShardId = x.lastEvaluatedShardId
            this.shards = x.shards
            this.streamArn = x.streamArn
            this.streamLabel = x.streamLabel
            this.streamStatus = x.streamStatus
            this.streamViewType = x.streamViewType
            this.tableName = x.tableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodbstreams.model.StreamDescription = StreamDescription(this)
    }
}
