// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodbstreams.model



/**
 * Represents the data for an attribute.
 *
 * Each attribute value is described as a name-value pair. The name is the data type, and the value is the data itself.
 *
 * For more information, see [Data Types](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes) in the *Amazon DynamoDB Developer Guide*.
 */
sealed class AttributeValue {
    /**
     * An attribute of type Binary. For example:
     *
     * `"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"`
     */
    data class B(val value: kotlin.ByteArray) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue() {

        override fun hashCode(): kotlin.Int {
            return value.contentHashCode()
        }

        override fun equals(other: kotlin.Any?): kotlin.Boolean {
            if (this === other) return true
            if (other == null || this::class != other::class) return false

            other as B

            if (!value.contentEquals(other.value)) return false

            return true
        }
    }
    /**
     * An attribute of type Boolean. For example:
     *
     * `"BOOL": true`
     */
    data class Bool(val value: kotlin.Boolean) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()
    /**
     * An attribute of type Binary Set. For example:
     *
     * `"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]`
     */
    data class Bs(val value: List<ByteArray>) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()
    /**
     * An attribute of type List. For example:
     *
     * `"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N": "3.14159"}]`
     */
    data class L(val value: List<AttributeValue>) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()
    /**
     * An attribute of type Map. For example:
     *
     * `"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}`
     */
    data class M(val value: Map<String, AttributeValue>) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()
    /**
     * An attribute of type Number. For example:
     *
     * `"N": "123.45"`
     *
     * Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
     */
    data class N(val value: kotlin.String) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()
    /**
     * An attribute of type Number Set. For example:
     *
     * `"NS": ["42.2", "-19", "7.5", "3.14"]`
     *
     * Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
     */
    data class Ns(val value: List<String>) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()
    /**
     * An attribute of type Null. For example:
     *
     * `"NULL": true`
     */
    data class Null(val value: kotlin.Boolean) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()
    /**
     * An attribute of type String. For example:
     *
     * `"S": "Hello"`
     */
    data class S(val value: kotlin.String) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()
    /**
     * An attribute of type String Set. For example:
     *
     * `"SS": ["Giraffe", "Hippo" ,"Zebra"]`
     */
    data class Ss(val value: List<String>) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()
    object SdkUnknown : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()

    /**
     * Casts this [AttributeValue] as a [B] and retrieves its [kotlin.ByteArray] value. Throws an exception if the [AttributeValue] is not a
     * [B].
     */
    fun asB(): kotlin.ByteArray = (this as AttributeValue.B).value

    /**
     * Casts this [AttributeValue] as a [B] and retrieves its [kotlin.ByteArray] value. Returns null if the [AttributeValue] is not a [B].
     */
    fun asBOrNull(): kotlin.ByteArray? = (this as? AttributeValue.B)?.value

    /**
     * Casts this [AttributeValue] as a [Bool] and retrieves its [kotlin.Boolean] value. Throws an exception if the [AttributeValue] is not a
     * [Bool].
     */
    fun asBool(): kotlin.Boolean = (this as AttributeValue.Bool).value

    /**
     * Casts this [AttributeValue] as a [Bool] and retrieves its [kotlin.Boolean] value. Returns null if the [AttributeValue] is not a [Bool].
     */
    fun asBoolOrNull(): kotlin.Boolean? = (this as? AttributeValue.Bool)?.value

    /**
     * Casts this [AttributeValue] as a [Bs] and retrieves its [List<ByteArray>] value. Throws an exception if the [AttributeValue] is not a
     * [Bs].
     */
    fun asBs(): List<ByteArray> = (this as AttributeValue.Bs).value

    /**
     * Casts this [AttributeValue] as a [Bs] and retrieves its [List<ByteArray>] value. Returns null if the [AttributeValue] is not a [Bs].
     */
    fun asBsOrNull(): List<ByteArray>? = (this as? AttributeValue.Bs)?.value

    /**
     * Casts this [AttributeValue] as a [L] and retrieves its [List<AttributeValue>] value. Throws an exception if the [AttributeValue] is not a
     * [L].
     */
    fun asL(): List<AttributeValue> = (this as AttributeValue.L).value

    /**
     * Casts this [AttributeValue] as a [L] and retrieves its [List<AttributeValue>] value. Returns null if the [AttributeValue] is not a [L].
     */
    fun asLOrNull(): List<AttributeValue>? = (this as? AttributeValue.L)?.value

    /**
     * Casts this [AttributeValue] as a [M] and retrieves its [Map<String, AttributeValue>] value. Throws an exception if the [AttributeValue] is not a
     * [M].
     */
    fun asM(): Map<String, AttributeValue> = (this as AttributeValue.M).value

    /**
     * Casts this [AttributeValue] as a [M] and retrieves its [Map<String, AttributeValue>] value. Returns null if the [AttributeValue] is not a [M].
     */
    fun asMOrNull(): Map<String, AttributeValue>? = (this as? AttributeValue.M)?.value

    /**
     * Casts this [AttributeValue] as a [N] and retrieves its [kotlin.String] value. Throws an exception if the [AttributeValue] is not a
     * [N].
     */
    fun asN(): kotlin.String = (this as AttributeValue.N).value

    /**
     * Casts this [AttributeValue] as a [N] and retrieves its [kotlin.String] value. Returns null if the [AttributeValue] is not a [N].
     */
    fun asNOrNull(): kotlin.String? = (this as? AttributeValue.N)?.value

    /**
     * Casts this [AttributeValue] as a [Ns] and retrieves its [List<String>] value. Throws an exception if the [AttributeValue] is not a
     * [Ns].
     */
    fun asNs(): List<String> = (this as AttributeValue.Ns).value

    /**
     * Casts this [AttributeValue] as a [Ns] and retrieves its [List<String>] value. Returns null if the [AttributeValue] is not a [Ns].
     */
    fun asNsOrNull(): List<String>? = (this as? AttributeValue.Ns)?.value

    /**
     * Casts this [AttributeValue] as a [Null] and retrieves its [kotlin.Boolean] value. Throws an exception if the [AttributeValue] is not a
     * [Null].
     */
    fun asNull(): kotlin.Boolean = (this as AttributeValue.Null).value

    /**
     * Casts this [AttributeValue] as a [Null] and retrieves its [kotlin.Boolean] value. Returns null if the [AttributeValue] is not a [Null].
     */
    fun asNullOrNull(): kotlin.Boolean? = (this as? AttributeValue.Null)?.value

    /**
     * Casts this [AttributeValue] as a [S] and retrieves its [kotlin.String] value. Throws an exception if the [AttributeValue] is not a
     * [S].
     */
    fun asS(): kotlin.String = (this as AttributeValue.S).value

    /**
     * Casts this [AttributeValue] as a [S] and retrieves its [kotlin.String] value. Returns null if the [AttributeValue] is not a [S].
     */
    fun asSOrNull(): kotlin.String? = (this as? AttributeValue.S)?.value

    /**
     * Casts this [AttributeValue] as a [Ss] and retrieves its [List<String>] value. Throws an exception if the [AttributeValue] is not a
     * [Ss].
     */
    fun asSs(): List<String> = (this as AttributeValue.Ss).value

    /**
     * Casts this [AttributeValue] as a [Ss] and retrieves its [List<String>] value. Returns null if the [AttributeValue] is not a [Ss].
     */
    fun asSsOrNull(): List<String>? = (this as? AttributeValue.Ss)?.value
}

/**
 * Casts this [AttributeValue] as a [B] and retrieves its [kotlin.ByteArray] value.
 */
val AttributeValue.B get() = (this as AttributeValue.B).value

/**
 * Casts this [AttributeValue] as a [Bool] and retrieves its [kotlin.Boolean] value.
 */
val AttributeValue.Bool get() = (this as AttributeValue.Bool).value

/**
 * Casts this [AttributeValue] as a [Bs] and retrieves its [List<ByteArray>] value.
 */
val AttributeValue.Bs get() = (this as AttributeValue.Bs).value

/**
 * Casts this [AttributeValue] as a [L] and retrieves its [List<AttributeValue>] value.
 */
val AttributeValue.L get() = (this as AttributeValue.L).value

/**
 * Casts this [AttributeValue] as a [M] and retrieves its [Map<String, AttributeValue>] value.
 */
val AttributeValue.M get() = (this as AttributeValue.M).value

/**
 * Casts this [AttributeValue] as a [N] and retrieves its [kotlin.String] value.
 */
val AttributeValue.N get() = (this as AttributeValue.N).value

/**
 * Casts this [AttributeValue] as a [Ns] and retrieves its [List<String>] value.
 */
val AttributeValue.Ns get() = (this as AttributeValue.Ns).value

/**
 * Casts this [AttributeValue] as a [Null] and retrieves its [kotlin.Boolean] value.
 */
val AttributeValue.Null get() = (this as AttributeValue.Null).value

/**
 * Casts this [AttributeValue] as a [S] and retrieves its [kotlin.String] value.
 */
val AttributeValue.S get() = (this as AttributeValue.S).value

/**
 * Casts this [AttributeValue] as a [Ss] and retrieves its [List<String>] value.
 */
val AttributeValue.Ss get() = (this as AttributeValue.Ss).value
