// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodbstreams.model



/**
 * Represents all of the data describing a particular stream.
 */
class Stream private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the stream.
     */
    val streamArn: kotlin.String? = builder.streamArn
    /**
     * A timestamp, in ISO 8601 format, for this stream.
     *
     * Note that `LatestStreamLabel` is not a unique identifier for the stream, because it is possible that a stream from another table might have the same timestamp. However, the combination of the following three elements is guaranteed to be unique:
     * + the AWS customer ID.
     * + the table name
     * + the `StreamLabel`
     */
    val streamLabel: kotlin.String? = builder.streamLabel
    /**
     * The DynamoDB table with which the stream is associated.
     */
    val tableName: kotlin.String? = builder.tableName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodbstreams.model.Stream = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Stream(")
        append("streamArn=$streamArn,")
        append("streamLabel=$streamLabel,")
        append("tableName=$tableName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = streamArn?.hashCode() ?: 0
        result = 31 * result + (streamLabel?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Stream

        if (streamArn != other.streamArn) return false
        if (streamLabel != other.streamLabel) return false
        if (tableName != other.tableName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodbstreams.model.Stream = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) for the stream.
         */
        var streamArn: kotlin.String? = null
        /**
         * A timestamp, in ISO 8601 format, for this stream.
         *
         * Note that `LatestStreamLabel` is not a unique identifier for the stream, because it is possible that a stream from another table might have the same timestamp. However, the combination of the following three elements is guaranteed to be unique:
         * + the AWS customer ID.
         * + the table name
         * + the `StreamLabel`
         */
        var streamLabel: kotlin.String? = null
        /**
         * The DynamoDB table with which the stream is associated.
         */
        var tableName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodbstreams.model.Stream) : this() {
            this.streamArn = x.streamArn
            this.streamLabel = x.streamLabel
            this.tableName = x.tableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodbstreams.model.Stream = Stream(this)
    }
}
