// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details on the Elastic IP address transfer. For more information, see [Transfer Elastic IP addresses](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#transfer-EIPs-intro) in the *Amazon Virtual Private Cloud User Guide*.
 */
public class AddressTransfer private constructor(builder: Builder) {
    /**
     * The Elastic IP address transfer status.
     */
    public val addressTransferStatus: aws.sdk.kotlin.services.ec2.model.AddressTransferStatus? = builder.addressTransferStatus
    /**
     * The allocation ID of an Elastic IP address.
     */
    public val allocationId: kotlin.String? = builder.allocationId
    /**
     * The Elastic IP address being transferred.
     */
    public val publicIp: kotlin.String? = builder.publicIp
    /**
     * The ID of the account that you want to transfer the Elastic IP address to.
     */
    public val transferAccountId: kotlin.String? = builder.transferAccountId
    /**
     * The timestamp when the Elastic IP address transfer was accepted.
     */
    public val transferOfferAcceptedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.transferOfferAcceptedTimestamp
    /**
     * The timestamp when the Elastic IP address transfer expired. When the source account starts the transfer, the transfer account has seven hours to allocate the Elastic IP address to complete the transfer, or the Elastic IP address will return to its original owner.
     */
    public val transferOfferExpirationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.transferOfferExpirationTimestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.AddressTransfer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AddressTransfer(")
        append("addressTransferStatus=$addressTransferStatus,")
        append("allocationId=$allocationId,")
        append("publicIp=$publicIp,")
        append("transferAccountId=$transferAccountId,")
        append("transferOfferAcceptedTimestamp=$transferOfferAcceptedTimestamp,")
        append("transferOfferExpirationTimestamp=$transferOfferExpirationTimestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressTransferStatus?.hashCode() ?: 0
        result = 31 * result + (allocationId?.hashCode() ?: 0)
        result = 31 * result + (publicIp?.hashCode() ?: 0)
        result = 31 * result + (transferAccountId?.hashCode() ?: 0)
        result = 31 * result + (transferOfferAcceptedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (transferOfferExpirationTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AddressTransfer

        if (addressTransferStatus != other.addressTransferStatus) return false
        if (allocationId != other.allocationId) return false
        if (publicIp != other.publicIp) return false
        if (transferAccountId != other.transferAccountId) return false
        if (transferOfferAcceptedTimestamp != other.transferOfferAcceptedTimestamp) return false
        if (transferOfferExpirationTimestamp != other.transferOfferExpirationTimestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.AddressTransfer = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Elastic IP address transfer status.
         */
        public var addressTransferStatus: aws.sdk.kotlin.services.ec2.model.AddressTransferStatus? = null
        /**
         * The allocation ID of an Elastic IP address.
         */
        public var allocationId: kotlin.String? = null
        /**
         * The Elastic IP address being transferred.
         */
        public var publicIp: kotlin.String? = null
        /**
         * The ID of the account that you want to transfer the Elastic IP address to.
         */
        public var transferAccountId: kotlin.String? = null
        /**
         * The timestamp when the Elastic IP address transfer was accepted.
         */
        public var transferOfferAcceptedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp when the Elastic IP address transfer expired. When the source account starts the transfer, the transfer account has seven hours to allocate the Elastic IP address to complete the transfer, or the Elastic IP address will return to its original owner.
         */
        public var transferOfferExpirationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.AddressTransfer) : this() {
            this.addressTransferStatus = x.addressTransferStatus
            this.allocationId = x.allocationId
            this.publicIp = x.publicIp
            this.transferAccountId = x.transferAccountId
            this.transferOfferAcceptedTimestamp = x.transferOfferAcceptedTimestamp
            this.transferOfferExpirationTimestamp = x.transferOfferExpirationTimestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.AddressTransfer = AddressTransfer(this)
    }
}
