// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



public class AssociateVpcCidrBlockRequest private constructor(builder: Builder) {
    /**
     * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IPv6 addresses, or the size of the CIDR block.
     */
    public val amazonProvidedIpv6CidrBlock: kotlin.Boolean? = builder.amazonProvidedIpv6CidrBlock
    /**
     * An IPv4 CIDR block to associate with the VPC.
     */
    public val cidrBlock: kotlin.String? = builder.cidrBlock
    /**
     * Associate a CIDR allocated from an IPv4 IPAM pool to a VPC. For more information about Amazon VPC IP Address Manager (IPAM), see [What is IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html) in the *Amazon VPC IPAM User Guide*.
     */
    public val ipv4IpamPoolId: kotlin.String? = builder.ipv4IpamPoolId
    /**
     * The netmask length of the IPv4 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see [What is IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html) in the *Amazon VPC IPAM User Guide*.
     */
    public val ipv4NetmaskLength: kotlin.Int? = builder.ipv4NetmaskLength
    /**
     * An IPv6 CIDR block from the IPv6 address pool. You must also specify `Ipv6Pool` in the request.
     *
     * To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
     */
    public val ipv6CidrBlock: kotlin.String? = builder.ipv6CidrBlock
    /**
     * The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the CIDR block to this location.
     *
     *  You must set `AmazonProvidedIpv6CidrBlock` to `true` to use this parameter.
     *
     *  You can have one IPv6 CIDR block association per network border group.
     */
    public val ipv6CidrBlockNetworkBorderGroup: kotlin.String? = builder.ipv6CidrBlockNetworkBorderGroup
    /**
     * Associates a CIDR allocated from an IPv6 IPAM pool to a VPC. For more information about Amazon VPC IP Address Manager (IPAM), see [What is IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html) in the *Amazon VPC IPAM User Guide*.
     */
    public val ipv6IpamPoolId: kotlin.String? = builder.ipv6IpamPoolId
    /**
     * The netmask length of the IPv6 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see [What is IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html) in the *Amazon VPC IPAM User Guide*.
     */
    public val ipv6NetmaskLength: kotlin.Int? = builder.ipv6NetmaskLength
    /**
     * The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
     */
    public val ipv6Pool: kotlin.String? = builder.ipv6Pool
    /**
     * The ID of the VPC.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.AssociateVpcCidrBlockRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssociateVpcCidrBlockRequest(")
        append("amazonProvidedIpv6CidrBlock=$amazonProvidedIpv6CidrBlock,")
        append("cidrBlock=$cidrBlock,")
        append("ipv4IpamPoolId=$ipv4IpamPoolId,")
        append("ipv4NetmaskLength=$ipv4NetmaskLength,")
        append("ipv6CidrBlock=$ipv6CidrBlock,")
        append("ipv6CidrBlockNetworkBorderGroup=$ipv6CidrBlockNetworkBorderGroup,")
        append("ipv6IpamPoolId=$ipv6IpamPoolId,")
        append("ipv6NetmaskLength=$ipv6NetmaskLength,")
        append("ipv6Pool=$ipv6Pool,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amazonProvidedIpv6CidrBlock?.hashCode() ?: 0
        result = 31 * result + (cidrBlock?.hashCode() ?: 0)
        result = 31 * result + (ipv4IpamPoolId?.hashCode() ?: 0)
        result = 31 * result + (ipv4NetmaskLength ?: 0)
        result = 31 * result + (ipv6CidrBlock?.hashCode() ?: 0)
        result = 31 * result + (ipv6CidrBlockNetworkBorderGroup?.hashCode() ?: 0)
        result = 31 * result + (ipv6IpamPoolId?.hashCode() ?: 0)
        result = 31 * result + (ipv6NetmaskLength ?: 0)
        result = 31 * result + (ipv6Pool?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssociateVpcCidrBlockRequest

        if (amazonProvidedIpv6CidrBlock != other.amazonProvidedIpv6CidrBlock) return false
        if (cidrBlock != other.cidrBlock) return false
        if (ipv4IpamPoolId != other.ipv4IpamPoolId) return false
        if (ipv4NetmaskLength != other.ipv4NetmaskLength) return false
        if (ipv6CidrBlock != other.ipv6CidrBlock) return false
        if (ipv6CidrBlockNetworkBorderGroup != other.ipv6CidrBlockNetworkBorderGroup) return false
        if (ipv6IpamPoolId != other.ipv6IpamPoolId) return false
        if (ipv6NetmaskLength != other.ipv6NetmaskLength) return false
        if (ipv6Pool != other.ipv6Pool) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.AssociateVpcCidrBlockRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IPv6 addresses, or the size of the CIDR block.
         */
        public var amazonProvidedIpv6CidrBlock: kotlin.Boolean? = null
        /**
         * An IPv4 CIDR block to associate with the VPC.
         */
        public var cidrBlock: kotlin.String? = null
        /**
         * Associate a CIDR allocated from an IPv4 IPAM pool to a VPC. For more information about Amazon VPC IP Address Manager (IPAM), see [What is IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html) in the *Amazon VPC IPAM User Guide*.
         */
        public var ipv4IpamPoolId: kotlin.String? = null
        /**
         * The netmask length of the IPv4 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see [What is IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html) in the *Amazon VPC IPAM User Guide*.
         */
        public var ipv4NetmaskLength: kotlin.Int? = null
        /**
         * An IPv6 CIDR block from the IPv6 address pool. You must also specify `Ipv6Pool` in the request.
         *
         * To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
         */
        public var ipv6CidrBlock: kotlin.String? = null
        /**
         * The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the CIDR block to this location.
         *
         *  You must set `AmazonProvidedIpv6CidrBlock` to `true` to use this parameter.
         *
         *  You can have one IPv6 CIDR block association per network border group.
         */
        public var ipv6CidrBlockNetworkBorderGroup: kotlin.String? = null
        /**
         * Associates a CIDR allocated from an IPv6 IPAM pool to a VPC. For more information about Amazon VPC IP Address Manager (IPAM), see [What is IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html) in the *Amazon VPC IPAM User Guide*.
         */
        public var ipv6IpamPoolId: kotlin.String? = null
        /**
         * The netmask length of the IPv6 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see [What is IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html) in the *Amazon VPC IPAM User Guide*.
         */
        public var ipv6NetmaskLength: kotlin.Int? = null
        /**
         * The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
         */
        public var ipv6Pool: kotlin.String? = null
        /**
         * The ID of the VPC.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.AssociateVpcCidrBlockRequest) : this() {
            this.amazonProvidedIpv6CidrBlock = x.amazonProvidedIpv6CidrBlock
            this.cidrBlock = x.cidrBlock
            this.ipv4IpamPoolId = x.ipv4IpamPoolId
            this.ipv4NetmaskLength = x.ipv4NetmaskLength
            this.ipv6CidrBlock = x.ipv6CidrBlock
            this.ipv6CidrBlockNetworkBorderGroup = x.ipv6CidrBlockNetworkBorderGroup
            this.ipv6IpamPoolId = x.ipv6IpamPoolId
            this.ipv6NetmaskLength = x.ipv6NetmaskLength
            this.ipv6Pool = x.ipv6Pool
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.AssociateVpcCidrBlockRequest = AssociateVpcCidrBlockRequest(this)
    }
}
