// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the instance's Capacity Reservation targeting preferences. The action returns the `capacityReservationPreference` response element if the instance is configured to run in On-Demand capacity, or if it is configured in run in any `open` Capacity Reservation that has matching attributes (instance type, platform, Availability Zone). The action returns the `capacityReservationTarget` response element if the instance explicily targets a specific Capacity Reservation or Capacity Reservation group.
 */
public class CapacityReservationSpecificationResponse private constructor(builder: Builder) {
    /**
     * Describes the instance's Capacity Reservation preferences. Possible preferences include:
     * + `open` - The instance can run in any `open` Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).
     * + `none` - The instance avoids running in a Capacity Reservation even if one is available. The instance runs in On-Demand capacity.
     */
    public val capacityReservationPreference: aws.sdk.kotlin.services.ec2.model.CapacityReservationPreference? = builder.capacityReservationPreference
    /**
     * Information about the targeted Capacity Reservation or Capacity Reservation group.
     */
    public val capacityReservationTarget: aws.sdk.kotlin.services.ec2.model.CapacityReservationTargetResponse? = builder.capacityReservationTarget

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CapacityReservationSpecificationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CapacityReservationSpecificationResponse(")
        append("capacityReservationPreference=$capacityReservationPreference,")
        append("capacityReservationTarget=$capacityReservationTarget)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityReservationPreference?.hashCode() ?: 0
        result = 31 * result + (capacityReservationTarget?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CapacityReservationSpecificationResponse

        if (capacityReservationPreference != other.capacityReservationPreference) return false
        if (capacityReservationTarget != other.capacityReservationTarget) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CapacityReservationSpecificationResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes the instance's Capacity Reservation preferences. Possible preferences include:
         * + `open` - The instance can run in any `open` Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).
         * + `none` - The instance avoids running in a Capacity Reservation even if one is available. The instance runs in On-Demand capacity.
         */
        public var capacityReservationPreference: aws.sdk.kotlin.services.ec2.model.CapacityReservationPreference? = null
        /**
         * Information about the targeted Capacity Reservation or Capacity Reservation group.
         */
        public var capacityReservationTarget: aws.sdk.kotlin.services.ec2.model.CapacityReservationTargetResponse? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CapacityReservationSpecificationResponse) : this() {
            this.capacityReservationPreference = x.capacityReservationPreference
            this.capacityReservationTarget = x.capacityReservationTarget
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CapacityReservationSpecificationResponse = CapacityReservationSpecificationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.CapacityReservationTargetResponse] inside the given [block]
         */
        public fun capacityReservationTarget(block: aws.sdk.kotlin.services.ec2.model.CapacityReservationTargetResponse.Builder.() -> kotlin.Unit) {
            this.capacityReservationTarget = aws.sdk.kotlin.services.ec2.model.CapacityReservationTargetResponse.invoke(block)
        }
    }
}
