// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Information about a Client VPN endpoint route.
 */
public class ClientVpnRoute private constructor(builder: Builder) {
    /**
     * The ID of the Client VPN endpoint with which the route is associated.
     */
    public val clientVpnEndpointId: kotlin.String? = builder.clientVpnEndpointId
    /**
     * A brief description of the route.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The IPv4 address range, in CIDR notation, of the route destination.
     */
    public val destinationCidr: kotlin.String? = builder.destinationCidr
    /**
     * Indicates how the route was associated with the Client VPN endpoint. `associate` indicates that the route was automatically added when the target network was associated with the Client VPN endpoint. `add-route` indicates that the route was manually added using the **CreateClientVpnRoute** action.
     */
    public val origin: kotlin.String? = builder.origin
    /**
     * The current state of the route.
     */
    public val status: aws.sdk.kotlin.services.ec2.model.ClientVpnRouteStatus? = builder.status
    /**
     * The ID of the subnet through which traffic is routed.
     */
    public val targetSubnet: kotlin.String? = builder.targetSubnet
    /**
     * The route type.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.ClientVpnRoute = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClientVpnRoute(")
        append("clientVpnEndpointId=$clientVpnEndpointId,")
        append("description=$description,")
        append("destinationCidr=$destinationCidr,")
        append("origin=$origin,")
        append("status=$status,")
        append("targetSubnet=$targetSubnet,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientVpnEndpointId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destinationCidr?.hashCode() ?: 0)
        result = 31 * result + (origin?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetSubnet?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClientVpnRoute

        if (clientVpnEndpointId != other.clientVpnEndpointId) return false
        if (description != other.description) return false
        if (destinationCidr != other.destinationCidr) return false
        if (origin != other.origin) return false
        if (status != other.status) return false
        if (targetSubnet != other.targetSubnet) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.ClientVpnRoute = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Client VPN endpoint with which the route is associated.
         */
        public var clientVpnEndpointId: kotlin.String? = null
        /**
         * A brief description of the route.
         */
        public var description: kotlin.String? = null
        /**
         * The IPv4 address range, in CIDR notation, of the route destination.
         */
        public var destinationCidr: kotlin.String? = null
        /**
         * Indicates how the route was associated with the Client VPN endpoint. `associate` indicates that the route was automatically added when the target network was associated with the Client VPN endpoint. `add-route` indicates that the route was manually added using the **CreateClientVpnRoute** action.
         */
        public var origin: kotlin.String? = null
        /**
         * The current state of the route.
         */
        public var status: aws.sdk.kotlin.services.ec2.model.ClientVpnRouteStatus? = null
        /**
         * The ID of the subnet through which traffic is routed.
         */
        public var targetSubnet: kotlin.String? = null
        /**
         * The route type.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.ClientVpnRoute) : this() {
            this.clientVpnEndpointId = x.clientVpnEndpointId
            this.description = x.description
            this.destinationCidr = x.destinationCidr
            this.origin = x.origin
            this.status = x.status
            this.targetSubnet = x.targetSubnet
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.ClientVpnRoute = ClientVpnRoute(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ClientVpnRouteStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.ec2.model.ClientVpnRouteStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.ec2.model.ClientVpnRouteStatus.invoke(block)
        }
    }
}
