// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for CopyImage.
 */
public class CopyImageRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * A description for the new AMI in the destination Region.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI. Only specify this parameter when copying an AMI from an Amazon Web Services Region to an Outpost. The AMI must be in the Region of the destination Outpost. You cannot copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost.
     *
     * For more information, see [ Copying AMIs from an Amazon Web Services Region to an Outpost](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-amis) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public val destinationOutpostArn: kotlin.String? = builder.destinationOutpostArn
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * Specifies whether the destination snapshots of the copied image should be encrypted. You can encrypt a copy of an unencrypted snapshot, but you cannot create an unencrypted copy of an encrypted snapshot. The default KMS key for Amazon EBS is used unless you specify a non-default Key Management Service (KMS) KMS key using `KmsKeyId`. For more information, see [Amazon EBS Encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * The identifier of the symmetric Key Management Service (KMS) KMS key to use when creating encrypted volumes. If this parameter is not specified, your Amazon Web Services managed KMS key for Amazon EBS is used. If you specify a KMS key, you must also set the encrypted state to `true`.
     *
     * You can specify a KMS key using any of the following:
     * + Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
     * + Key alias. For example, alias/ExampleAlias.
     * + Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
     * + Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
     *
     * Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an identifier that is not valid, the action can appear to complete, but eventually fails.
     *
     * The specified KMS key must exist in the destination Region.
     *
     * Amazon EBS does not support asymmetric KMS keys.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the new AMI in the destination Region.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ID of the AMI to copy.
     */
    public val sourceImageId: kotlin.String? = builder.sourceImageId
    /**
     * The name of the Region that contains the AMI to copy.
     */
    public val sourceRegion: kotlin.String? = builder.sourceRegion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CopyImageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyImageRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("destinationOutpostArn=$destinationOutpostArn,")
        append("dryRun=$dryRun,")
        append("encrypted=$encrypted,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("sourceImageId=$sourceImageId,")
        append("sourceRegion=$sourceRegion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destinationOutpostArn?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (sourceImageId?.hashCode() ?: 0)
        result = 31 * result + (sourceRegion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyImageRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (destinationOutpostArn != other.destinationOutpostArn) return false
        if (dryRun != other.dryRun) return false
        if (encrypted != other.encrypted) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (sourceImageId != other.sourceImageId) return false
        if (sourceRegion != other.sourceRegion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CopyImageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
         */
        public var clientToken: kotlin.String? = null
        /**
         * A description for the new AMI in the destination Region.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI. Only specify this parameter when copying an AMI from an Amazon Web Services Region to an Outpost. The AMI must be in the Region of the destination Outpost. You cannot copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost.
         *
         * For more information, see [ Copying AMIs from an Amazon Web Services Region to an Outpost](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-amis) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        public var destinationOutpostArn: kotlin.String? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * Specifies whether the destination snapshots of the copied image should be encrypted. You can encrypt a copy of an unencrypted snapshot, but you cannot create an unencrypted copy of an encrypted snapshot. The default KMS key for Amazon EBS is used unless you specify a non-default Key Management Service (KMS) KMS key using `KmsKeyId`. For more information, see [Amazon EBS Encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        public var encrypted: kotlin.Boolean? = null
        /**
         * The identifier of the symmetric Key Management Service (KMS) KMS key to use when creating encrypted volumes. If this parameter is not specified, your Amazon Web Services managed KMS key for Amazon EBS is used. If you specify a KMS key, you must also set the encrypted state to `true`.
         *
         * You can specify a KMS key using any of the following:
         * + Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
         * + Key alias. For example, alias/ExampleAlias.
         * + Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
         * + Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
         *
         * Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an identifier that is not valid, the action can appear to complete, but eventually fails.
         *
         * The specified KMS key must exist in the destination Region.
         *
         * Amazon EBS does not support asymmetric KMS keys.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the new AMI in the destination Region.
         */
        public var name: kotlin.String? = null
        /**
         * The ID of the AMI to copy.
         */
        public var sourceImageId: kotlin.String? = null
        /**
         * The name of the Region that contains the AMI to copy.
         */
        public var sourceRegion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CopyImageRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.destinationOutpostArn = x.destinationOutpostArn
            this.dryRun = x.dryRun
            this.encrypted = x.encrypted
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.sourceImageId = x.sourceImageId
            this.sourceRegion = x.sourceRegion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CopyImageRequest = CopyImageRequest(this)
    }
}
