// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



public class CreateFlowLogsRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [How to ensure idempotency](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The ARN of the IAM role that allows Amazon EC2 to publish flow logs across accounts.
     */
    public val deliverCrossAccountRole: kotlin.String? = builder.deliverCrossAccountRole
    /**
     * The ARN of the IAM role that allows Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.
     *
     * This parameter is required if the destination type is `cloud-watch-logs` and unsupported otherwise.
     */
    public val deliverLogsPermissionArn: kotlin.String? = builder.deliverLogsPermissionArn
    /**
     * The destination options.
     */
    public val destinationOptions: aws.sdk.kotlin.services.ec2.model.DestinationOptionsRequest? = builder.destinationOptions
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The destination for the flow log data. The meaning of this parameter depends on the destination type.
     * + If the destination type is `cloud-watch-logs`, specify the ARN of a CloudWatch Logs log group. For example:arn:aws:logs:*region*:*account_id*:log-group:*my_group*Alternatively, use the `LogGroupName` parameter.
     * + If the destination type is `s3`, specify the ARN of an S3 bucket. For example:arn:aws:s3:::*my_bucket*&#47;*my_subfolder*&#47;The subfolder is optional. Note that you can't use `AWSLogs` as a subfolder name.
     * + If the destination type is `kinesis-data-firehose`, specify the ARN of a Kinesis Data Firehose delivery stream. For example:arn:aws:firehose:*region*:*account_id*:deliverystream:*my_stream*
     */
    public val logDestination: kotlin.String? = builder.logDestination
    /**
     * The type of destination for the flow log data.
     *
     * Default: `cloud-watch-logs`
     */
    public val logDestinationType: aws.sdk.kotlin.services.ec2.model.LogDestinationType? = builder.logDestinationType
    /**
     * The fields to include in the flow log record. List the fields in the order in which they should appear. For more information about the available fields, see [Flow log records](https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records). If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must include at least one field.
     *
     * Specify the fields using the `${field-id}` format, separated by spaces. For the CLI, surround this parameter value with single quotes on Linux or double quotes on Windows.
     */
    public val logFormat: kotlin.String? = builder.logFormat
    /**
     * The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.
     *
     * This parameter is valid only if the destination type is `cloud-watch-logs`.
     */
    public val logGroupName: kotlin.String? = builder.logGroupName
    /**
     * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).
     *
     * When a network interface is attached to a [Nitro-based instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances), the aggregation interval is always 60 seconds or less, regardless of the value that you specify.
     *
     * Default: 600
     */
    public val maxAggregationInterval: kotlin.Int? = builder.maxAggregationInterval
    /**
     * The IDs of the resources to monitor. For example, if the resource type is `VPC`, specify the IDs of the VPCs.
     *
     * Constraints: Maximum of 1000 resources
     */
    public val resourceIds: List<String>? = builder.resourceIds
    /**
     * The type of resource to monitor.
     */
    public val resourceType: aws.sdk.kotlin.services.ec2.model.FlowLogsResourceType? = builder.resourceType
    /**
     * The tags to apply to the flow logs.
     */
    public val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The type of traffic to monitor (accepted traffic, rejected traffic, or all traffic).
     */
    public val trafficType: aws.sdk.kotlin.services.ec2.model.TrafficType? = builder.trafficType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CreateFlowLogsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFlowLogsRequest(")
        append("clientToken=$clientToken,")
        append("deliverCrossAccountRole=$deliverCrossAccountRole,")
        append("deliverLogsPermissionArn=$deliverLogsPermissionArn,")
        append("destinationOptions=$destinationOptions,")
        append("dryRun=$dryRun,")
        append("logDestination=$logDestination,")
        append("logDestinationType=$logDestinationType,")
        append("logFormat=$logFormat,")
        append("logGroupName=$logGroupName,")
        append("maxAggregationInterval=$maxAggregationInterval,")
        append("resourceIds=$resourceIds,")
        append("resourceType=$resourceType,")
        append("tagSpecifications=$tagSpecifications,")
        append("trafficType=$trafficType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (deliverCrossAccountRole?.hashCode() ?: 0)
        result = 31 * result + (deliverLogsPermissionArn?.hashCode() ?: 0)
        result = 31 * result + (destinationOptions?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (logDestination?.hashCode() ?: 0)
        result = 31 * result + (logDestinationType?.hashCode() ?: 0)
        result = 31 * result + (logFormat?.hashCode() ?: 0)
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (maxAggregationInterval ?: 0)
        result = 31 * result + (resourceIds?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (trafficType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFlowLogsRequest

        if (clientToken != other.clientToken) return false
        if (deliverCrossAccountRole != other.deliverCrossAccountRole) return false
        if (deliverLogsPermissionArn != other.deliverLogsPermissionArn) return false
        if (destinationOptions != other.destinationOptions) return false
        if (dryRun != other.dryRun) return false
        if (logDestination != other.logDestination) return false
        if (logDestinationType != other.logDestinationType) return false
        if (logFormat != other.logFormat) return false
        if (logGroupName != other.logGroupName) return false
        if (maxAggregationInterval != other.maxAggregationInterval) return false
        if (resourceIds != other.resourceIds) return false
        if (resourceType != other.resourceType) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (trafficType != other.trafficType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CreateFlowLogsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [How to ensure idempotency](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
         */
        public var clientToken: kotlin.String? = null
        /**
         * The ARN of the IAM role that allows Amazon EC2 to publish flow logs across accounts.
         */
        public var deliverCrossAccountRole: kotlin.String? = null
        /**
         * The ARN of the IAM role that allows Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.
         *
         * This parameter is required if the destination type is `cloud-watch-logs` and unsupported otherwise.
         */
        public var deliverLogsPermissionArn: kotlin.String? = null
        /**
         * The destination options.
         */
        public var destinationOptions: aws.sdk.kotlin.services.ec2.model.DestinationOptionsRequest? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * The destination for the flow log data. The meaning of this parameter depends on the destination type.
         * + If the destination type is `cloud-watch-logs`, specify the ARN of a CloudWatch Logs log group. For example:arn:aws:logs:*region*:*account_id*:log-group:*my_group*Alternatively, use the `LogGroupName` parameter.
         * + If the destination type is `s3`, specify the ARN of an S3 bucket. For example:arn:aws:s3:::*my_bucket*&#47;*my_subfolder*&#47;The subfolder is optional. Note that you can't use `AWSLogs` as a subfolder name.
         * + If the destination type is `kinesis-data-firehose`, specify the ARN of a Kinesis Data Firehose delivery stream. For example:arn:aws:firehose:*region*:*account_id*:deliverystream:*my_stream*
         */
        public var logDestination: kotlin.String? = null
        /**
         * The type of destination for the flow log data.
         *
         * Default: `cloud-watch-logs`
         */
        public var logDestinationType: aws.sdk.kotlin.services.ec2.model.LogDestinationType? = null
        /**
         * The fields to include in the flow log record. List the fields in the order in which they should appear. For more information about the available fields, see [Flow log records](https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records). If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must include at least one field.
         *
         * Specify the fields using the `${field-id}` format, separated by spaces. For the CLI, surround this parameter value with single quotes on Linux or double quotes on Windows.
         */
        public var logFormat: kotlin.String? = null
        /**
         * The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.
         *
         * This parameter is valid only if the destination type is `cloud-watch-logs`.
         */
        public var logGroupName: kotlin.String? = null
        /**
         * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).
         *
         * When a network interface is attached to a [Nitro-based instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances), the aggregation interval is always 60 seconds or less, regardless of the value that you specify.
         *
         * Default: 600
         */
        public var maxAggregationInterval: kotlin.Int? = null
        /**
         * The IDs of the resources to monitor. For example, if the resource type is `VPC`, specify the IDs of the VPCs.
         *
         * Constraints: Maximum of 1000 resources
         */
        public var resourceIds: List<String>? = null
        /**
         * The type of resource to monitor.
         */
        public var resourceType: aws.sdk.kotlin.services.ec2.model.FlowLogsResourceType? = null
        /**
         * The tags to apply to the flow logs.
         */
        public var tagSpecifications: List<TagSpecification>? = null
        /**
         * The type of traffic to monitor (accepted traffic, rejected traffic, or all traffic).
         */
        public var trafficType: aws.sdk.kotlin.services.ec2.model.TrafficType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CreateFlowLogsRequest) : this() {
            this.clientToken = x.clientToken
            this.deliverCrossAccountRole = x.deliverCrossAccountRole
            this.deliverLogsPermissionArn = x.deliverLogsPermissionArn
            this.destinationOptions = x.destinationOptions
            this.dryRun = x.dryRun
            this.logDestination = x.logDestination
            this.logDestinationType = x.logDestinationType
            this.logFormat = x.logFormat
            this.logGroupName = x.logGroupName
            this.maxAggregationInterval = x.maxAggregationInterval
            this.resourceIds = x.resourceIds
            this.resourceType = x.resourceType
            this.tagSpecifications = x.tagSpecifications
            this.trafficType = x.trafficType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CreateFlowLogsRequest = CreateFlowLogsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.DestinationOptionsRequest] inside the given [block]
         */
        public fun destinationOptions(block: aws.sdk.kotlin.services.ec2.model.DestinationOptionsRequest.Builder.() -> kotlin.Unit) {
            this.destinationOptions = aws.sdk.kotlin.services.ec2.model.DestinationOptionsRequest.invoke(block)
        }
    }
}
