// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



public class CreateNatGatewayRequest private constructor(builder: Builder) {
    /**
     * &#91;Public NAT gateways only&#93; The allocation ID of an Elastic IP address to associate with the NAT gateway. You cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is associated with another resource, you must first disassociate it.
     */
    public val allocationId: kotlin.String? = builder.allocationId
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [How to ensure idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
     *
     * Constraint: Maximum 64 ASCII characters.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Indicates whether the NAT gateway supports public or private connectivity. The default is public connectivity.
     */
    public val connectivityType: aws.sdk.kotlin.services.ec2.model.ConnectivityType? = builder.connectivityType
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The subnet in which to create the NAT gateway.
     */
    public val subnetId: kotlin.String? = builder.subnetId
    /**
     * The tags to assign to the NAT gateway.
     */
    public val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CreateNatGatewayRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateNatGatewayRequest(")
        append("allocationId=$allocationId,")
        append("clientToken=$clientToken,")
        append("connectivityType=$connectivityType,")
        append("dryRun=$dryRun,")
        append("subnetId=$subnetId,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationId?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (connectivityType?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateNatGatewayRequest

        if (allocationId != other.allocationId) return false
        if (clientToken != other.clientToken) return false
        if (connectivityType != other.connectivityType) return false
        if (dryRun != other.dryRun) return false
        if (subnetId != other.subnetId) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CreateNatGatewayRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * &#91;Public NAT gateways only&#93; The allocation ID of an Elastic IP address to associate with the NAT gateway. You cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is associated with another resource, you must first disassociate it.
         */
        public var allocationId: kotlin.String? = null
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [How to ensure idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
         *
         * Constraint: Maximum 64 ASCII characters.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Indicates whether the NAT gateway supports public or private connectivity. The default is public connectivity.
         */
        public var connectivityType: aws.sdk.kotlin.services.ec2.model.ConnectivityType? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * The subnet in which to create the NAT gateway.
         */
        public var subnetId: kotlin.String? = null
        /**
         * The tags to assign to the NAT gateway.
         */
        public var tagSpecifications: List<TagSpecification>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CreateNatGatewayRequest) : this() {
            this.allocationId = x.allocationId
            this.clientToken = x.clientToken
            this.connectivityType = x.connectivityType
            this.dryRun = x.dryRun
            this.subnetId = x.subnetId
            this.tagSpecifications = x.tagSpecifications
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CreateNatGatewayRequest = CreateNatGatewayRequest(this)
    }
}
