// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



public class CreateSnapshotRequest private constructor(builder: Builder) {
    /**
     * A description for the snapshot.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.
     * + To create a snapshot of a volume in a Region, omit this parameter. The snapshot is created in the same Region as the volume.
     * + To create a snapshot of a volume on an Outpost and store the snapshot in the Region, omit this parameter. The snapshot is created in the Region for the Outpost.
     * + To create a snapshot of a volume on an Outpost and store the snapshot on an Outpost, specify the ARN of the destination Outpost. The snapshot must be created on the same Outpost as the volume.
     *
     * For more information, see [Create local snapshots from volumes on an Outpost](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-snapshot) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public val outpostArn: kotlin.String? = builder.outpostArn
    /**
     * The tags to apply to the snapshot during creation.
     */
    public val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The ID of the Amazon EBS volume.
     */
    public val volumeId: kotlin.String? = builder.volumeId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CreateSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSnapshotRequest(")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("outpostArn=$outpostArn,")
        append("tagSpecifications=$tagSpecifications,")
        append("volumeId=$volumeId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSnapshotRequest

        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (outpostArn != other.outpostArn) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (volumeId != other.volumeId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CreateSnapshotRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A description for the snapshot.
         */
        public var description: kotlin.String? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.
         * + To create a snapshot of a volume in a Region, omit this parameter. The snapshot is created in the same Region as the volume.
         * + To create a snapshot of a volume on an Outpost and store the snapshot in the Region, omit this parameter. The snapshot is created in the Region for the Outpost.
         * + To create a snapshot of a volume on an Outpost and store the snapshot on an Outpost, specify the ARN of the destination Outpost. The snapshot must be created on the same Outpost as the volume.
         *
         * For more information, see [Create local snapshots from volumes on an Outpost](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-snapshot) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        public var outpostArn: kotlin.String? = null
        /**
         * The tags to apply to the snapshot during creation.
         */
        public var tagSpecifications: List<TagSpecification>? = null
        /**
         * The ID of the Amazon EBS volume.
         */
        public var volumeId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CreateSnapshotRequest) : this() {
            this.description = x.description
            this.dryRun = x.dryRun
            this.outpostArn = x.outpostArn
            this.tagSpecifications = x.tagSpecifications
            this.volumeId = x.volumeId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CreateSnapshotRequest = CreateSnapshotRequest(this)
    }
}
