// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



public class CreateSnapshotsRequest private constructor(builder: Builder) {
    /**
     * Copies the tags from the specified volume to corresponding snapshot.
     */
    public val copyTagsFromSource: aws.sdk.kotlin.services.ec2.model.CopyTagsFromSource? = builder.copyTagsFromSource
    /**
     * A description propagated to every snapshot specified by the instance.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The instance to specify which volumes should be included in the snapshots.
     */
    public val instanceSpecification: aws.sdk.kotlin.services.ec2.model.InstanceSpecification? = builder.instanceSpecification
    /**
     * The Amazon Resource Name (ARN) of the Outpost on which to create the local snapshots.
     * + To create snapshots from an instance in a Region, omit this parameter. The snapshots are created in the same Region as the instance.
     * + To create snapshots from an instance on an Outpost and store the snapshots in the Region, omit this parameter. The snapshots are created in the Region for the Outpost.
     * + To create snapshots from an instance on an Outpost and store the snapshots on an Outpost, specify the ARN of the destination Outpost. The snapshots must be created on the same Outpost as the instance.
     *
     * For more information, see [ Create multi-volume local snapshots from instances on an Outpost](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-multivol-snapshot) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public val outpostArn: kotlin.String? = builder.outpostArn
    /**
     * Tags to apply to every snapshot specified by the instance.
     */
    public val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CreateSnapshotsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSnapshotsRequest(")
        append("copyTagsFromSource=$copyTagsFromSource,")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("instanceSpecification=$instanceSpecification,")
        append("outpostArn=$outpostArn,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = copyTagsFromSource?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (instanceSpecification?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSnapshotsRequest

        if (copyTagsFromSource != other.copyTagsFromSource) return false
        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (instanceSpecification != other.instanceSpecification) return false
        if (outpostArn != other.outpostArn) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CreateSnapshotsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Copies the tags from the specified volume to corresponding snapshot.
         */
        public var copyTagsFromSource: aws.sdk.kotlin.services.ec2.model.CopyTagsFromSource? = null
        /**
         * A description propagated to every snapshot specified by the instance.
         */
        public var description: kotlin.String? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * The instance to specify which volumes should be included in the snapshots.
         */
        public var instanceSpecification: aws.sdk.kotlin.services.ec2.model.InstanceSpecification? = null
        /**
         * The Amazon Resource Name (ARN) of the Outpost on which to create the local snapshots.
         * + To create snapshots from an instance in a Region, omit this parameter. The snapshots are created in the same Region as the instance.
         * + To create snapshots from an instance on an Outpost and store the snapshots in the Region, omit this parameter. The snapshots are created in the Region for the Outpost.
         * + To create snapshots from an instance on an Outpost and store the snapshots on an Outpost, specify the ARN of the destination Outpost. The snapshots must be created on the same Outpost as the instance.
         *
         * For more information, see [ Create multi-volume local snapshots from instances on an Outpost](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-multivol-snapshot) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        public var outpostArn: kotlin.String? = null
        /**
         * Tags to apply to every snapshot specified by the instance.
         */
        public var tagSpecifications: List<TagSpecification>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CreateSnapshotsRequest) : this() {
            this.copyTagsFromSource = x.copyTagsFromSource
            this.description = x.description
            this.dryRun = x.dryRun
            this.instanceSpecification = x.instanceSpecification
            this.outpostArn = x.outpostArn
            this.tagSpecifications = x.tagSpecifications
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CreateSnapshotsRequest = CreateSnapshotsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceSpecification] inside the given [block]
         */
        public fun instanceSpecification(block: aws.sdk.kotlin.services.ec2.model.InstanceSpecification.Builder.() -> kotlin.Unit) {
            this.instanceSpecification = aws.sdk.kotlin.services.ec2.model.InstanceSpecification.invoke(block)
        }
    }
}
