// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



public class CreateVpcRequest private constructor(builder: Builder) {
    /**
     * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the CIDR block.
     */
    public val amazonProvidedIpv6CidrBlock: kotlin.Boolean? = builder.amazonProvidedIpv6CidrBlock
    /**
     * The IPv4 network range for the VPC, in CIDR notation. For example, `10.0.0.0/16`. We modify the specified CIDR block to its canonical form; for example, if you specify `100.68.0.18/18`, we modify it to `100.68.0.0/18`.
     */
    public val cidrBlock: kotlin.String? = builder.cidrBlock
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The tenancy options for instances launched into the VPC. For `default`, instances are launched with shared tenancy by default. You can launch instances with any tenancy into a shared tenancy VPC. For `dedicated`, instances are launched as dedicated tenancy instances by default. You can only launch instances with a tenancy of `dedicated` or `host` into a dedicated tenancy VPC.
     *
     * **Important:** The `host` value cannot be used with this parameter. Use the `default` or `dedicated` values only.
     *
     * Default: `default`
     */
    public val instanceTenancy: aws.sdk.kotlin.services.ec2.model.Tenancy? = builder.instanceTenancy
    /**
     * The ID of an IPv4 IPAM pool you want to use for allocating this VPC's CIDR. For more information, see [What is IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html) in the *Amazon VPC IPAM User Guide*.
     */
    public val ipv4IpamPoolId: kotlin.String? = builder.ipv4IpamPoolId
    /**
     * The netmask length of the IPv4 CIDR you want to allocate to this VPC from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see [What is IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html) in the *Amazon VPC IPAM User Guide*.
     */
    public val ipv4NetmaskLength: kotlin.Int? = builder.ipv4NetmaskLength
    /**
     * The IPv6 CIDR block from the IPv6 address pool. You must also specify `Ipv6Pool` in the request.
     *
     * To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
     */
    public val ipv6CidrBlock: kotlin.String? = builder.ipv6CidrBlock
    /**
     * The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the address to this location.
     *
     *  You must set `AmazonProvidedIpv6CidrBlock` to `true` to use this parameter.
     */
    public val ipv6CidrBlockNetworkBorderGroup: kotlin.String? = builder.ipv6CidrBlockNetworkBorderGroup
    /**
     * The ID of an IPv6 IPAM pool which will be used to allocate this VPC an IPv6 CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization. For more information, see [What is IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html) in the *Amazon VPC IPAM User Guide*.
     */
    public val ipv6IpamPoolId: kotlin.String? = builder.ipv6IpamPoolId
    /**
     * The netmask length of the IPv6 CIDR you want to allocate to this VPC from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see [What is IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html) in the *Amazon VPC IPAM User Guide*.
     */
    public val ipv6NetmaskLength: kotlin.Int? = builder.ipv6NetmaskLength
    /**
     * The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
     */
    public val ipv6Pool: kotlin.String? = builder.ipv6Pool
    /**
     * The tags to assign to the VPC.
     */
    public val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CreateVpcRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateVpcRequest(")
        append("amazonProvidedIpv6CidrBlock=$amazonProvidedIpv6CidrBlock,")
        append("cidrBlock=$cidrBlock,")
        append("dryRun=$dryRun,")
        append("instanceTenancy=$instanceTenancy,")
        append("ipv4IpamPoolId=$ipv4IpamPoolId,")
        append("ipv4NetmaskLength=$ipv4NetmaskLength,")
        append("ipv6CidrBlock=$ipv6CidrBlock,")
        append("ipv6CidrBlockNetworkBorderGroup=$ipv6CidrBlockNetworkBorderGroup,")
        append("ipv6IpamPoolId=$ipv6IpamPoolId,")
        append("ipv6NetmaskLength=$ipv6NetmaskLength,")
        append("ipv6Pool=$ipv6Pool,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amazonProvidedIpv6CidrBlock?.hashCode() ?: 0
        result = 31 * result + (cidrBlock?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (instanceTenancy?.hashCode() ?: 0)
        result = 31 * result + (ipv4IpamPoolId?.hashCode() ?: 0)
        result = 31 * result + (ipv4NetmaskLength ?: 0)
        result = 31 * result + (ipv6CidrBlock?.hashCode() ?: 0)
        result = 31 * result + (ipv6CidrBlockNetworkBorderGroup?.hashCode() ?: 0)
        result = 31 * result + (ipv6IpamPoolId?.hashCode() ?: 0)
        result = 31 * result + (ipv6NetmaskLength ?: 0)
        result = 31 * result + (ipv6Pool?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateVpcRequest

        if (amazonProvidedIpv6CidrBlock != other.amazonProvidedIpv6CidrBlock) return false
        if (cidrBlock != other.cidrBlock) return false
        if (dryRun != other.dryRun) return false
        if (instanceTenancy != other.instanceTenancy) return false
        if (ipv4IpamPoolId != other.ipv4IpamPoolId) return false
        if (ipv4NetmaskLength != other.ipv4NetmaskLength) return false
        if (ipv6CidrBlock != other.ipv6CidrBlock) return false
        if (ipv6CidrBlockNetworkBorderGroup != other.ipv6CidrBlockNetworkBorderGroup) return false
        if (ipv6IpamPoolId != other.ipv6IpamPoolId) return false
        if (ipv6NetmaskLength != other.ipv6NetmaskLength) return false
        if (ipv6Pool != other.ipv6Pool) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CreateVpcRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the CIDR block.
         */
        public var amazonProvidedIpv6CidrBlock: kotlin.Boolean? = null
        /**
         * The IPv4 network range for the VPC, in CIDR notation. For example, `10.0.0.0/16`. We modify the specified CIDR block to its canonical form; for example, if you specify `100.68.0.18/18`, we modify it to `100.68.0.0/18`.
         */
        public var cidrBlock: kotlin.String? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * The tenancy options for instances launched into the VPC. For `default`, instances are launched with shared tenancy by default. You can launch instances with any tenancy into a shared tenancy VPC. For `dedicated`, instances are launched as dedicated tenancy instances by default. You can only launch instances with a tenancy of `dedicated` or `host` into a dedicated tenancy VPC.
         *
         * **Important:** The `host` value cannot be used with this parameter. Use the `default` or `dedicated` values only.
         *
         * Default: `default`
         */
        public var instanceTenancy: aws.sdk.kotlin.services.ec2.model.Tenancy? = null
        /**
         * The ID of an IPv4 IPAM pool you want to use for allocating this VPC's CIDR. For more information, see [What is IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html) in the *Amazon VPC IPAM User Guide*.
         */
        public var ipv4IpamPoolId: kotlin.String? = null
        /**
         * The netmask length of the IPv4 CIDR you want to allocate to this VPC from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see [What is IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html) in the *Amazon VPC IPAM User Guide*.
         */
        public var ipv4NetmaskLength: kotlin.Int? = null
        /**
         * The IPv6 CIDR block from the IPv6 address pool. You must also specify `Ipv6Pool` in the request.
         *
         * To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
         */
        public var ipv6CidrBlock: kotlin.String? = null
        /**
         * The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the address to this location.
         *
         *  You must set `AmazonProvidedIpv6CidrBlock` to `true` to use this parameter.
         */
        public var ipv6CidrBlockNetworkBorderGroup: kotlin.String? = null
        /**
         * The ID of an IPv6 IPAM pool which will be used to allocate this VPC an IPv6 CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization. For more information, see [What is IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html) in the *Amazon VPC IPAM User Guide*.
         */
        public var ipv6IpamPoolId: kotlin.String? = null
        /**
         * The netmask length of the IPv6 CIDR you want to allocate to this VPC from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see [What is IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html) in the *Amazon VPC IPAM User Guide*.
         */
        public var ipv6NetmaskLength: kotlin.Int? = null
        /**
         * The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
         */
        public var ipv6Pool: kotlin.String? = null
        /**
         * The tags to assign to the VPC.
         */
        public var tagSpecifications: List<TagSpecification>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CreateVpcRequest) : this() {
            this.amazonProvidedIpv6CidrBlock = x.amazonProvidedIpv6CidrBlock
            this.cidrBlock = x.cidrBlock
            this.dryRun = x.dryRun
            this.instanceTenancy = x.instanceTenancy
            this.ipv4IpamPoolId = x.ipv4IpamPoolId
            this.ipv4NetmaskLength = x.ipv4NetmaskLength
            this.ipv6CidrBlock = x.ipv6CidrBlock
            this.ipv6CidrBlockNetworkBorderGroup = x.ipv6CidrBlockNetworkBorderGroup
            this.ipv6IpamPoolId = x.ipv6IpamPoolId
            this.ipv6NetmaskLength = x.ipv6NetmaskLength
            this.ipv6Pool = x.ipv6Pool
            this.tagSpecifications = x.tagSpecifications
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CreateVpcRequest = CreateVpcRequest(this)
    }
}
