// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



public class DeleteIpamRequest private constructor(builder: Builder) {
    /**
     * Enables you to quickly delete an IPAM, private scopes, pools in private scopes, and any allocations in the pools in private scopes. You cannot delete the IPAM with this option if there is a pool in your public scope. If you use this option, IPAM does the following:
     * + Deallocates any CIDRs allocated to VPC resources (such as VPCs) in pools in private scopes.No VPC resources are deleted as a result of enabling this option. The CIDR associated with the resource will no longer be allocated from an IPAM pool, but the CIDR itself will remain unchanged.
     * + Deprovisions all IPv4 CIDRs provisioned to IPAM pools in private scopes.
     * + Deletes all IPAM pools in private scopes.
     * + Deletes all non-default private scopes in the IPAM.
     * + Deletes the default public and private scopes and the IPAM.
     */
    public val cascade: kotlin.Boolean? = builder.cascade
    /**
     * A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The ID of the IPAM to delete.
     */
    public val ipamId: kotlin.String? = builder.ipamId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DeleteIpamRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteIpamRequest(")
        append("cascade=$cascade,")
        append("dryRun=$dryRun,")
        append("ipamId=$ipamId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cascade?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (ipamId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteIpamRequest

        if (cascade != other.cascade) return false
        if (dryRun != other.dryRun) return false
        if (ipamId != other.ipamId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DeleteIpamRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Enables you to quickly delete an IPAM, private scopes, pools in private scopes, and any allocations in the pools in private scopes. You cannot delete the IPAM with this option if there is a pool in your public scope. If you use this option, IPAM does the following:
         * + Deallocates any CIDRs allocated to VPC resources (such as VPCs) in pools in private scopes.No VPC resources are deleted as a result of enabling this option. The CIDR associated with the resource will no longer be allocated from an IPAM pool, but the CIDR itself will remain unchanged.
         * + Deprovisions all IPv4 CIDRs provisioned to IPAM pools in private scopes.
         * + Deletes all IPAM pools in private scopes.
         * + Deletes all non-default private scopes in the IPAM.
         * + Deletes the default public and private scopes and the IPAM.
         */
        public var cascade: kotlin.Boolean? = null
        /**
         * A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * The ID of the IPAM to delete.
         */
        public var ipamId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DeleteIpamRequest) : this() {
            this.cascade = x.cascade
            this.dryRun = x.dryRun
            this.ipamId = x.ipamId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DeleteIpamRequest = DeleteIpamRequest(this)
    }
}
