// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



public class DescribeCapacityReservationsRequest private constructor(builder: Builder) {
    /**
     * The ID of the Capacity Reservation.
     */
    public val capacityReservationIds: List<String>? = builder.capacityReservationIds
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * One or more filters.
     * + `instance-type` - The type of instance for which the Capacity Reservation reserves capacity.
     * + `owner-id` - The ID of the Amazon Web Services account that owns the Capacity Reservation.
     * + `instance-platform` - The type of operating system for which the Capacity Reservation reserves capacity.
     * + `availability-zone` - The Availability Zone of the Capacity Reservation.
     * + `tenancy` - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:
     *    + `default` - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.
     *    + `dedicated` - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.
     * + `outpost-arn` - The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.
     * + `state` - The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
     *    + `active`- The Capacity Reservation is active and the capacity is available for your use.
     *    + `expired` - The Capacity Reservation expired automatically at the date and time specified in your request. The reserved capacity is no longer available for your use.
     *    + `cancelled` - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.
     *    + `pending` - The Capacity Reservation request was successful but the capacity provisioning is still pending.
     *    + `failed` - The Capacity Reservation request has failed. A request might fail due to invalid request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.
     * + `start-date` - The date and time at which the Capacity Reservation was started.
     * + `end-date` - The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to expired when it reaches its end date and time.
     * + `end-date-type` - Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:
     *    + `unlimited` - The Capacity Reservation remains active until you explicitly cancel it.
     *    + `limited` - The Capacity Reservation expires automatically at a specified date and time.
     * + `instance-match-criteria` - Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
     *    + `open` - The Capacity Reservation accepts all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation automatically without specifying any additional parameters.
     *    + `targeted` - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.
     * + `placement-group-arn` - The ARN of the cluster placement group in which the Capacity Reservation was created.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned `nextToken` value. This value can be between 5 and 500. If `maxResults` is given a larger value than 500, you receive an error.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to use to retrieve the next page of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeCapacityReservationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeCapacityReservationsRequest(")
        append("capacityReservationIds=$capacityReservationIds,")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityReservationIds?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeCapacityReservationsRequest

        if (capacityReservationIds != other.capacityReservationIds) return false
        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeCapacityReservationsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Capacity Reservation.
         */
        public var capacityReservationIds: List<String>? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * One or more filters.
         * + `instance-type` - The type of instance for which the Capacity Reservation reserves capacity.
         * + `owner-id` - The ID of the Amazon Web Services account that owns the Capacity Reservation.
         * + `instance-platform` - The type of operating system for which the Capacity Reservation reserves capacity.
         * + `availability-zone` - The Availability Zone of the Capacity Reservation.
         * + `tenancy` - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:
         *    + `default` - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.
         *    + `dedicated` - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.
         * + `outpost-arn` - The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.
         * + `state` - The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
         *    + `active`- The Capacity Reservation is active and the capacity is available for your use.
         *    + `expired` - The Capacity Reservation expired automatically at the date and time specified in your request. The reserved capacity is no longer available for your use.
         *    + `cancelled` - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.
         *    + `pending` - The Capacity Reservation request was successful but the capacity provisioning is still pending.
         *    + `failed` - The Capacity Reservation request has failed. A request might fail due to invalid request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.
         * + `start-date` - The date and time at which the Capacity Reservation was started.
         * + `end-date` - The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to expired when it reaches its end date and time.
         * + `end-date-type` - Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:
         *    + `unlimited` - The Capacity Reservation remains active until you explicitly cancel it.
         *    + `limited` - The Capacity Reservation expires automatically at a specified date and time.
         * + `instance-match-criteria` - Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
         *    + `open` - The Capacity Reservation accepts all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation automatically without specifying any additional parameters.
         *    + `targeted` - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.
         * + `placement-group-arn` - The ARN of the cluster placement group in which the Capacity Reservation was created.
         */
        public var filters: List<Filter>? = null
        /**
         * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned `nextToken` value. This value can be between 5 and 500. If `maxResults` is given a larger value than 500, you receive an error.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to use to retrieve the next page of results.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeCapacityReservationsRequest) : this() {
            this.capacityReservationIds = x.capacityReservationIds
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeCapacityReservationsRequest = DescribeCapacityReservationsRequest(this)
    }
}
