// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the instances that could not be launched by the fleet.
 */
public class DescribeFleetError private constructor(builder: Builder) {
    /**
     * The error code that indicates why the instance could not be launched. For more information about error codes, see [Error codes](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html).
     */
    public val errorCode: kotlin.String? = builder.errorCode
    /**
     * The error message that describes why the instance could not be launched. For more information about error messages, see [Error codes](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html).
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * The launch templates and overrides that were used for launching the instances. The values that you specify in the Overrides replace the values in the launch template.
     */
    public val launchTemplateAndOverrides: aws.sdk.kotlin.services.ec2.model.LaunchTemplateAndOverridesResponse? = builder.launchTemplateAndOverrides
    /**
     * Indicates if the instance that could not be launched was a Spot Instance or On-Demand Instance.
     */
    public val lifecycle: aws.sdk.kotlin.services.ec2.model.InstanceLifecycle? = builder.lifecycle

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeFleetError = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeFleetError(")
        append("errorCode=$errorCode,")
        append("errorMessage=$errorMessage,")
        append("launchTemplateAndOverrides=$launchTemplateAndOverrides,")
        append("lifecycle=$lifecycle)")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorCode?.hashCode() ?: 0
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateAndOverrides?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeFleetError

        if (errorCode != other.errorCode) return false
        if (errorMessage != other.errorMessage) return false
        if (launchTemplateAndOverrides != other.launchTemplateAndOverrides) return false
        if (lifecycle != other.lifecycle) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeFleetError = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The error code that indicates why the instance could not be launched. For more information about error codes, see [Error codes](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html).
         */
        public var errorCode: kotlin.String? = null
        /**
         * The error message that describes why the instance could not be launched. For more information about error messages, see [Error codes](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html).
         */
        public var errorMessage: kotlin.String? = null
        /**
         * The launch templates and overrides that were used for launching the instances. The values that you specify in the Overrides replace the values in the launch template.
         */
        public var launchTemplateAndOverrides: aws.sdk.kotlin.services.ec2.model.LaunchTemplateAndOverridesResponse? = null
        /**
         * Indicates if the instance that could not be launched was a Spot Instance or On-Demand Instance.
         */
        public var lifecycle: aws.sdk.kotlin.services.ec2.model.InstanceLifecycle? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeFleetError) : this() {
            this.errorCode = x.errorCode
            this.errorMessage = x.errorMessage
            this.launchTemplateAndOverrides = x.launchTemplateAndOverrides
            this.lifecycle = x.lifecycle
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeFleetError = DescribeFleetError(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateAndOverridesResponse] inside the given [block]
         */
        public fun launchTemplateAndOverrides(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplateAndOverridesResponse.Builder.() -> kotlin.Unit) {
            this.launchTemplateAndOverrides = aws.sdk.kotlin.services.ec2.model.LaunchTemplateAndOverridesResponse.invoke(block)
        }
    }
}
