// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the instances that were launched by the fleet.
 */
public class DescribeFleetsInstances private constructor(builder: Builder) {
    /**
     * The IDs of the instances.
     */
    public val instanceIds: List<String>? = builder.instanceIds
    /**
     * The instance type.
     */
    public val instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = builder.instanceType
    /**
     * The launch templates and overrides that were used for launching the instances. The values that you specify in the Overrides replace the values in the launch template.
     */
    public val launchTemplateAndOverrides: aws.sdk.kotlin.services.ec2.model.LaunchTemplateAndOverridesResponse? = builder.launchTemplateAndOverrides
    /**
     * Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.
     */
    public val lifecycle: aws.sdk.kotlin.services.ec2.model.InstanceLifecycle? = builder.lifecycle
    /**
     * The value is `Windows` for Windows instances. Otherwise, the value is blank.
     */
    public val platform: aws.sdk.kotlin.services.ec2.model.PlatformValues? = builder.platform

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeFleetsInstances = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeFleetsInstances(")
        append("instanceIds=$instanceIds,")
        append("instanceType=$instanceType,")
        append("launchTemplateAndOverrides=$launchTemplateAndOverrides,")
        append("lifecycle=$lifecycle,")
        append("platform=$platform)")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceIds?.hashCode() ?: 0
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateAndOverrides?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeFleetsInstances

        if (instanceIds != other.instanceIds) return false
        if (instanceType != other.instanceType) return false
        if (launchTemplateAndOverrides != other.launchTemplateAndOverrides) return false
        if (lifecycle != other.lifecycle) return false
        if (platform != other.platform) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeFleetsInstances = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The IDs of the instances.
         */
        public var instanceIds: List<String>? = null
        /**
         * The instance type.
         */
        public var instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = null
        /**
         * The launch templates and overrides that were used for launching the instances. The values that you specify in the Overrides replace the values in the launch template.
         */
        public var launchTemplateAndOverrides: aws.sdk.kotlin.services.ec2.model.LaunchTemplateAndOverridesResponse? = null
        /**
         * Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.
         */
        public var lifecycle: aws.sdk.kotlin.services.ec2.model.InstanceLifecycle? = null
        /**
         * The value is `Windows` for Windows instances. Otherwise, the value is blank.
         */
        public var platform: aws.sdk.kotlin.services.ec2.model.PlatformValues? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeFleetsInstances) : this() {
            this.instanceIds = x.instanceIds
            this.instanceType = x.instanceType
            this.launchTemplateAndOverrides = x.launchTemplateAndOverrides
            this.lifecycle = x.lifecycle
            this.platform = x.platform
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeFleetsInstances = DescribeFleetsInstances(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateAndOverridesResponse] inside the given [block]
         */
        public fun launchTemplateAndOverrides(block: aws.sdk.kotlin.services.ec2.model.LaunchTemplateAndOverridesResponse.Builder.() -> kotlin.Unit) {
            this.launchTemplateAndOverrides = aws.sdk.kotlin.services.ec2.model.LaunchTemplateAndOverridesResponse.invoke(block)
        }
    }
}
