// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



public class DescribeFlowLogsRequest private constructor(builder: Builder) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * One or more filters.
     * + `deliver-log-status` - The status of the logs delivery (`SUCCESS` | `FAILED`).
     * + `log-destination-type` - The type of destination for the flow log data (`cloud-watch-logs` | `s3` | `kinesis-data-firehose`).
     * + `flow-log-id` - The ID of the flow log.
     * + `log-group-name` - The name of the log group.
     * + `resource-id` - The ID of the VPC, subnet, or network interface.
     * + `traffic-type` - The type of traffic (`ACCEPT` | `REJECT` | `ALL`).
     * + `tag`:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
     * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
     */
    public val filter: List<Filter>? = builder.filter
    /**
     * One or more flow log IDs.
     *
     * Constraint: Maximum of 1000 flow log IDs.
     */
    public val flowLogIds: List<String>? = builder.flowLogIds
    /**
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned `nextToken` value.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next page of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeFlowLogsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeFlowLogsRequest(")
        append("dryRun=$dryRun,")
        append("filter=$filter,")
        append("flowLogIds=$flowLogIds,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (flowLogIds?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeFlowLogsRequest

        if (dryRun != other.dryRun) return false
        if (filter != other.filter) return false
        if (flowLogIds != other.flowLogIds) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeFlowLogsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * One or more filters.
         * + `deliver-log-status` - The status of the logs delivery (`SUCCESS` | `FAILED`).
         * + `log-destination-type` - The type of destination for the flow log data (`cloud-watch-logs` | `s3` | `kinesis-data-firehose`).
         * + `flow-log-id` - The ID of the flow log.
         * + `log-group-name` - The name of the log group.
         * + `resource-id` - The ID of the VPC, subnet, or network interface.
         * + `traffic-type` - The type of traffic (`ACCEPT` | `REJECT` | `ALL`).
         * + `tag`:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
         * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         */
        public var filter: List<Filter>? = null
        /**
         * One or more flow log IDs.
         *
         * Constraint: Maximum of 1000 flow log IDs.
         */
        public var flowLogIds: List<String>? = null
        /**
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned `nextToken` value.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next page of results.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeFlowLogsRequest) : this() {
            this.dryRun = x.dryRun
            this.filter = x.filter
            this.flowLogIds = x.flowLogIds
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeFlowLogsRequest = DescribeFlowLogsRequest(this)
    }
}
