// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



public class DescribeHostsRequest private constructor(builder: Builder) {
    /**
     * The filters.
     * + `auto-placement` - Whether auto-placement is enabled or disabled (`on` | `off`).
     * + `availability-zone` - The Availability Zone of the host.
     * + `client-token` - The idempotency token that you provided when you allocated the host.
     * + `host-reservation-id` - The ID of the reservation assigned to this host.
     * + `instance-type` - The instance type size that the Dedicated Host is configured to support.
     * + `state` - The allocation state of the Dedicated Host (`available` | `under-assessment` | `permanent-failure` | `released` | `released-permanent-failure`).
     * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
     */
    public val filter: List<Filter>? = builder.filter
    /**
     * The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.
     */
    public val hostIds: List<String>? = builder.hostIds
    /**
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned `nextToken` value. This value can be between 5 and 500. If `maxResults` is given a larger value than 500, you receive an error.
     *
     * You cannot specify this parameter and the host IDs parameter in the same request.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to use to retrieve the next page of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeHostsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeHostsRequest(")
        append("filter=$filter,")
        append("hostIds=$hostIds,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (hostIds?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeHostsRequest

        if (filter != other.filter) return false
        if (hostIds != other.hostIds) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeHostsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The filters.
         * + `auto-placement` - Whether auto-placement is enabled or disabled (`on` | `off`).
         * + `availability-zone` - The Availability Zone of the host.
         * + `client-token` - The idempotency token that you provided when you allocated the host.
         * + `host-reservation-id` - The ID of the reservation assigned to this host.
         * + `instance-type` - The instance type size that the Dedicated Host is configured to support.
         * + `state` - The allocation state of the Dedicated Host (`available` | `under-assessment` | `permanent-failure` | `released` | `released-permanent-failure`).
         * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         */
        public var filter: List<Filter>? = null
        /**
         * The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.
         */
        public var hostIds: List<String>? = null
        /**
         * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned `nextToken` value. This value can be between 5 and 500. If `maxResults` is given a larger value than 500, you receive an error.
         *
         * You cannot specify this parameter and the host IDs parameter in the same request.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to use to retrieve the next page of results.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeHostsRequest) : this() {
            this.filter = x.filter
            this.hostIds = x.hostIds
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeHostsRequest = DescribeHostsRequest(this)
    }
}
