// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



public class DescribeLaunchTemplateVersionsRequest private constructor(builder: Builder) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * One or more filters.
     * + `create-time` - The time the launch template version was created.
     * + `ebs-optimized` - A boolean that indicates whether the instance is optimized for Amazon EBS I/O.
     * + `http-endpoint` - Indicates whether the HTTP metadata endpoint on your instances is enabled (`enabled` | `disabled`).
     * + `http-protocol-ipv4` - Indicates whether the IPv4 endpoint for the instance metadata service is enabled (`enabled` | `disabled`).
     * + `host-resource-group-arn` - The ARN of the host resource group in which to launch the instances.
     * + `http-tokens` - The state of token usage for your instance metadata requests (`optional` | `required`).
     * + `iam-instance-profile` - The ARN of the IAM instance profile.
     * + `image-id` - The ID of the AMI.
     * + `instance-type` - The instance type.
     * + `is-default-version` - A boolean that indicates whether the launch template version is the default version.
     * + `kernel-id` - The kernel ID.
     * + `license-configuration-arn` - The ARN of the license configuration.
     * + `network-card-index` - The index of the network card.
     * + `ram-disk-id` - The RAM disk ID.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The ID of the launch template.
     *
     * To describe one or more versions of a specified launch template, you must specify either the `LaunchTemplateId` or the `LaunchTemplateName`, but not both.
     *
     * To describe all the latest or default launch template versions in your account, you must omit this parameter.
     */
    public val launchTemplateId: kotlin.String? = builder.launchTemplateId
    /**
     * The name of the launch template.
     *
     * To describe one or more versions of a specified launch template, you must specify either the `LaunchTemplateName` or the `LaunchTemplateId`, but not both.
     *
     * To describe all the latest or default launch template versions in your account, you must omit this parameter.
     */
    public val launchTemplateName: kotlin.String? = builder.launchTemplateName
    /**
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned `NextToken` value. This value can be between 1 and 200.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The version number up to which to describe launch template versions.
     */
    public val maxVersion: kotlin.String? = builder.maxVersion
    /**
     * The version number after which to describe launch template versions.
     */
    public val minVersion: kotlin.String? = builder.minVersion
    /**
     * The token to request the next page of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * One or more versions of the launch template. Valid values depend on whether you are describing a specified launch template (by ID or name) or all launch templates in your account.
     *
     * To describe one or more versions of a specified launch template, valid values are `$Latest`, `$Default`, and numbers.
     *
     * To describe all launch templates in your account that are defined as the latest version, the valid value is `$Latest`. To describe all launch templates in your account that are defined as the default version, the valid value is `$Default`. You can specify `$Latest` and `$Default` in the same request. You cannot specify numbers.
     */
    public val versions: List<String>? = builder.versions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeLaunchTemplateVersionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeLaunchTemplateVersionsRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("launchTemplateId=$launchTemplateId,")
        append("launchTemplateName=$launchTemplateName,")
        append("maxResults=$maxResults,")
        append("maxVersion=$maxVersion,")
        append("minVersion=$minVersion,")
        append("nextToken=$nextToken,")
        append("versions=$versions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateId?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateName?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (maxVersion?.hashCode() ?: 0)
        result = 31 * result + (minVersion?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (versions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeLaunchTemplateVersionsRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (launchTemplateId != other.launchTemplateId) return false
        if (launchTemplateName != other.launchTemplateName) return false
        if (maxResults != other.maxResults) return false
        if (maxVersion != other.maxVersion) return false
        if (minVersion != other.minVersion) return false
        if (nextToken != other.nextToken) return false
        if (versions != other.versions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeLaunchTemplateVersionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * One or more filters.
         * + `create-time` - The time the launch template version was created.
         * + `ebs-optimized` - A boolean that indicates whether the instance is optimized for Amazon EBS I/O.
         * + `http-endpoint` - Indicates whether the HTTP metadata endpoint on your instances is enabled (`enabled` | `disabled`).
         * + `http-protocol-ipv4` - Indicates whether the IPv4 endpoint for the instance metadata service is enabled (`enabled` | `disabled`).
         * + `host-resource-group-arn` - The ARN of the host resource group in which to launch the instances.
         * + `http-tokens` - The state of token usage for your instance metadata requests (`optional` | `required`).
         * + `iam-instance-profile` - The ARN of the IAM instance profile.
         * + `image-id` - The ID of the AMI.
         * + `instance-type` - The instance type.
         * + `is-default-version` - A boolean that indicates whether the launch template version is the default version.
         * + `kernel-id` - The kernel ID.
         * + `license-configuration-arn` - The ARN of the license configuration.
         * + `network-card-index` - The index of the network card.
         * + `ram-disk-id` - The RAM disk ID.
         */
        public var filters: List<Filter>? = null
        /**
         * The ID of the launch template.
         *
         * To describe one or more versions of a specified launch template, you must specify either the `LaunchTemplateId` or the `LaunchTemplateName`, but not both.
         *
         * To describe all the latest or default launch template versions in your account, you must omit this parameter.
         */
        public var launchTemplateId: kotlin.String? = null
        /**
         * The name of the launch template.
         *
         * To describe one or more versions of a specified launch template, you must specify either the `LaunchTemplateName` or the `LaunchTemplateId`, but not both.
         *
         * To describe all the latest or default launch template versions in your account, you must omit this parameter.
         */
        public var launchTemplateName: kotlin.String? = null
        /**
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned `NextToken` value. This value can be between 1 and 200.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The version number up to which to describe launch template versions.
         */
        public var maxVersion: kotlin.String? = null
        /**
         * The version number after which to describe launch template versions.
         */
        public var minVersion: kotlin.String? = null
        /**
         * The token to request the next page of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * One or more versions of the launch template. Valid values depend on whether you are describing a specified launch template (by ID or name) or all launch templates in your account.
         *
         * To describe one or more versions of a specified launch template, valid values are `$Latest`, `$Default`, and numbers.
         *
         * To describe all launch templates in your account that are defined as the latest version, the valid value is `$Latest`. To describe all launch templates in your account that are defined as the default version, the valid value is `$Default`. You can specify `$Latest` and `$Default` in the same request. You cannot specify numbers.
         */
        public var versions: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeLaunchTemplateVersionsRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.launchTemplateId = x.launchTemplateId
            this.launchTemplateName = x.launchTemplateName
            this.maxResults = x.maxResults
            this.maxVersion = x.maxVersion
            this.minVersion = x.minVersion
            this.nextToken = x.nextToken
            this.versions = x.versions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeLaunchTemplateVersionsRequest = DescribeLaunchTemplateVersionsRequest(this)
    }
}
